/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.GeometricTokenStream;
import com.google.apphosting.api.search.DocumentPb;
import com.google.common.geometry.S2LatLng;
import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;

class GeometricField
extends AbstractField {
    static final double EARTH_RADIUS_METERS = 6371010.0;
    static final int MIN_LEVEL = 0;
    static final int MAX_LEVEL = 30;

    GeometricField(String name, DocumentPb.FieldValue.Geo value) {
        super(name, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.NO);
        this.fieldsData = value;
    }

    private DocumentPb.FieldValue.Geo data() {
        if (this.fieldsData instanceof DocumentPb.FieldValue.Geo) {
            return (DocumentPb.FieldValue.Geo)this.fieldsData;
        }
        return null;
    }

    public String stringValue() {
        DocumentPb.FieldValue.Geo data = this.data();
        return data != null ? data.getLat() + "," + data.getLng() : null;
    }

    public Reader readerValue() {
        return null;
    }

    public byte[] binaryValue() {
        return null;
    }

    public TokenStream tokenStreamValue() {
        DocumentPb.FieldValue.Geo value = this.data();
        S2LatLng point = S2LatLng.fromDegrees((double)value.getLat(), (double)value.getLng());
        return new GeometricTokenStream(point.normalized());
    }
}

