/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.proto.SearchServicePb;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

final class FacetNode
implements Comparable<FacetNode> {
    final String name;
    private int count;
    private Double min;
    private Double max;
    private int minMaxCount;
    private final Map<String, Value> valueMap = new LinkedHashMap<String, Value>();
    final int valueLimit;

    FacetNode(String name, int valueLimit) {
        this.name = name;
        this.valueLimit = valueLimit;
        this.count = 0;
    }

    Collection<Value> getValues() {
        return Collections.unmodifiableCollection(this.valueMap.values());
    }

    Value getValue(String label) {
        return this.valueMap.get(label);
    }

    int getCount() {
        return this.count + this.minMaxCount;
    }

    Double getMin() {
        return this.min;
    }

    Double getMax() {
        return this.max;
    }

    int getMinMaxCount() {
        return this.minMaxCount;
    }

    void addValue(String valueToAdd, int countToAdd) {
        this.addValue(valueToAdd, countToAdd, null);
    }

    void addValue(String valueToAdd, int countToAdd, SearchServicePb.FacetRange range) {
        Value v = this.valueMap.get(valueToAdd);
        if (v == null) {
            v = new Value(valueToAdd, 0, range);
            this.valueMap.put(valueToAdd, v);
        }
        v.incCount(countToAdd);
        this.count += countToAdd;
    }

    void addNumericValue(double value) {
        if (this.min == null || this.min > value) {
            this.min = value;
        }
        if (this.max == null || this.max < value) {
            this.max = value;
        }
        ++this.minMaxCount;
    }

    @Override
    public int compareTo(FacetNode other) {
        return Integer.compare(other.getCount(), this.getCount());
    }

    static final class Value
    implements Comparable<Value> {
        final String label;
        private int count;
        SearchServicePb.FacetRange range;

        Value(String label, int count, SearchServicePb.FacetRange range) {
            this.label = label;
            this.count = count;
            this.range = range;
        }

        Value(String label) {
            this(label, 0, null);
        }

        void incCount(int amount) {
            this.count += amount;
        }

        int getCount() {
            return this.count;
        }

        @Override
        public int compareTo(Value other) {
            return Integer.compare(other.count, this.count);
        }
    }
}

