/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.EvaluationException;
import com.google.appengine.api.search.dev.NumericExpression;
import com.google.common.collect.ImmutableMap;
import java.util.function.DoubleBinaryOperator;
import org.apache.lucene.document.Document;

final class BinaryNumericExpression
extends NumericExpression {
    private final DoubleBinaryOperator op;
    private final NumericExpression left;
    private final NumericExpression right;
    private static final ImmutableMap<Integer, DoubleBinaryOperator> BINARY_OPS = ImmutableMap.builder().put((Object)54, (a, b) -> a * b).put((Object)14, (a, b) -> a / b).put((Object)46, (a, b) -> a + b).put((Object)36, (a, b) -> a - b).put((Object)47, Math::pow).put((Object)33, (a, b) -> BinaryNumericExpression.truth(a < b)).put((Object)24, (a, b) -> BinaryNumericExpression.truth(a > b)).put((Object)29, (a, b) -> BinaryNumericExpression.truth(a <= b)).put((Object)17, (a, b) -> BinaryNumericExpression.truth(a == b)).put((Object)39, (a, b) -> BinaryNumericExpression.truth(a != b)).put((Object)21, (a, b) -> BinaryNumericExpression.truth(a >= b)).buildOrThrow();

    private BinaryNumericExpression(DoubleBinaryOperator op, NumericExpression left, NumericExpression right) {
        this.left = left;
        this.right = right;
        this.op = op;
    }

    @Override
    public double evalDouble(Document doc) throws EvaluationException {
        double leftValue = this.left.evalDouble(doc);
        double rightValue = this.right.evalDouble(doc);
        return this.op.applyAsDouble(leftValue, rightValue);
    }

    private static double truth(boolean b) {
        return b ? 1.0 : 0.0;
    }

    static BinaryNumericExpression make(int type, NumericExpression left, NumericExpression right) {
        return new BinaryNumericExpression((DoubleBinaryOperator)BINARY_OPS.get((Object)type), left, right);
    }
}

