/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.dev.LocalCompositeIndexManager;
import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.api.datastore.dev.Utils;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LocalDatastoreCostAnalysis {
    private static final BigDecimal ONE_MILLION = new BigDecimal(1000000);
    private static final BigDecimal DOLLARS_PER_WRITE = BigDecimal.ONE.divide(ONE_MILLION);
    private static final BigDecimal PENNIES_PER_WRITE = DOLLARS_PER_WRITE.divide(new BigDecimal(100));
    private final LocalCompositeIndexManager indexManager;

    public LocalDatastoreCostAnalysis(LocalCompositeIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    static BigDecimal writesToPennies(int writes) {
        return PENNIES_PER_WRITE.multiply(new BigDecimal(writes));
    }

    public DatastoreV3Pb.Cost getWriteCost(OnestoreEntity.EntityProto newEntity) {
        return this.getWriteOps(null, newEntity);
    }

    public DatastoreV3Pb.Cost getWriteOps(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OnestoreEntity.EntityProto oldEntity, OnestoreEntity.EntityProto newEntity) {
        DatastoreV3Pb.Cost cost = new DatastoreV3Pb.Cost().setEntityWrites(0).setIndexWrites(0);
        if (LocalDatastoreService.equalProperties(oldEntity, newEntity)) {
            return cost;
        }
        cost.setEntityWrites(1);
        int indexWrites = this.changedIndexRows(oldEntity, newEntity);
        if (oldEntity == null) {
            ++indexWrites;
        }
        return cost.setIndexWrites(indexWrites);
    }

    private int changedIndexRows(OnestoreEntity.EntityProto oldEntity, OnestoreEntity.EntityProto newEntity) {
        HashMultimap uniqueOldProperties = HashMultimap.create();
        if (oldEntity != null) {
            for (OnestoreEntity.Property oldProp : oldEntity.propertys()) {
                oldProp = oldProp.isMultiple() ? ((OnestoreEntity.Property)oldProp.clone()).setMultiple(false) : oldProp;
                uniqueOldProperties.put((Object)oldProp.getName(), (Object)oldProp);
            }
        }
        HashMultimap uniqueNewProperties = HashMultimap.create();
        HashMultiset unchanged = HashMultiset.create();
        for (OnestoreEntity.Property newProp : newEntity.propertys()) {
            newProp = newProp.isMultiple() ? ((OnestoreEntity.Property)newProp.clone()).setMultiple(false) : newProp;
            uniqueNewProperties.put((Object)newProp.getName(), (Object)newProp);
            if (!uniqueOldProperties.containsEntry((Object)newProp.getName(), (Object)newProp)) continue;
            unchanged.add((Object)newProp.getName());
        }
        HashSet allPropertyNames = Sets.newHashSet((Iterable)Iterables.concat((Iterable)uniqueOldProperties.keySet(), (Iterable)uniqueNewProperties.keySet()));
        Iterable allIndexes = Iterables.concat(this.indexManager.getIndexesForKind(Utils.getKind(newEntity.getKey())), LocalDatastoreCostAnalysis.getEntityByPropertyIndexes(allPropertyNames));
        Multiset uniqueOldPropertyNames = uniqueOldProperties.keys();
        Multiset uniqueNewPropertyNames = uniqueNewProperties.keys();
        int pathSize = newEntity.getKey().getPath().elementSize();
        int writes = 0;
        for (OnestoreEntity.Index index : allIndexes) {
            int ancestorMultiplier = index.isAncestor() && index.propertySize() > 1 ? pathSize : 1;
            writes += this.calculateWritesForCompositeIndex(index, (Multiset<String>)uniqueOldPropertyNames, (Multiset<String>)uniqueNewPropertyNames, (Multiset<String>)unchanged) * ancestorMultiplier;
        }
        return writes;
    }

    private int calculateWritesForCompositeIndex(OnestoreEntity.Index index, Multiset<String> uniqueOldProperties, Multiset<String> uniqueNewProperties, Multiset<String> commonProperties) {
        int oldCount = 1;
        int newCount = 1;
        int commonCount = 1;
        for (OnestoreEntity.Index.Property prop : index.propertys()) {
            oldCount *= uniqueOldProperties.count((Object)prop.getName());
            newCount *= uniqueNewProperties.count((Object)prop.getName());
            commonCount *= commonProperties.count((Object)prop.getName());
        }
        return oldCount - commonCount + (newCount - commonCount);
    }

    static List<OnestoreEntity.Index> getEntityByPropertyIndexes(Set<String> propertyNames) {
        List sortedPropertyNames = Ordering.natural().sortedCopy(propertyNames);
        ArrayList indexes = Lists.newArrayList();
        for (String propName : sortedPropertyNames) {
            OnestoreEntity.Index index = new OnestoreEntity.Index();
            index.addProperty(new OnestoreEntity.Index.Property().setName(propName).setDirection(OnestoreEntity.Index.Property.Direction.ASCENDING));
            indexes.add(index);
            index = new OnestoreEntity.Index();
            index.addProperty(new OnestoreEntity.Index.Property().setName(propName).setDirection(OnestoreEntity.Index.Property.Direction.DESCENDING));
            indexes.add(index);
        }
        return indexes;
    }
}

