/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.datastore.v1.Entity;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionId;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionIdOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Value;
import com.google.appengine.repackaged.com.google.datastore.v1.ValueOrBuilder;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.BaseDatastoreValidator;
import com.google.apphosting.datastore.shared.Config;
import com.google.apphosting.datastore.shared.DatastoreHelper;
import com.google.apphosting.datastore.shared.EntityV1Validator;
import com.google.apphosting.datastore.shared.EntityV4Converter;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.ProjectIdAppIdResolver;
import com.google.apphosting.datastore.shared.UserValueObfuscator;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;

public class EntityV4Validator
extends BaseDatastoreValidator {
    private final EntityV1Validator validatorV1;
    private final EntityV4Converter entityV4Converter;

    public EntityV4Validator(Config.DatastoreConfig config) {
        super(config);
        this.validatorV1 = new EntityV1Validator(config){

            @Override
            public void validateProjectId(ValidationConstraint constraint, String projectId) throws ValidationException {
                this.validateAppOrProjectId(constraint, DatastoreHelper.APP_ID_REGEX, projectId, "project id");
            }
        };
        this.entityV4Converter = new EntityV4Converter(false, UserValueObfuscator.IDENTITY);
    }

    public void validateEntities(ValidationConstraint constraint, Iterable<? extends EntityV4.EntityOrBuilder> entities) throws ValidationException {
        for (EntityV4.EntityOrBuilder entityOrBuilder : entities) {
            this.validateEntity(constraint, entityOrBuilder);
        }
    }

    public void validateKeys(ValidationConstraint constraint, Iterable<? extends EntityV4.KeyOrBuilder> keys) throws ValidationException {
        for (EntityV4.KeyOrBuilder keyOrBuilder : keys) {
            this.validateKey(constraint, keyOrBuilder);
        }
    }

    EntityV1Validator getEntityV1Validator() {
        return this.validatorV1;
    }

    public void validateEntity(ValidationConstraint constraint, EntityV4.EntityOrBuilder entity) throws ValidationException {
        try {
            this.validatorV1.validateEntity(constraint, (EntityOrBuilder)this.toV1Entity(entity));
        }
        catch (ValidationException e) {
            throw EntityV4Validator.toV4ValidationException(e);
        }
    }

    public void validateKey(ValidationConstraint constraint, EntityV4.KeyOrBuilder key) throws ValidationException {
        try {
            this.validatorV1.validateKey(constraint, (KeyOrBuilder)this.toV1Key(key));
        }
        catch (ValidationException e) {
            throw EntityV4Validator.toV4ValidationException(e);
        }
    }

    public void validatePartitionId(ValidationConstraint constraint, EntityV4.PartitionIdOrBuilder partitionId) throws ValidationException {
        try {
            this.validatorV1.validatePartitionId(constraint, (PartitionIdOrBuilder)this.toV1PartitionId(partitionId));
        }
        catch (ValidationException e) {
            throw EntityV4Validator.toV4ValidationException(e);
        }
    }

    public void validateProperty(ValidationConstraint constraint, EntityV4.PropertyOrBuilder property) throws ValidationException {
        try {
            this.validatorV1.validateProperty(constraint, property.getNameBytes(), (ValueOrBuilder)this.toV1Value(property).build());
        }
        catch (ValidationException e) {
            throw EntityV4Validator.toV4ValidationException(e);
        }
    }

    void validateValue(ValidationConstraint constraint, EntityV4.ValueOrBuilder value, String desc) throws ValidationException {
        try {
            this.validatorV1.validateValue(constraint, (ValueOrBuilder)this.toV1Value(value, desc).build(), 0, 0, desc);
        }
        catch (ValidationException e) {
            throw EntityV4Validator.toV4ValidationException(e);
        }
    }

    private Entity.Builder toV1Entity(EntityV4.EntityOrBuilder entityV4) throws ValidationException {
        try {
            return this.entityV4Converter.toV1Entity(ProjectIdAppIdResolver.IDENTITY, entityV4);
        }
        catch (InvalidConversionException e) {
            throw new ValidationException(e.getMessage(), e);
        }
    }

    private PartitionId.Builder toV1PartitionId(EntityV4.PartitionIdOrBuilder partitionIdV4) throws ValidationException {
        try {
            return this.entityV4Converter.toV1PartitionId(ProjectIdAppIdResolver.IDENTITY, partitionIdV4);
        }
        catch (InvalidConversionException e) {
            throw new ValidationException(e.getMessage(), e);
        }
    }

    private Value.Builder toV1Value(EntityV4.PropertyOrBuilder propertyV4) throws ValidationException {
        try {
            return this.entityV4Converter.toV1Value(ProjectIdAppIdResolver.IDENTITY, propertyV4);
        }
        catch (InvalidConversionException e) {
            throw new ValidationException(e.getMessage(), e);
        }
    }

    private Value.Builder toV1Value(EntityV4.ValueOrBuilder valueV4, String desc) throws ValidationException {
        try {
            return this.entityV4Converter.toV1Value(ProjectIdAppIdResolver.IDENTITY, valueV4, desc);
        }
        catch (InvalidConversionException e) {
            throw new ValidationException(e.getMessage(), e);
        }
    }

    private Key.Builder toV1Key(EntityV4.KeyOrBuilder keyV4) throws ValidationException {
        try {
            return this.entityV4Converter.toV1Key(ProjectIdAppIdResolver.IDENTITY, keyV4);
        }
        catch (InvalidConversionException e) {
            throw new ValidationException(e.getMessage(), e);
        }
    }

    public static ValidationException toV4ValidationException(ValidationException exceptionV1) {
        return new ValidationException(exceptionV1.getMessage().replaceAll("project id", "dataset id").replaceAll("namespace id", "namespace").replaceAll("timestamp_value", "timestamp_microseconds_value").replaceAll("GQL query parameter", "GQL query argument"), exceptionV1);
    }
}

