/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitResponseOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.MutationResult;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequestOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.BaseDatastoreServiceProtoConverter;
import com.google.apphosting.datastore.shared.DatastoreProtoConverter;
import com.google.apphosting.datastore.shared.EntityV4Converter;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.ProjectIdAppIdResolver;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;

public abstract class DatastoreServiceProtoConverter
extends BaseDatastoreServiceProtoConverter {
    protected DatastoreServiceProtoConverter(DatastoreProtoConverter datastoreConverter) {
        super(datastoreConverter);
    }

    public DatastoreProtoConverter getDatastoreProtoConverter() {
        return this.datastoreConverter;
    }

    protected abstract DatastorePb.Cursor toV3Cursor(ByteString var1) throws InvalidConversionException;

    protected abstract ByteString toV4QueryHandle(DatastorePb.Cursor var1) throws InvalidConversionException;

    public BeginTransactionResponse.Builder toV1BeginTransactionResponse(DatastorePb.Transaction txnV3) throws InvalidConversionException {
        BeginTransactionResponse.Builder resV1 = BeginTransactionResponse.newBuilder();
        resV1.setTransaction(this.toTransactionBytes(txnV3));
        return resV1;
    }

    public DatastorePb.Transaction toV3Transaction(RollbackRequestOrBuilder reqV1, String appId, String databaseId) throws InvalidConversionException {
        return this.toV3Transaction(reqV1.getTransaction(), appId, databaseId);
    }

    public DatastorePb.GetRequest toV3GetRequest(DatastoreV4.LookupRequestOrBuilder req, String appId, String databaseId) throws InvalidConversionException {
        DatastorePb.GetRequest get = new DatastorePb.GetRequest();
        get.setAllowDeferred(true);
        if (req.getReadOptionsOrBuilder().getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.EVENTUAL) {
            get.setFailoverMs(-1L);
        } else if (req.getReadOptionsOrBuilder().getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.STRONG) {
            get.setStrong(true);
        }
        if (req.getReadOptionsOrBuilder().hasTransaction()) {
            get.setTransaction(this.toV3Transaction(req.getReadOptionsOrBuilder().getTransaction(), appId, databaseId));
        }
        for (EntityV4.Key key : req.getKeyList()) {
            get.addKey(this.datastoreConverter.getEntityConverter().toV3Reference((EntityV4.KeyOrBuilder)key));
        }
        return get;
    }

    DatastoreV4.LookupRequest.Builder toV4LookupRequest(DatastorePb.GetRequest req) throws InvalidConversionException {
        DatastoreV4.LookupRequest.Builder builder = DatastoreV4.LookupRequest.newBuilder();
        InvalidConversionException.checkConversion(req.isAllowDeferred(), "allow_deferred must be true", new Object[0]);
        InvalidConversionException.checkConversion(!req.hasTransaction() || !req.hasFailoverMs(), "Cannot set failover and transaction handle.", new Object[0]);
        if (req.hasTransaction()) {
            builder.getReadOptionsBuilder().setTransaction(this.toTransactionBytes(req.getTransaction()));
        } else if (req.isStrong()) {
            builder.getReadOptionsBuilder().setReadConsistency(DatastoreV4.ReadOptions.ReadConsistency.STRONG);
        } else if (req.hasFailoverMs()) {
            builder.getReadOptionsBuilder().setReadConsistency(DatastoreV4.ReadOptions.ReadConsistency.EVENTUAL);
        }
        for (OnestoreEntity.Reference key : req.keys()) {
            builder.addKey(this.datastoreConverter.getEntityConverter().toV4Key(key));
        }
        return builder;
    }

    public DatastoreV4.LookupResponse.Builder toV4LookupResponse(DatastorePb.GetResponse res) throws InvalidConversionException {
        DatastoreV4.LookupResponse.Builder builder = DatastoreV4.LookupResponse.newBuilder();
        EntityV4Converter entityV4Converter = this.datastoreConverter.getEntityConverter();
        for (OnestoreEntity.Reference key : res.deferreds()) {
            builder.addDeferred(entityV4Converter.toV4Key(key));
        }
        for (DatastorePb.GetResponse.Entity entity : res.entitys()) {
            DatastoreV4.EntityResult.Builder entityResult = this.datastoreConverter.toV4EntityResult(entity);
            if (entity.hasEntity()) {
                builder.addFound(entityResult);
            }
            if (!entity.hasKey()) continue;
            builder.addMissing(entityResult);
        }
        return builder;
    }

    DatastorePb.GetResponse toV3GetResponse(DatastoreV4.LookupResponseOrBuilder res) throws InvalidConversionException {
        DatastorePb.GetResponse result = new DatastorePb.GetResponse();
        result.setInOrder(false);
        EntityV4Converter entityV4Converter = this.datastoreConverter.getEntityConverter();
        for (EntityV4.Key key : res.getDeferredList()) {
            result.addDeferred(entityV4Converter.toV3Reference((EntityV4.KeyOrBuilder)key));
        }
        for (DatastoreV4.EntityResult found : res.getFoundList()) {
            result.addEntity(this.datastoreConverter.toV3Entity((DatastoreV4.EntityResultOrBuilder)found, false));
        }
        for (DatastoreV4.EntityResult missing : res.getMissingList()) {
            result.addEntity(this.datastoreConverter.toV3Entity((DatastoreV4.EntityResultOrBuilder)missing, true));
        }
        return result;
    }

    public DatastorePb.Query toV3Query(DatastoreV4.RunQueryRequestOrBuilder request, String appId, String databaseId) throws InvalidConversionException {
        DatastoreV4.ReadOptionsOrBuilder options;
        DatastorePb.Query result = this.datastoreConverter.toV3Query(request.getPartitionIdOrBuilder(), request.getQueryOrBuilder());
        if (request.hasSuggestedBatchSize()) {
            result.setCount(request.getSuggestedBatchSize());
        }
        if ((options = request.getReadOptionsOrBuilder()).hasTransaction()) {
            result.setTransaction(this.toV3Transaction(options.getTransaction(), appId, databaseId));
        } else if (options.getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.STRONG) {
            result.setStrong(true);
        } else if (options.getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.EVENTUAL) {
            result.setStrong(false);
            result.setFailoverMs(-1L);
        }
        if (request.hasMinSafeTimeSeconds()) {
            result.setMinSafeTimeSeconds(request.getMinSafeTimeSeconds());
        }
        return result;
    }

    DatastoreV4.RunQueryRequest.Builder toV4RunQueryRequest(DatastorePb.Query query) throws InvalidConversionException {
        DatastoreV4.RunQueryRequest.Builder builder = DatastoreV4.RunQueryRequest.newBuilder();
        EntityV4.PartitionId.Builder partition = builder.getPartitionIdBuilder();
        partition.setDatasetId(query.getApp());
        if (!query.getNameSpace().isEmpty()) {
            partition.setNamespace(query.getNameSpace());
        }
        if (query.hasCount()) {
            builder.setSuggestedBatchSize(query.getCount());
        }
        InvalidConversionException.checkConversion(!query.hasTransaction() || !query.hasFailoverMs(), "Cannot set failover and transaction handle.", new Object[0]);
        if (query.hasTransaction()) {
            builder.getReadOptionsBuilder().setTransaction(this.toTransactionBytes(query.getTransaction()));
        } else if (query.isStrong()) {
            builder.getReadOptionsBuilder().setReadConsistency(DatastoreV4.ReadOptions.ReadConsistency.STRONG);
        } else if (query.hasFailoverMs()) {
            builder.getReadOptionsBuilder().setReadConsistency(DatastoreV4.ReadOptions.ReadConsistency.EVENTUAL);
        }
        if (query.hasMinSafeTimeSeconds()) {
            builder.setMinSafeTimeSeconds(query.getMinSafeTimeSeconds());
        }
        builder.setQuery(this.datastoreConverter.toV4Query(query));
        return builder;
    }

    public DatastoreV4.RunQueryResponse.Builder toV4RunQueryResponse(DatastorePb.QueryResult result) throws InvalidConversionException {
        DatastoreV4.RunQueryResponse.Builder builder = DatastoreV4.RunQueryResponse.newBuilder();
        builder.setBatch(this.datastoreConverter.toV4QueryResultBatch(result));
        if (result.hasCursor()) {
            builder.setQueryHandle(this.toV4QueryHandle(result.getCursor()));
        }
        return builder;
    }

    DatastorePb.QueryResult toV3QueryResult(DatastoreV4.RunQueryResponseOrBuilder respV4) throws InvalidConversionException {
        DatastorePb.QueryResult result = this.datastoreConverter.toV3QueryResult((DatastoreV4.QueryResultBatchOrBuilder)respV4.getBatch());
        if (respV4.hasQueryHandle()) {
            result.setCursor(this.toV3Cursor(respV4.getQueryHandle()));
        }
        return result;
    }

    public DatastorePb.NextRequest toV3NextRequest(DatastoreV4.ContinueQueryRequestOrBuilder req) throws InvalidConversionException {
        DatastorePb.NextRequest next = new DatastorePb.NextRequest();
        next.setCompile(true);
        next.setCursor(this.toV3Cursor(req.getQueryHandle()));
        return next;
    }

    public DatastoreV4.ContinueQueryResponse.Builder toV4ContinueQueryResponse(DatastorePb.QueryResult result) throws InvalidConversionException {
        DatastoreV4.ContinueQueryResponse.Builder builder = DatastoreV4.ContinueQueryResponse.newBuilder();
        builder.setBatch(this.datastoreConverter.toV4QueryResultBatch(result));
        return builder;
    }

    public DatastorePb.BeginTransactionRequest toV3BeginTransactionRequest(String app, DatastoreV4.BeginTransactionRequestOrBuilder req) {
        DatastorePb.BeginTransactionRequest reqV3 = new DatastorePb.BeginTransactionRequest();
        reqV3.setApp(app);
        reqV3.setAllowMultipleEg(req.getCrossGroup());
        return reqV3;
    }

    DatastoreV4.BeginTransactionRequest.Builder toV4BeginTransactionRequest(DatastorePb.BeginTransactionRequest reqV3) {
        DatastoreV4.BeginTransactionRequest.Builder builder = DatastoreV4.BeginTransactionRequest.newBuilder();
        if (reqV3.hasAllowMultipleEg()) {
            builder.setCrossGroup(reqV3.isAllowMultipleEg());
        }
        return builder;
    }

    public DatastoreV4.BeginTransactionResponse.Builder toV4BeginTransactionResponse(DatastorePb.Transaction txn) throws InvalidConversionException {
        DatastoreV4.BeginTransactionResponse.Builder builder = DatastoreV4.BeginTransactionResponse.newBuilder();
        builder.setTransaction(this.toTransactionBytes(txn));
        return builder;
    }

    DatastorePb.Transaction toV3Transaction(DatastoreV4.BeginTransactionResponseOrBuilder res, String appId, String databaseId) throws InvalidConversionException {
        return this.toV3Transaction(res.getTransaction(), appId, databaseId);
    }

    public DatastorePb.Transaction toV3Transaction(DatastoreV4.RollbackRequestOrBuilder req, String appId, String databaseId) throws InvalidConversionException {
        return this.toV3Transaction(req.getTransaction(), appId, databaseId);
    }

    DatastoreV4.RollbackRequest.Builder toV4RollbackRequest(DatastorePb.Transaction txn) throws InvalidConversionException {
        DatastoreV4.RollbackRequest.Builder builder = DatastoreV4.RollbackRequest.newBuilder();
        builder.setTransaction(this.toTransactionBytes(txn));
        return builder;
    }

    public CommitRequest.Builder toV1CommitRequest(ProjectIdAppIdResolver resolver, DatastoreV4.CommitRequest reqV4) throws InvalidConversionException {
        CommitRequest.Builder reqV1 = CommitRequest.newBuilder();
        InvalidConversionException.checkConversion(reqV4.getMutationList().isEmpty() || !reqV4.hasDeprecatedMutation(), "CommitRequest has both a mutation list and a deprecated mutation", new Object[0]);
        if (reqV4.hasDeprecatedMutation()) {
            DatastoreV4.DeprecatedMutation deprecatedMutation = reqV4.getDeprecatedMutation();
            this.addV1Mutations(resolver, reqV1, DatastoreV4.Mutation.Operation.UPSERT, deprecatedMutation.getUpsertList());
            this.addV1Mutations(resolver, reqV1, DatastoreV4.Mutation.Operation.UPDATE, deprecatedMutation.getUpdateList());
            this.addV1Mutations(resolver, reqV1, DatastoreV4.Mutation.Operation.INSERT, deprecatedMutation.getInsertList());
            this.addV1Mutations(resolver, reqV1, DatastoreV4.Mutation.Operation.INSERT, deprecatedMutation.getInsertAutoIdList());
            for (DatastoreV4.Mutation.Builder mutation : this.datastoreConverter.toV4DeleteMutationList(deprecatedMutation.getDeleteList())) {
                reqV1.addMutations(this.getDatastoreConverter().toV1Mutation(resolver, (DatastoreV4.MutationOrBuilder)mutation));
            }
        } else {
            for (DatastoreV4.Mutation mutationV4 : reqV4.getMutationList()) {
                reqV1.addMutations(this.getDatastoreConverter().toV1Mutation(resolver, (DatastoreV4.MutationOrBuilder)mutationV4));
            }
        }
        switch (reqV4.getMode()) {
            case NON_TRANSACTIONAL: {
                reqV1.setMode(CommitRequest.Mode.NON_TRANSACTIONAL);
                break;
            }
            case TRANSACTIONAL: {
                reqV1.setMode(CommitRequest.Mode.TRANSACTIONAL);
                break;
            }
            default: {
                throw DatastoreProtoConverter.unrecognizedEnumValue("mutation.mode", reqV4.getMode());
            }
        }
        if (reqV4.hasTransaction()) {
            reqV1.setTransaction(reqV4.getTransaction());
        }
        this.inferRequestHeader(reqV1);
        return reqV1;
    }

    private void addV1Mutations(ProjectIdAppIdResolver resolver, CommitRequest.Builder reqV1, DatastoreV4.Mutation.Operation op, List<EntityV4.Entity> entities) throws InvalidConversionException {
        for (DatastoreV4.Mutation.Builder mutation : this.datastoreConverter.toV4MutationList(op, entities)) {
            reqV1.addMutations(this.getDatastoreConverter().toV1Mutation(resolver, (DatastoreV4.MutationOrBuilder)mutation));
        }
    }

    public DatastoreV4.CommitResponse.Builder toV4CommitResponse(ProjectIdAppIdResolver resolver, CommitResponseOrBuilder resV1) throws InvalidConversionException {
        DatastoreV4.CommitResponse.Builder resV4 = DatastoreV4.CommitResponse.newBuilder();
        for (MutationResult resultV1 : resV1.getMutationResultsList()) {
            resV4.addMutationResult(this.toV4MutationResult(resolver, resultV1));
        }
        resV4.setIndexUpdates(resV1.getIndexUpdates());
        return resV4;
    }

    private DatastoreV4.MutationResult.Builder toV4MutationResult(ProjectIdAppIdResolver resolver, MutationResult resultV1) throws InvalidConversionException {
        DatastoreV4.MutationResult.Builder resultV4 = DatastoreV4.MutationResult.newBuilder();
        if (resultV1.hasKey()) {
            resultV4.setKey(this.getEntityConverter().toV4Key(resolver, (KeyOrBuilder)resultV1.getKey()));
        }
        return resultV4;
    }
}

