/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.rep.DatabaseRef;
import com.google.apphosting.datastore.shared.DatastoreHelper;
import com.google.apphosting.datastore.shared.ValidationException;
import com.google.apphosting.datastore.shared.ValidationUtils;

public final class CloudV1DatabaseRefValidator {
    public static final CloudV1DatabaseRefValidator INSTANCE = new CloudV1DatabaseRefValidator();

    private CloudV1DatabaseRefValidator() {
    }

    public void validateDatabaseRefMatches(DatabaseRef requestInternalDatabase, ByteString projectIdBytes, ByteString databaseIdBytes) throws ValidationException {
        DatabaseRef other = this.createAndValidateDatabaseRef(projectIdBytes, databaseIdBytes);
        ValidationException.validateAssertion(other.isEmpty() || requestInternalDatabase.equals(other), "%s%s vs. %s", "mismatched databases within request: ", requestInternalDatabase, other);
    }

    public DatabaseRef createAndValidateDatabaseRef(ByteString projectIdBytes, ByteString databaseIdBytes) throws ValidationException {
        ValidationUtils.INSTANCE.validateStringUtf8(projectIdBytes, "project id");
        ValidationUtils.INSTANCE.validateStringUtf8(databaseIdBytes, "database id");
        String projectId = projectIdBytes.toStringUtf8();
        String databaseId = databaseIdBytes.toStringUtf8();
        if (!projectId.isEmpty()) {
            ValidationException.validateAssertion(DatastoreHelper.PROJECT_ID_REGEX.matcher(projectId).matches(), "\"%s\" is an invalid %s.", projectId, "project id");
        }
        if (!databaseId.isEmpty()) {
            ValidationException.validateAssertion(DatastoreHelper.DATABASE_ID_REGEX.matcher(databaseId).matches(), "\"%s\" is an invalid %s.", databaseId, "database id");
        }
        return DatabaseRef.createWithUnknownCluster(projectIdBytes.toStringUtf8(), databaseIdBytes.toStringUtf8());
    }

    public DatabaseRef createAndValidateRequiredDatabaseRef(ByteString projectId, ByteString databaseId) throws ValidationException {
        ValidationException.validateAssertion(!projectId.isEmpty(), "missing project id in header", new Object[0]);
        return this.createAndValidateDatabaseRef(projectId, databaseId);
    }
}

