/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.FacetNode;
import com.google.appengine.api.search.dev.LuceneUtils;
import com.google.appengine.api.search.dev.Scorer;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.repackaged.org.apache.lucene.document.Document;
import com.google.appengine.repackaged.org.apache.lucene.document.Fieldable;
import com.google.appengine.repackaged.org.apache.lucene.index.Term;
import com.google.appengine.repackaged.org.apache.lucene.search.BooleanClause;
import com.google.appengine.repackaged.org.apache.lucene.search.BooleanQuery;
import com.google.appengine.repackaged.org.apache.lucene.search.NumericRangeQuery;
import com.google.appengine.repackaged.org.apache.lucene.search.Query;
import com.google.appengine.repackaged.org.apache.lucene.search.TermQuery;
import com.google.apphosting.api.search.DocumentPb;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

final class SimpleFacet {
    private final Map<String, SearchServicePb.FacetRequest> manualFacetRequests = new LinkedHashMap<String, SearchServicePb.FacetRequest>();
    private final Map<String, FacetNode> manualFacetNodes = new LinkedHashMap<String, FacetNode>();
    private final Map<String, FacetNode> discoveredFacetNodes = new LinkedHashMap<String, FacetNode>();
    private final SearchServicePb.SearchParams searchParams;

    private SimpleFacet(SearchServicePb.SearchParams params) {
        this.searchParams = params;
    }

    static boolean isFacetingRequested(SearchServicePb.SearchParams searchParams) {
        return searchParams.getAutoDiscoverFacetCount() > 0 || searchParams.getIncludeFacetCount() > 0;
    }

    static SearchServicePb.FacetResult[] getFacetResult(SearchServicePb.SearchParams searchParams, Scorer.Result[] results) {
        return new SimpleFacet(searchParams).getFacetResult(results);
    }

    private SearchServicePb.FacetResult[] getFacetResult(Scorer.Result[] results) {
        this.preprocessManualFacets();
        for (Scorer.Result result : results) {
            Document doc = result.doc;
            for (Object fieldObject : doc.getFields()) {
                Fieldable field = (Fieldable)fieldObject;
                if (!LuceneUtils.isFacetField(field)) continue;
                this.processSingleFacet(LuceneUtils.convertLuceneFieldToFacet(field));
            }
        }
        SearchServicePb.FacetResult[] ret = new SearchServicePb.FacetResult[Math.min(this.discoveredFacetNodes.values().size(), this.searchParams.getAutoDiscoverFacetCount()) + this.manualFacetNodes.values().size()];
        int pointer = 0;
        for (FacetNode node : this.manualFacetNodes.values()) {
            ret[pointer++] = this.convertFacetNodeToFacetResult(node);
        }
        for (FacetNode node : this.getTopN(this.discoveredFacetNodes.values(), this.searchParams.getAutoDiscoverFacetCount())) {
            ret[pointer++] = this.convertFacetNodeToFacetResult(node);
        }
        return ret;
    }

    private SearchServicePb.FacetResult convertFacetNodeToFacetResult(FacetNode node) {
        if (node.getMin() != null) {
            node.addValue(this.getFacetLabelForRange(node.getMin(), node.getMax()), node.getMinMaxCount(), SearchServicePb.FacetRange.newBuilder().setStart(Double.toString(node.getMin())).setEnd(Double.toString(node.getMax())).build());
        }
        SearchServicePb.FacetResult.Builder resultBuilder = SearchServicePb.FacetResult.newBuilder();
        resultBuilder.setName(node.name);
        for (FacetNode.Value value : this.getTopN(node.getValues(), node.valueLimit)) {
            SearchServicePb.FacetResultValue.Builder valueBuilder = resultBuilder.addValueBuilder();
            SearchServicePb.FacetRefinement.Builder refBuilder = valueBuilder.getRefinementBuilder();
            if (value.range != null) {
                if (value.range.hasStart()) {
                    refBuilder.getRangeBuilder().setStart(Double.toString(Double.parseDouble(value.range.getStart())));
                }
                if (value.range.hasEnd()) {
                    refBuilder.getRangeBuilder().setEnd(Double.toString(Double.parseDouble(value.range.getEnd())));
                }
            } else {
                refBuilder.setValue(value.label);
            }
            refBuilder.setName(node.name);
            valueBuilder.setName(value.label);
            valueBuilder.setCount(value.getCount());
        }
        return resultBuilder.build();
    }

    private <T extends Comparable<T>> List<T> getTopN(Collection<T> items, int n) {
        ArrayList<T> ret = new ArrayList<T>(items);
        Collections.sort(ret);
        if (ret.size() > n) {
            return ret.subList(0, n);
        }
        return ret;
    }

    private void preprocessManualFacets() {
        for (SearchServicePb.FacetRequest manualFacet : this.searchParams.getIncludeFacetList()) {
            this.manualFacetRequests.put(manualFacet.getName(), manualFacet);
            if (!manualFacet.getParams().getRangeList().isEmpty() && !manualFacet.getParams().getValueConstraintList().isEmpty()) {
                throw new RuntimeException("Manual facet request should either specify range or value constraint, not both");
            }
            FacetNode node = new FacetNode(manualFacet.getName(), manualFacet.getParams().hasValueLimit() ? manualFacet.getParams().getValueLimit() : this.searchParams.getFacetAutoDetectParam().getValueLimit());
            this.manualFacetNodes.put(node.name, node);
            for (String value : manualFacet.getParams().getValueConstraintList()) {
                node.addValue(value, 0);
            }
            for (SearchServicePb.FacetRange range : manualFacet.getParams().getRangeList()) {
                Double start = range.hasStart() ? Double.valueOf(Double.parseDouble(range.getStart())) : null;
                Double end = range.hasEnd() ? Double.valueOf(Double.parseDouble(range.getEnd())) : null;
                node.addValue(this.getFacetLabelForRange(start, end), 0, range);
            }
        }
    }

    private void processSingleFacet(DocumentPb.Facet facet) {
        String facetName = facet.getName();
        String facetValue = facet.getValue().getStringValue();
        DocumentPb.FacetValue.ContentType facetType = facet.getValue().getType();
        SearchServicePb.FacetRequest manualFacet = this.manualFacetRequests.get(facetName);
        if (facetType == DocumentPb.FacetValue.ContentType.ATOM) {
            if (manualFacet != null) {
                FacetNode manualFacetNode = this.manualFacetNodes.get(manualFacet.getName());
                if (manualFacet.getParams().getRangeList().isEmpty() && (manualFacet.getParams().getValueConstraintList().isEmpty() || manualFacet.getParams().getValueConstraintList().contains((Object)facetValue))) {
                    manualFacetNode.addValue(facetValue, 1);
                }
            } else if (this.searchParams.getAutoDiscoverFacetCount() > 0) {
                FacetNode discoveredFacetNode = this.discoveredFacetNodes.get(facetName);
                if (discoveredFacetNode == null) {
                    discoveredFacetNode = new FacetNode(facetName, this.searchParams.getFacetAutoDetectParam().getValueLimit());
                    this.discoveredFacetNodes.put(facetName, discoveredFacetNode);
                }
                discoveredFacetNode.addValue(facetValue, 1, null);
            }
        } else if (facetType == DocumentPb.FacetValue.ContentType.NUMBER) {
            double facetValueDouble = Double.parseDouble(facetValue);
            if (manualFacet != null) {
                FacetNode manualFacetNode = this.manualFacetNodes.get(manualFacet.getName());
                if (!manualFacet.getParams().getRangeList().isEmpty()) {
                    for (SearchServicePb.FacetRange range : manualFacet.getParams().getRangeList()) {
                        Double end;
                        Double start = range.hasStart() ? Double.valueOf(Double.parseDouble(range.getStart())) : null;
                        Double d = end = range.hasEnd() ? Double.valueOf(Double.parseDouble(range.getEnd())) : null;
                        if (start != null && !(facetValueDouble >= start) || end != null && !(facetValueDouble < end)) continue;
                        manualFacetNode.addValue(this.getFacetLabelForRange(start, end), 1, range);
                    }
                } else if (!manualFacet.getParams().getValueConstraintList().isEmpty()) {
                    for (String constraint : manualFacet.getParams().getValueConstraintList()) {
                        if (Double.parseDouble(facetValue) != Double.parseDouble(constraint)) continue;
                        manualFacetNode.addValue(constraint, 1);
                    }
                } else {
                    manualFacetNode.addNumericValue(Double.parseDouble(facetValue));
                }
            } else if (this.searchParams.getAutoDiscoverFacetCount() > 0) {
                FacetNode discoveredFacetNode = this.discoveredFacetNodes.get(facetName);
                if (discoveredFacetNode == null) {
                    discoveredFacetNode = new FacetNode(facetName, this.searchParams.getFacetAutoDetectParam().getValueLimit());
                    this.discoveredFacetNodes.put(facetName, discoveredFacetNode);
                }
                discoveredFacetNode.addNumericValue(Double.parseDouble(facetValue));
            }
        } else {
            String string = String.valueOf(facetType);
            throw new RuntimeException(new StringBuilder(30 + String.valueOf(string).length()).append("Facet type is not supported : ").append(string).toString());
        }
    }

    private String getFacetLabelForRange(Double start, Double end) {
        return String.format("[%s,%s)", start != null ? Double.toString(start) : "-Infinity", end != null ? Double.toString(end) : "Infinity");
    }

    static Query getRefinementQuery(SearchServicePb.SearchParams params) {
        List refinements = params.getFacetRefinementList();
        BooleanQuery rootQuery = new BooleanQuery();
        for (List<SearchServicePb.FacetRefinement> group : SimpleFacet.getFacetRefinementsByName(refinements)) {
            ArrayList<Query> groupQueries = new ArrayList<Query>();
            for (SearchServicePb.FacetRefinement refinement : group) {
                String string;
                if (refinement.hasValue() && refinement.hasRange()) {
                    string = String.valueOf(refinement.getName());
                    throw new RuntimeException(new StringBuilder(88 + String.valueOf(string).length()).append("Refinement request for facet ").append(string).append(" should either specify range or value constraint, not both.").toString());
                }
                if (!refinement.hasValue() && !refinement.hasRange()) {
                    string = String.valueOf(refinement.getName());
                    throw new RuntimeException(new StringBuilder(71 + String.valueOf(string).length()).append("Refinement request for facet ").append(string).append(" should specify range or value constraint.").toString());
                }
                if (refinement.hasValue()) {
                    groupQueries.add(new TermQuery(new Term(LuceneUtils.makeLuceneFieldName(refinement.getName(), DocumentPb.FacetValue.ContentType.ATOM), refinement.getValue())));
                    try {
                        groupQueries.add(NumericRangeQuery.newDoubleRange(LuceneUtils.makeLuceneFieldName(refinement.getName(), DocumentPb.FacetValue.ContentType.NUMBER), Double.parseDouble(refinement.getValue()), Double.parseDouble(refinement.getValue()), true, true));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                Double start = refinement.getRange().hasStart() ? Double.valueOf(Double.parseDouble(refinement.getRange().getStart())) : null;
                Double end = refinement.getRange().hasEnd() ? Double.valueOf(Double.parseDouble(refinement.getRange().getEnd())) : null;
                groupQueries.add(NumericRangeQuery.newDoubleRange(LuceneUtils.makeLuceneFieldName(refinement.getName(), DocumentPb.FacetValue.ContentType.NUMBER), start, end, true, false));
            }
            rootQuery.add(SimpleFacet.getDisjunction(groupQueries), BooleanClause.Occur.MUST);
        }
        return rootQuery;
    }

    private static Collection<List<SearchServicePb.FacetRefinement>> getFacetRefinementsByName(List<SearchServicePb.FacetRefinement> refinements) {
        TreeMap<String, ArrayList<SearchServicePb.FacetRefinement>> refinementGroups = new TreeMap<String, ArrayList<SearchServicePb.FacetRefinement>>();
        for (SearchServicePb.FacetRefinement refinement : refinements) {
            ArrayList<SearchServicePb.FacetRefinement> group = (ArrayList<SearchServicePb.FacetRefinement>)refinementGroups.get(refinement.getName());
            if (group == null) {
                group = new ArrayList<SearchServicePb.FacetRefinement>();
                refinementGroups.put(refinement.getName(), group);
            }
            group.add(refinement);
        }
        return refinementGroups.values();
    }

    private static Query getDisjunction(Iterable<? extends Query> queries) {
        BooleanQuery query = new BooleanQuery();
        for (Query query2 : queries) {
            query.add(query2, BooleanClause.Occur.SHOULD);
        }
        return query;
    }
}

