/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.dev.ApiProxyDatastoreV3;
import com.google.appengine.api.datastore.dev.CloudDatastoreV1;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryResponse;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.shared.InvalidConversionException;

public class LocalCloudDatastoreV1Service
extends AbstractLocalRpcService {
    public static final String PACKAGE = "cloud_datastore_v1beta3";
    private static final int MAX_REQUEST_SIZE = 0xA00000;
    private final CloudDatastoreV1 delegate = new CloudDatastoreV1(new ApiProxyDatastoreV3());

    public String getPackage() {
        return PACKAGE;
    }

    public AllocateIdsResponse allocateIds(LocalRpcService.Status status, AllocateIdsRequest req) {
        return this.delegate.allocateIds(LocalCloudDatastoreV1Service.makeHeader(), req);
    }

    public BeginTransactionResponse beginTransaction(LocalRpcService.Status status, BeginTransactionRequest req) {
        return this.delegate.beginTransaction(LocalCloudDatastoreV1Service.makeHeader(), req);
    }

    public CommitResponse commit(LocalRpcService.Status status, CommitRequest req) {
        return this.delegate.commit(LocalCloudDatastoreV1Service.makeHeader(), req);
    }

    public RollbackResponse rollback(LocalRpcService.Status status, RollbackRequest req) {
        return this.delegate.rollback(LocalCloudDatastoreV1Service.makeHeader(), req);
    }

    public LookupResponse get(LocalRpcService.Status status, LookupRequest request) {
        return this.lookup(status, request);
    }

    public LookupResponse lookup(LocalRpcService.Status status, LookupRequest request) {
        return this.delegate.lookup(LocalCloudDatastoreV1Service.makeHeader(), request);
    }

    public RunQueryResponse runQuery(LocalRpcService.Status status, RunQueryRequest request) {
        return this.delegate.runQuery(LocalCloudDatastoreV1Service.makeHeader(), request);
    }

    public Double getDefaultDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    public Double getMaximumDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    public Integer getMaxApiRequestSize() {
        return 0xA00000;
    }

    private static CloudDatastoreV1.RequestHeader makeHeader() {
        return CloudDatastoreV1.RequestHeader.create(ApiProxy.getCurrentEnvironment().getAppId());
    }

    static DatastorePb.Transaction toV3Transaction(ByteString transactionBytes) throws InvalidConversionException {
        return CloudDatastoreV1.toV3Transaction(transactionBytes);
    }
}

