/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import mediautil.gen.FileFormatException;
import mediautil.gen.Log;
import mediautil.gen.Rational;
import mediautil.image.jpeg.AbstractImageInfo;
import mediautil.image.jpeg.DirectoryEntry;
import mediautil.image.jpeg.Header;
import mediautil.image.jpeg.LLJTran;

public class Flashpix
extends AbstractImageInfo<LLJTran> {
    public static final String FORMAT = "Flashpix";
    static final int HEADER_LENGTH = 512;
    static final byte[] SIGNATURE = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    Header header;
    byte[] fat;
    Icon icon;

    public Flashpix() {
    }

    public Flashpix(InputStream is, byte[] data, int offset, String name, LLJTran format) throws FileFormatException {
        super(is, data, offset, name, null, format);
    }

    @Override
    public void readInfo() throws FileFormatException {
        block10: {
            try {
                int i;
                String string;
                this.data = new byte[504];
                Flashpix.read(this.is, this.data);
                this.offset += this.data.length;
                this.header = new Header();
                this.header.fill(this.data, -8);
                this.intel = this.header.intelByteOrder;
                if (Log.debugLevel >= 4) {
                    String string2 = this.header.toString();
                    string = this.getName();
                    System.out.println(new StringBuilder(11 + String.valueOf(string2).length() + String.valueOf(string).length()).append("Header ").append(string2).append(" of ").append(string).toString());
                }
                Flashpix.skip(this.is, this.header.fat[0] * this.header.sectorSize);
                this.offset += this.header.fat[0] * this.header.sectorSize;
                this.data = new byte[this.header.sectorSize];
                for (i = 0; i < this.header.sectsFat; ++i) {
                    if (Log.debugLevel < 4) continue;
                    int n = i;
                    int n2 = this.header.fat[i];
                    System.out.println(new StringBuilder(36).append("Fat sector [").append(n).append("]=").append(n2).toString());
                }
                Flashpix.read(this.is, this.data);
                this.offset += this.data.length;
                if (Log.debugLevel >= 4) {
                    i = this.header.sectDirStart;
                    string = String.valueOf(Integer.toHexString(this.s2n(this.header.sectDirStart * 4, 4)));
                    System.out.println(new StringBuilder(26 + String.valueOf(string).length()).append("Sector ").append(i).append(" marker ").append(string).toString());
                }
                this.fat = this.data;
                this.data = new byte[this.header.sectorSize];
                Flashpix.read(this.is, this.data);
                this.offset += this.data.length;
                DirectoryEntry root = new DirectoryEntry();
                root.fill(this.data, 0);
                if (Log.debugLevel >= 4) {
                    String string3 = String.valueOf(root.toString());
                    System.out.println(string3.length() != 0 ? "Root ".concat(string3) : new String("Root "));
                }
                if (root._child < 0) {
                    return;
                }
                DirectoryEntry child = new DirectoryEntry();
                child.fill(this.data, root._child * 128);
                if (Log.debugLevel >= 4) {
                    String string4 = String.valueOf(child.toString());
                    System.out.println(string4.length() != 0 ? "Child ".concat(string4) : new String("Child "));
                }
                DirectoryEntry sibchild = new DirectoryEntry();
                if (child._leftSib > 0) {
                    sibchild.fill(this.data, child._leftSib * 128);
                    if (Log.debugLevel >= 4) {
                        String string5 = String.valueOf(sibchild.toString());
                        System.out.println(string5.length() != 0 ? "Left sib ".concat(string5) : new String("Left sib "));
                    }
                }
            }
            catch (IOException e) {
                if (Log.debugLevel < 1) break block10;
                e.printStackTrace(System.err);
            }
        }
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public int getResolutionX() {
        return 0;
    }

    @Override
    public int getResolutionY() {
        return 0;
    }

    @Override
    public String getMake() {
        return null;
    }

    @Override
    public String getModel() {
        return null;
    }

    @Override
    public String getDataTimeOriginalString() {
        return null;
    }

    @Override
    public float getFNumber() {
        return 0.0f;
    }

    @Override
    public Rational getShutter() {
        return new Rational(0, 1);
    }

    @Override
    public boolean isFlash() {
        return false;
    }

    @Override
    public String getQuality() {
        return null;
    }

    @Override
    public float getFocalLength() {
        return 0.0f;
    }

    @Override
    public int getMetering() {
        return 0;
    }

    @Override
    public int getExpoProgram() {
        return 0;
    }

    @Override
    public String getReport() {
        return null;
    }

    @Override
    public Icon getThumbnailIcon(Dimension size) {
        block4: {
            if (this.icon != null) {
                return this.icon;
            }
            if (this.getAdvancedImage() != null) {
                try {
                    this.icon = this.getAdvancedImage().createThumbnailIcon(this.getImageFile().getPath(), null);
                    return this.icon;
                }
                catch (Throwable e) {
                    if (Log.debugLevel < 1) break block4;
                    System.err.println(e);
                }
            }
        }
        return null;
    }
}

