/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.httpclient;

import com.google.appengine.repackaged.org.apache.commons.httpclient.ResponseConsumedWatcher;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class AutoCloseInputStream
extends FilterInputStream {
    private boolean streamOpen = true;
    private boolean selfClosed = false;
    private ResponseConsumedWatcher watcher = null;

    public AutoCloseInputStream(InputStream inputStream, ResponseConsumedWatcher responseConsumedWatcher) {
        super(inputStream);
        this.watcher = responseConsumedWatcher;
    }

    public int read() throws IOException {
        int n = -1;
        if (this.isReadAllowed()) {
            n = super.read();
            this.checkClose(n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = -1;
        if (this.isReadAllowed()) {
            n3 = super.read(byArray, n, n2);
            this.checkClose(n3);
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        int n = -1;
        if (this.isReadAllowed()) {
            n = super.read(byArray);
            this.checkClose(n);
        }
        return n;
    }

    public int available() throws IOException {
        int n = 0;
        if (this.isReadAllowed()) {
            n = super.available();
        }
        return n;
    }

    public void close() throws IOException {
        if (!this.selfClosed) {
            this.selfClosed = true;
            this.notifyWatcher();
        }
    }

    private void checkClose(int n) throws IOException {
        if (n == -1) {
            this.notifyWatcher();
        }
    }

    private boolean isReadAllowed() throws IOException {
        if (!this.streamOpen && this.selfClosed) {
            throw new IOException("Attempted read on closed stream.");
        }
        return this.streamOpen;
    }

    private void notifyWatcher() throws IOException {
        if (this.streamOpen) {
            super.close();
            this.streamOpen = false;
            if (this.watcher != null) {
                this.watcher.responseConsumed();
            }
        }
    }
}

