/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.DatastoreServiceProtoConverter;
import com.google.apphosting.datastore.shared.DatastoreV4ServiceValidator;
import com.google.apphosting.datastore.shared.EntityProtoConverter;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.ValidationException;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@ServiceProvider(value=LocalRpcService.class)
public class LocalDatastoreV4Service
extends AbstractLocalRpcService {
    public static final String PACKAGE = "datastore_v4";
    private final DatastoreV4ServiceValidator validator;
    private final DatastoreServiceProtoConverter converter;

    public LocalDatastoreV4Service() {
        this(DatastoreV4ServiceValidator.DEFAULT, DatastoreServiceProtoConverter.TRIVIAL);
    }

    public LocalDatastoreV4Service(DatastoreV4ServiceValidator validator, DatastoreServiceProtoConverter converter) {
        this.validator = validator;
        this.converter = converter;
    }

    public String getPackage() {
        return PACKAGE;
    }

    public DatastoreV4.AllocateIdsResponse allocateIds(LocalRpcService.Status status, DatastoreV4.AllocateIdsRequest req) {
        DatastorePb.AllocateIdsResponse respV3;
        DatastoreV4.AllocateIdsResponse.Builder respBuilder = DatastoreV4.AllocateIdsResponse.newBuilder();
        try {
            this.validator.validateAllocateIdsRequest((DatastoreV4.AllocateIdsRequestOrBuilder)req);
            DatastorePb.AllocateIdsRequest reqV3 = new DatastorePb.AllocateIdsRequest();
            reqV3.setSize((long)req.getAllocateCount());
            respV3 = (DatastorePb.AllocateIdsResponse)this.makeV3Call(DatastorePb.DatastoreService_3.Method.AllocateIds, (MessageLite)reqV3, DatastorePb.AllocateIdsResponse.PARSER);
        }
        catch (ValidationException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        if (respV3.getEnd() - respV3.getStart() + 1L < (long)req.getAllocateCount()) {
            throw new ApiProxy.ApplicationException(3, "could not allocate sufficent ids");
        }
        long i = respV3.getStart();
        for (EntityV4.Key reqKey : req.getAllocateList()) {
            EntityV4.Key.Builder respKey = EntityV4.Key.newBuilder().mergeFrom(reqKey);
            respKey.getPathElementBuilder(respKey.getPathElementCount() - 1).setId(LocalDatastoreService.toScatteredId(i++));
            respBuilder.addAllocated(respKey);
        }
        return respBuilder.build();
    }

    public DatastoreV4.BeginTransactionResponse beginTransaction(LocalRpcService.Status status, DatastoreV4.BeginTransactionRequest req) {
        DatastorePb.Transaction internalResp;
        try {
            DatastorePb.BeginTransactionRequest reqV3 = this.converter.toV3BeginTransactionRequest(ApiProxy.getCurrentEnvironment().getAppId(), (DatastoreV4.BeginTransactionRequestOrBuilder)req);
            internalResp = (DatastorePb.Transaction)this.makeV3Call(DatastorePb.DatastoreService_3.Method.BeginTransaction, (MessageLite)reqV3, DatastorePb.Transaction.PARSER);
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        try {
            return this.converter.toV4BeginTransactionResponse(internalResp).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(3, e.getMessage());
        }
    }

    public DatastoreV4.CommitResponse commit(LocalRpcService.Status status, DatastoreV4.CommitRequest req) {
        DatastoreV4.CommitResponse.Builder builder = DatastoreV4.CommitResponse.newBuilder();
        try {
            ByteString transaction;
            this.validator.validateCommitRequest((DatastoreV4.CommitRequestOrBuilder)req);
            boolean hasTransaction = req.hasTransaction();
            boolean hasDeprecatedMutation = req.hasDeprecatedMutation();
            ByteString byteString = transaction = hasTransaction ? req.getTransaction() : null;
            if (hasDeprecatedMutation) {
                builder.setDeprecatedMutationResult(this.applyDeprecatedMutation((DatastoreV4.DeprecatedMutationOrBuilder)req.getDeprecatedMutation(), transaction));
            } else {
                this.applyMutationList(req.getMutationList(), transaction, builder);
            }
            if (hasTransaction) {
                DatastorePb.CommitResponse commitRes = (DatastorePb.CommitResponse)this.makeV3Call(DatastorePb.DatastoreService_3.Method.Commit, (MessageLite)this.converter.toV3Transaction(req.getTransaction()), DatastorePb.CommitResponse.PARSER);
                if (hasDeprecatedMutation) {
                    builder.getDeprecatedMutationResultBuilder().setIndexUpdates(builder.getDeprecatedMutationResultOrBuilder().getIndexUpdates() + commitRes.getCost().getIndexWrites());
                } else {
                    builder.setIndexUpdates(builder.getIndexUpdates() + commitRes.getCost().getIndexWrites());
                }
            }
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        catch (ValidationException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        return builder.build();
    }

    public DatastoreV4.RollbackResponse rollback(LocalRpcService.Status status, DatastoreV4.RollbackRequest req) {
        try {
            this.makeV3Call(DatastorePb.DatastoreService_3.Method.Rollback, (MessageLite)this.converter.toV3Transaction((DatastoreV4.RollbackRequestOrBuilder)req), ApiBasePb.VoidProto.PARSER);
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(3, e.getMessage());
        }
        return DatastoreV4.RollbackResponse.getDefaultInstance();
    }

    public DatastoreV4.LookupResponse get(LocalRpcService.Status status, DatastoreV4.LookupRequest request) {
        return this.lookup(status, request);
    }

    public DatastoreV4.LookupResponse lookup(LocalRpcService.Status status, DatastoreV4.LookupRequest request) {
        try {
            this.validator.validateLookupRequest((DatastoreV4.LookupRequestOrBuilder)request);
            DatastorePb.GetResponse internResp = (DatastorePb.GetResponse)this.makeV3Call(DatastorePb.DatastoreService_3.Method.Get, (MessageLite)this.converter.toV3GetRequest((DatastoreV4.LookupRequestOrBuilder)request), DatastorePb.GetResponse.PARSER);
            return this.converter.toV4LookupResponse(internResp).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        catch (ValidationException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
    }

    public DatastoreV4.CommitResponse write(LocalRpcService.Status status, DatastoreV4.WriteRequest request) {
        return this.commit(status, this.converter.toV4CommitRequest((DatastoreV4.WriteRequestOrBuilder)request).build());
    }

    protected DatastoreV4.RunQueryRequest normalizeRunQueryRequest(DatastoreV4.RunQueryRequest request) throws ValidationException, InvalidConversionException {
        if (request.hasGqlQuery()) {
            ValidationException.validateAssertion(!request.hasQuery(), "1 (and only 1) of fields Query.query and Query.gql_query must be set", new Object[0]);
            this.validator.getDatastoreV4Validator().validateGqlQuery((DatastoreV4.GqlQueryOrBuilder)request.getGqlQuery());
            request = DatastoreV4.RunQueryRequest.newBuilder((DatastoreV4.RunQueryRequest)request).setQuery(this.converter.getDatastoreProtoConverter().toV4Query((DatastoreV4.GqlQueryOrBuilder)request.getGqlQuery(), request.getPartitionId())).clearGqlQuery().build();
        }
        return request;
    }

    public DatastoreV4.RunQueryResponse runQuery(LocalRpcService.Status status, DatastoreV4.RunQueryRequest request) {
        DatastorePb.QueryResult internResp;
        try {
            request = this.normalizeRunQueryRequest(request);
            this.validator.validateRunQueryRequest((DatastoreV4.RunQueryRequestOrBuilder)request);
            internResp = (DatastorePb.QueryResult)this.makeV3Call(DatastorePb.DatastoreService_3.Method.RunQuery, (MessageLite)this.converter.toV3Query((DatastoreV4.RunQueryRequestOrBuilder)request), DatastorePb.QueryResult.PARSER);
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        catch (ValidationException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        try {
            return this.converter.toV4RunQueryResponse(internResp).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(3, e.getMessage());
        }
    }

    public DatastoreV4.ContinueQueryResponse continueQuery(LocalRpcService.Status status, DatastoreV4.ContinueQueryRequest request) {
        DatastorePb.QueryResult internResp;
        try {
            internResp = (DatastorePb.QueryResult)this.makeV3Call(DatastorePb.DatastoreService_3.Method.Next, (MessageLite)this.converter.toV3NextRequest((DatastoreV4.ContinueQueryRequestOrBuilder)request), DatastorePb.QueryResult.PARSER);
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        try {
            return this.converter.toV4ContinueQueryResponse(internResp).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(3, e.getMessage());
        }
    }

    private int insert(OnestoreEntity.EntityProto entity, DatastorePb.Transaction txn) throws InvalidConversionException {
        if (txn == null) {
            txn = (DatastorePb.Transaction)this.makeV3Call(DatastorePb.DatastoreService_3.Method.BeginTransaction, (MessageLite)new DatastorePb.BeginTransactionRequest().setApp(entity.getKey().getApp()), DatastorePb.Transaction.PARSER);
            this.insert(entity, txn);
            return ((DatastorePb.CommitResponse)this.makeV3Call(DatastorePb.DatastoreService_3.Method.Commit, (MessageLite)txn, DatastorePb.CommitResponse.PARSER)).getCost().getIndexWrites();
        }
        DatastorePb.GetRequest get = new DatastorePb.GetRequest().setTransaction(txn);
        get.addKey(entity.getKey());
        DatastorePb.GetResponse res = (DatastorePb.GetResponse)this.makeV3Call(DatastorePb.DatastoreService_3.Method.Get, (MessageLite)get, DatastorePb.GetResponse.PARSER);
        if (res.getEntity(0).hasEntity()) {
            throw new ApiProxy.ApplicationException(1, "entity already exists");
        }
        DatastorePb.PutRequest put = new DatastorePb.PutRequest().setTransaction(txn);
        put.addEntity(entity);
        return ((DatastorePb.PutResponse)this.makeV3Call(DatastorePb.DatastoreService_3.Method.Put, (MessageLite)put, DatastorePb.PutResponse.PARSER)).getCost().getIndexWrites();
    }

    private int update(OnestoreEntity.EntityProto entity, DatastorePb.Transaction txn) throws InvalidConversionException {
        if (txn == null) {
            txn = (DatastorePb.Transaction)this.makeV3Call(DatastorePb.DatastoreService_3.Method.BeginTransaction, (MessageLite)new DatastorePb.BeginTransactionRequest().setApp(entity.getKey().getApp()), DatastorePb.Transaction.PARSER);
            this.update(entity, txn);
            return ((DatastorePb.CommitResponse)this.makeV3Call(DatastorePb.DatastoreService_3.Method.Commit, (MessageLite)txn, DatastorePb.CommitResponse.PARSER)).getCost().getIndexWrites();
        }
        DatastorePb.GetRequest get = new DatastorePb.GetRequest().setTransaction(txn);
        get.addKey(entity.getKey());
        DatastorePb.GetResponse res = (DatastorePb.GetResponse)this.makeV3Call(DatastorePb.DatastoreService_3.Method.Get, (MessageLite)get, DatastorePb.GetResponse.PARSER);
        if (!res.getEntity(0).hasEntity()) {
            throw new ApiProxy.ApplicationException(1, "entity does not exist");
        }
        DatastorePb.PutRequest put = new DatastorePb.PutRequest().setTransaction(txn);
        put.addEntity(entity);
        return ((DatastorePb.PutResponse)this.makeV3Call(DatastorePb.DatastoreService_3.Method.Put, (MessageLite)put, DatastorePb.PutResponse.PARSER)).getCost().getIndexWrites();
    }

    private void applyMutationList(List<DatastoreV4.Mutation> mutationList, ByteString v4Txn, DatastoreV4.CommitResponse.Builder response) throws InvalidConversionException {
        EntityProtoConverter entityConverter = this.converter.getDatastoreProtoConverter().getEntityProtoConverter();
        DatastorePb.Transaction txn = v4Txn == null ? null : this.converter.toV3Transaction(v4Txn);
        int indexUpdates = 0;
        DatastorePb.PutRequest putReq = new DatastorePb.PutRequest();
        DatastorePb.DeleteRequest deleteReq = new DatastorePb.DeleteRequest();
        if (txn != null) {
            putReq.setTransaction(txn);
            deleteReq.setTransaction(txn);
        }
        int mutationIndex = 0;
        ArrayList putReqMutationIdx = Lists.newArrayList();
        for (DatastoreV4.Mutation mutation : mutationList) {
            switch (mutation.getOp()) {
                case INSERT: {
                    if (!Paths.hasIncompleteLastElement((EntityV4.KeyOrBuilder)mutation.getEntity().getKey())) {
                        indexUpdates += this.insert(entityConverter.toV3Entity((EntityV4.EntityOrBuilder)mutation.getEntity()), txn);
                        break;
                    }
                }
                case UPSERT: {
                    putReqMutationIdx.add(mutationIndex);
                    putReq.addEntity(entityConverter.toV3Entity((EntityV4.EntityOrBuilder)mutation.getEntity()));
                    break;
                }
                case UPDATE: {
                    indexUpdates += this.update(entityConverter.toV3Entity((EntityV4.EntityOrBuilder)mutation.getEntity()), txn);
                    break;
                }
                case DELETE: {
                    deleteReq.addKey(entityConverter.toV3Reference((EntityV4.KeyOrBuilder)mutation.getKey()));
                    break;
                }
                default: {
                    throw new Error("Unexpected mutation operation.");
                }
            }
            ++mutationIndex;
        }
        DatastorePb.PutResponse putResp = (DatastorePb.PutResponse)this.makeV3Call(DatastorePb.DatastoreService_3.Method.Put, (MessageLite)putReq, DatastorePb.PutResponse.PARSER);
        indexUpdates += putResp.getCost().getIndexWrites();
        indexUpdates += ((DatastorePb.DeleteResponse)this.makeV3Call(DatastorePb.DatastoreService_3.Method.Delete, (MessageLite)deleteReq, DatastorePb.DeleteResponse.PARSER)).getCost().getIndexWrites();
        Iterator putReqMutationIdxIt = putReqMutationIdx.iterator();
        DatastoreV4.MutationResult emptyMutation = DatastoreV4.MutationResult.newBuilder().setNewVersion(12345L).build();
        for (OnestoreEntity.Reference autoIdKeyResp : putResp.keys()) {
            int mutListIdx = (Integer)putReqMutationIdxIt.next();
            int emptyResultsToAdd = mutListIdx - response.getMutationResultCount();
            response.addAllMutationResult(Collections.nCopies(emptyResultsToAdd, emptyMutation));
            if (Paths.hasIncompleteLastElement((EntityV4.KeyOrBuilder)mutationList.get(mutListIdx).getEntity().getKey())) {
                response.addMutationResult(emptyMutation.toBuilder().setKey(entityConverter.toV4Key(autoIdKeyResp)));
                continue;
            }
            response.addMutationResult(emptyMutation);
        }
        response.addAllMutationResult(Collections.nCopies(mutationList.size() - response.getMutationResultCount(), emptyMutation));
        response.setIndexUpdates(indexUpdates);
    }

    private DatastoreV4.DeprecatedMutationResult.Builder applyDeprecatedMutation(DatastoreV4.DeprecatedMutationOrBuilder deprecatedMutation, ByteString v4Txn) throws InvalidConversionException {
        DatastorePb.Transaction txn = v4Txn == null ? null : this.converter.toV3Transaction(v4Txn);
        int indexWrites = 0;
        EntityProtoConverter entityConverter = this.converter.getDatastoreProtoConverter().getEntityProtoConverter();
        for (EntityV4.Entity entity : deprecatedMutation.getInsertList()) {
            indexWrites += this.insert(entityConverter.toV3Entity((EntityV4.EntityOrBuilder)entity), txn);
        }
        for (EntityV4.Entity entity : deprecatedMutation.getUpdateList()) {
            indexWrites += this.update(entityConverter.toV3Entity((EntityV4.EntityOrBuilder)entity), txn);
        }
        DatastorePb.PutRequest putReq = new DatastorePb.PutRequest();
        DatastorePb.DeleteRequest deleteReq = new DatastorePb.DeleteRequest();
        if (txn != null) {
            putReq.setTransaction(txn);
            deleteReq.setTransaction(txn);
        }
        for (Object entity : deprecatedMutation.getInsertAutoIdList()) {
            putReq.addEntity(entityConverter.toV3Entity((EntityV4.EntityOrBuilder)entity));
        }
        DatastorePb.PutResponse insertAutoResp = (DatastorePb.PutResponse)this.makeV3Call(DatastorePb.DatastoreService_3.Method.Put, (MessageLite)putReq, DatastorePb.PutResponse.PARSER);
        indexWrites += insertAutoResp.getCost().getIndexWrites();
        putReq.clearEntity();
        for (EntityV4.Entity entity : deprecatedMutation.getUpsertList()) {
            putReq.addEntity(entityConverter.toV3Entity((EntityV4.EntityOrBuilder)entity));
        }
        indexWrites += ((DatastorePb.PutResponse)this.makeV3Call(DatastorePb.DatastoreService_3.Method.Put, (MessageLite)putReq, DatastorePb.PutResponse.PARSER)).getCost().getIndexWrites();
        for (EntityV4.Key key : deprecatedMutation.getDeleteList()) {
            deleteReq.addKey(entityConverter.toV3Reference((EntityV4.KeyOrBuilder)key));
        }
        indexWrites += ((DatastorePb.DeleteResponse)this.makeV3Call(DatastorePb.DatastoreService_3.Method.Delete, (MessageLite)deleteReq, DatastorePb.DeleteResponse.PARSER)).getCost().getIndexWrites();
        DatastoreV4.DeprecatedMutationResult.Builder builder = DatastoreV4.DeprecatedMutationResult.newBuilder();
        for (OnestoreEntity.Reference key : insertAutoResp.keys()) {
            builder.addInsertAutoIdKey(entityConverter.toV4Key(key));
        }
        builder.setIndexUpdates(indexWrites);
        return builder;
    }

    private <T> T makeV3Call(DatastorePb.DatastoreService_3.Method method, MessageLite req, Parser<T> respParser) throws InvalidConversionException {
        try {
            return (T)respParser.parseFrom(ApiProxy.makeSyncCall((String)"datastore_v3", (String)method.name(), (byte[])req.toByteArray()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidConversionException(e);
        }
    }
}

