/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Data for Value Added module. Required fields are header and uri.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ValueAddedModuleData extends com.google.api.client.json.GenericJson {

  /**
   * Body to be displayed on the module. Character limit is 50 and longer strings will be truncated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString body;

  /**
   * Header to be displayed on the module. Character limit is 60 and longer strings will be
   * truncated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString header;

  /**
   * Image to be displayed on the module. Recommended image ratio is 1:1. Images will be resized to
   * fit this ratio.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image image;

  /**
   * The index for sorting the modules. Modules with a lower sort index are shown before modules
   * with a higher sort index. If unspecified, the sort index is assumed to be INT_MAX. For two
   * modules with the same index, the sorting behavior is undefined.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer sortIndex;

  /**
   * URI that the module leads to on click. This can be a web link or a deep link as mentioned in
   * https://developer.android.com/training/app-links/deep-linking.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uri;

  /**
   * Constraints that all must be met for the module to be shown.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ModuleViewConstraints viewConstraints;

  /**
   * Body to be displayed on the module. Character limit is 50 and longer strings will be truncated.
   * @return value or {@code null} for none
   */
  public LocalizedString getBody() {
    return body;
  }

  /**
   * Body to be displayed on the module. Character limit is 50 and longer strings will be truncated.
   * @param body body or {@code null} for none
   */
  public ValueAddedModuleData setBody(LocalizedString body) {
    this.body = body;
    return this;
  }

  /**
   * Header to be displayed on the module. Character limit is 60 and longer strings will be
   * truncated.
   * @return value or {@code null} for none
   */
  public LocalizedString getHeader() {
    return header;
  }

  /**
   * Header to be displayed on the module. Character limit is 60 and longer strings will be
   * truncated.
   * @param header header or {@code null} for none
   */
  public ValueAddedModuleData setHeader(LocalizedString header) {
    this.header = header;
    return this;
  }

  /**
   * Image to be displayed on the module. Recommended image ratio is 1:1. Images will be resized to
   * fit this ratio.
   * @return value or {@code null} for none
   */
  public Image getImage() {
    return image;
  }

  /**
   * Image to be displayed on the module. Recommended image ratio is 1:1. Images will be resized to
   * fit this ratio.
   * @param image image or {@code null} for none
   */
  public ValueAddedModuleData setImage(Image image) {
    this.image = image;
    return this;
  }

  /**
   * The index for sorting the modules. Modules with a lower sort index are shown before modules
   * with a higher sort index. If unspecified, the sort index is assumed to be INT_MAX. For two
   * modules with the same index, the sorting behavior is undefined.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSortIndex() {
    return sortIndex;
  }

  /**
   * The index for sorting the modules. Modules with a lower sort index are shown before modules
   * with a higher sort index. If unspecified, the sort index is assumed to be INT_MAX. For two
   * modules with the same index, the sorting behavior is undefined.
   * @param sortIndex sortIndex or {@code null} for none
   */
  public ValueAddedModuleData setSortIndex(java.lang.Integer sortIndex) {
    this.sortIndex = sortIndex;
    return this;
  }

  /**
   * URI that the module leads to on click. This can be a web link or a deep link as mentioned in
   * https://developer.android.com/training/app-links/deep-linking.
   * @return value or {@code null} for none
   */
  public java.lang.String getUri() {
    return uri;
  }

  /**
   * URI that the module leads to on click. This can be a web link or a deep link as mentioned in
   * https://developer.android.com/training/app-links/deep-linking.
   * @param uri uri or {@code null} for none
   */
  public ValueAddedModuleData setUri(java.lang.String uri) {
    this.uri = uri;
    return this;
  }

  /**
   * Constraints that all must be met for the module to be shown.
   * @return value or {@code null} for none
   */
  public ModuleViewConstraints getViewConstraints() {
    return viewConstraints;
  }

  /**
   * Constraints that all must be met for the module to be shown.
   * @param viewConstraints viewConstraints or {@code null} for none
   */
  public ValueAddedModuleData setViewConstraints(ModuleViewConstraints viewConstraints) {
    this.viewConstraints = viewConstraints;
    return this;
  }

  @Override
  public ValueAddedModuleData set(String fieldName, Object value) {
    return (ValueAddedModuleData) super.set(fieldName, value);
  }

  @Override
  public ValueAddedModuleData clone() {
    return (ValueAddedModuleData) super.clone();
  }

}
