/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for TimeInterval.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TimeInterval extends com.google.api.client.json.GenericJson {

  /**
   * End time of the interval. Offset is not required. If an offset is provided and `start` time is
   * set, `start` must also include an offset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime end;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#timeInterval"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Start time of the interval. Offset is not required. If an offset is provided and `end` time is
   * set, `end` must also include an offset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime start;

  /**
   * End time of the interval. Offset is not required. If an offset is provided and `start` time is
   * set, `start` must also include an offset.
   * @return value or {@code null} for none
   */
  public DateTime getEnd() {
    return end;
  }

  /**
   * End time of the interval. Offset is not required. If an offset is provided and `start` time is
   * set, `start` must also include an offset.
   * @param end end or {@code null} for none
   */
  public TimeInterval setEnd(DateTime end) {
    this.end = end;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#timeInterval"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#timeInterval"`.
   * @param kind kind or {@code null} for none
   */
  public TimeInterval setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Start time of the interval. Offset is not required. If an offset is provided and `end` time is
   * set, `end` must also include an offset.
   * @return value or {@code null} for none
   */
  public DateTime getStart() {
    return start;
  }

  /**
   * Start time of the interval. Offset is not required. If an offset is provided and `end` time is
   * set, `end` must also include an offset.
   * @param start start or {@code null} for none
   */
  public TimeInterval setStart(DateTime start) {
    this.start = start;
    return this;
  }

  @Override
  public TimeInterval set(String fieldName, Object value) {
    return (TimeInterval) super.set(fieldName, value);
  }

  @Override
  public TimeInterval clone() {
    return (TimeInterval) super.clone();
  }

}
