/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for TicketCost.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TicketCost extends com.google.api.client.json.GenericJson {

  /**
   * A message describing any kind of discount that was applied.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString discountMessage;

  /**
   * The face value of the ticket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Money faceValue;

  /**
   * The actual purchase price of the ticket, after tax and/or discounts.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Money purchasePrice;

  /**
   * A message describing any kind of discount that was applied.
   * @return value or {@code null} for none
   */
  public LocalizedString getDiscountMessage() {
    return discountMessage;
  }

  /**
   * A message describing any kind of discount that was applied.
   * @param discountMessage discountMessage or {@code null} for none
   */
  public TicketCost setDiscountMessage(LocalizedString discountMessage) {
    this.discountMessage = discountMessage;
    return this;
  }

  /**
   * The face value of the ticket.
   * @return value or {@code null} for none
   */
  public Money getFaceValue() {
    return faceValue;
  }

  /**
   * The face value of the ticket.
   * @param faceValue faceValue or {@code null} for none
   */
  public TicketCost setFaceValue(Money faceValue) {
    this.faceValue = faceValue;
    return this;
  }

  /**
   * The actual purchase price of the ticket, after tax and/or discounts.
   * @return value or {@code null} for none
   */
  public Money getPurchasePrice() {
    return purchasePrice;
  }

  /**
   * The actual purchase price of the ticket, after tax and/or discounts.
   * @param purchasePrice purchasePrice or {@code null} for none
   */
  public TicketCost setPurchasePrice(Money purchasePrice) {
    this.purchasePrice = purchasePrice;
    return this;
  }

  @Override
  public TicketCost set(String fieldName, Object value) {
    return (TicketCost) super.set(fieldName, value);
  }

  @Override
  public TicketCost clone() {
    return (TicketCost) super.clone();
  }

}
