/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for TemplateItem.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TemplateItem extends com.google.api.client.json.GenericJson {

  /**
   * A reference to a field to display. If both `firstValue` and `secondValue` are populated, they
   * will both appear as one item with a slash between them. For example, values A and B would be
   * shown as "A / B".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FieldSelector firstValue;

  /**
   * A predefined item to display. Only one of `firstValue` or `predefinedItem` may be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String predefinedItem;

  /**
   * A reference to a field to display. This may only be populated if the `firstValue` field is
   * populated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FieldSelector secondValue;

  /**
   * A reference to a field to display. If both `firstValue` and `secondValue` are populated, they
   * will both appear as one item with a slash between them. For example, values A and B would be
   * shown as "A / B".
   * @return value or {@code null} for none
   */
  public FieldSelector getFirstValue() {
    return firstValue;
  }

  /**
   * A reference to a field to display. If both `firstValue` and `secondValue` are populated, they
   * will both appear as one item with a slash between them. For example, values A and B would be
   * shown as "A / B".
   * @param firstValue firstValue or {@code null} for none
   */
  public TemplateItem setFirstValue(FieldSelector firstValue) {
    this.firstValue = firstValue;
    return this;
  }

  /**
   * A predefined item to display. Only one of `firstValue` or `predefinedItem` may be set.
   * @return value or {@code null} for none
   */
  public java.lang.String getPredefinedItem() {
    return predefinedItem;
  }

  /**
   * A predefined item to display. Only one of `firstValue` or `predefinedItem` may be set.
   * @param predefinedItem predefinedItem or {@code null} for none
   */
  public TemplateItem setPredefinedItem(java.lang.String predefinedItem) {
    this.predefinedItem = predefinedItem;
    return this;
  }

  /**
   * A reference to a field to display. This may only be populated if the `firstValue` field is
   * populated.
   * @return value or {@code null} for none
   */
  public FieldSelector getSecondValue() {
    return secondValue;
  }

  /**
   * A reference to a field to display. This may only be populated if the `firstValue` field is
   * populated.
   * @param secondValue secondValue or {@code null} for none
   */
  public TemplateItem setSecondValue(FieldSelector secondValue) {
    this.secondValue = secondValue;
    return this;
  }

  @Override
  public TemplateItem set(String fieldName, Object value) {
    return (TemplateItem) super.set(fieldName, value);
  }

  @Override
  public TemplateItem clone() {
    return (TemplateItem) super.clone();
  }

}
