/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for SmartTap.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SmartTap extends com.google.api.client.json.GenericJson {

  /**
   * The unique identifier for a smart tap. This value should follow the format issuer ID.identifier
   * where the former is issued by Google and latter is the Smart Tap id. The Smart Tap id is a
   * Base64 encoded string which represents the id which was generated by the Google Pay app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Communication from merchant to user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<IssuerToUserInfo> infos;

  static {
    // hack to force ProGuard to consider IssuerToUserInfo used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(IssuerToUserInfo.class);
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#smartTap"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Smart Tap merchant ID of who engaged in the Smart Tap interaction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long merchantId;

  /**
   * The unique identifier for a smart tap. This value should follow the format issuer ID.identifier
   * where the former is issued by Google and latter is the Smart Tap id. The Smart Tap id is a
   * Base64 encoded string which represents the id which was generated by the Google Pay app.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The unique identifier for a smart tap. This value should follow the format issuer ID.identifier
   * where the former is issued by Google and latter is the Smart Tap id. The Smart Tap id is a
   * Base64 encoded string which represents the id which was generated by the Google Pay app.
   * @param id id or {@code null} for none
   */
  public SmartTap setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Communication from merchant to user.
   * @return value or {@code null} for none
   */
  public java.util.List<IssuerToUserInfo> getInfos() {
    return infos;
  }

  /**
   * Communication from merchant to user.
   * @param infos infos or {@code null} for none
   */
  public SmartTap setInfos(java.util.List<IssuerToUserInfo> infos) {
    this.infos = infos;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#smartTap"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#smartTap"`.
   * @param kind kind or {@code null} for none
   */
  public SmartTap setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Smart Tap merchant ID of who engaged in the Smart Tap interaction.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMerchantId() {
    return merchantId;
  }

  /**
   * Smart Tap merchant ID of who engaged in the Smart Tap interaction.
   * @param merchantId merchantId or {@code null} for none
   */
  public SmartTap setMerchantId(java.lang.Long merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  @Override
  public SmartTap set(String fieldName, Object value) {
    return (SmartTap) super.set(fieldName, value);
  }

  @Override
  public SmartTap clone() {
    return (SmartTap) super.clone();
  }

}
