/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Defines restrictions on the object that will be verified during save. Note: this is an advanced
 * feature, please contact Google for implementation support.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SaveRestrictions extends com.google.api.client.json.GenericJson {

  /**
   * Restrict the save of the referencing object to the given email address only. This is the hex
   * output of SHA256 sum of the email address, all lowercase and without any notations like "." or
   * "+", except "@". For example, for example@example.com, this value will be
   * 31c5543c1734d25c7206f5fd591525d0295bec6fe84ff82f946a34fe970a1e66 and for Example@example.com,
   * this value will be bc34f262c93ad7122763684ccea6f07fb7f5d8a2d11e60ce15a6f43fe70ce632 If email
   * address of the logged-in user who tries to save this pass does not match with the defined value
   * here, users won't be allowed to save this pass. They will instead be prompted with an error to
   * contact the issuer. This information should be gathered from the user with an explicit consent
   * via Sign in with Google integration https://developers.google.com/identity/authentication.
   * Please contact with support before using Save Restrictions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String restrictToEmailSha256;

  /**
   * Restrict the save of the referencing object to the given email address only. This is the hex
   * output of SHA256 sum of the email address, all lowercase and without any notations like "." or
   * "+", except "@". For example, for example@example.com, this value will be
   * 31c5543c1734d25c7206f5fd591525d0295bec6fe84ff82f946a34fe970a1e66 and for Example@example.com,
   * this value will be bc34f262c93ad7122763684ccea6f07fb7f5d8a2d11e60ce15a6f43fe70ce632 If email
   * address of the logged-in user who tries to save this pass does not match with the defined value
   * here, users won't be allowed to save this pass. They will instead be prompted with an error to
   * contact the issuer. This information should be gathered from the user with an explicit consent
   * via Sign in with Google integration https://developers.google.com/identity/authentication.
   * Please contact with support before using Save Restrictions.
   * @return value or {@code null} for none
   */
  public java.lang.String getRestrictToEmailSha256() {
    return restrictToEmailSha256;
  }

  /**
   * Restrict the save of the referencing object to the given email address only. This is the hex
   * output of SHA256 sum of the email address, all lowercase and without any notations like "." or
   * "+", except "@". For example, for example@example.com, this value will be
   * 31c5543c1734d25c7206f5fd591525d0295bec6fe84ff82f946a34fe970a1e66 and for Example@example.com,
   * this value will be bc34f262c93ad7122763684ccea6f07fb7f5d8a2d11e60ce15a6f43fe70ce632 If email
   * address of the logged-in user who tries to save this pass does not match with the defined value
   * here, users won't be allowed to save this pass. They will instead be prompted with an error to
   * contact the issuer. This information should be gathered from the user with an explicit consent
   * via Sign in with Google integration https://developers.google.com/identity/authentication.
   * Please contact with support before using Save Restrictions.
   * @param restrictToEmailSha256 restrictToEmailSha256 or {@code null} for none
   */
  public SaveRestrictions setRestrictToEmailSha256(java.lang.String restrictToEmailSha256) {
    this.restrictToEmailSha256 = restrictToEmailSha256;
    return this;
  }

  @Override
  public SaveRestrictions set(String fieldName, Object value) {
    return (SaveRestrictions) super.set(fieldName, value);
  }

  @Override
  public SaveRestrictions clone() {
    return (SaveRestrictions) super.clone();
  }

}
