/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * A payload containing many barcode values and start date/time.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RotatingBarcodeValues extends com.google.api.client.json.GenericJson {

  /**
   * Required. The amount of time each barcode is valid for.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long periodMillis;

  /**
   * Required. The date/time the first barcode is valid from. Barcodes will be rotated through using
   * period_millis defined on the object's RotatingBarcodeValueInfo. This is an ISO 8601 extended
   * format date/time, with an offset. Time may be specified up to nanosecond precision. Offsets may
   * be specified with seconds precision (even though offset seconds is not part of ISO 8601). For
   * example: `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of
   * April 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds
   * after the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String startDateTime;

  /**
   * Required. The values to encode in the barcode. At least one value is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> values;

  /**
   * Required. The amount of time each barcode is valid for.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPeriodMillis() {
    return periodMillis;
  }

  /**
   * Required. The amount of time each barcode is valid for.
   * @param periodMillis periodMillis or {@code null} for none
   */
  public RotatingBarcodeValues setPeriodMillis(java.lang.Long periodMillis) {
    this.periodMillis = periodMillis;
    return this;
  }

  /**
   * Required. The date/time the first barcode is valid from. Barcodes will be rotated through using
   * period_millis defined on the object's RotatingBarcodeValueInfo. This is an ISO 8601 extended
   * format date/time, with an offset. Time may be specified up to nanosecond precision. Offsets may
   * be specified with seconds precision (even though offset seconds is not part of ISO 8601). For
   * example: `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of
   * April 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds
   * after the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year.
   * @return value or {@code null} for none
   */
  public java.lang.String getStartDateTime() {
    return startDateTime;
  }

  /**
   * Required. The date/time the first barcode is valid from. Barcodes will be rotated through using
   * period_millis defined on the object's RotatingBarcodeValueInfo. This is an ISO 8601 extended
   * format date/time, with an offset. Time may be specified up to nanosecond precision. Offsets may
   * be specified with seconds precision (even though offset seconds is not part of ISO 8601). For
   * example: `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of
   * April 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds
   * after the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year.
   * @param startDateTime startDateTime or {@code null} for none
   */
  public RotatingBarcodeValues setStartDateTime(java.lang.String startDateTime) {
    this.startDateTime = startDateTime;
    return this;
  }

  /**
   * Required. The values to encode in the barcode. At least one value is required.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getValues() {
    return values;
  }

  /**
   * Required. The values to encode in the barcode. At least one value is required.
   * @param values values or {@code null} for none
   */
  public RotatingBarcodeValues setValues(java.util.List<java.lang.String> values) {
    this.values = values;
    return this;
  }

  @Override
  public RotatingBarcodeValues set(String fieldName, Object value) {
    return (RotatingBarcodeValues) super.set(fieldName, value);
  }

  @Override
  public RotatingBarcodeValues clone() {
    return (RotatingBarcodeValues) super.clone();
  }

}
