/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Configuration for the time-based OTP substitutions. See https://tools.ietf.org/html/rfc6238
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RotatingBarcodeTotpDetails extends com.google.api.client.json.GenericJson {

  /**
   * The TOTP algorithm used to generate the OTP.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String algorithm;

  /**
   * The TOTP parameters for each of the {totp_value_*} substitutions. The TotpParameters at index n
   * is used for the {totp_value_n} substitution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<RotatingBarcodeTotpDetailsTotpParameters> parameters;

  /**
   * The time interval used for the TOTP value generation, in milliseconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long periodMillis;

  /**
   * The TOTP algorithm used to generate the OTP.
   * @return value or {@code null} for none
   */
  public java.lang.String getAlgorithm() {
    return algorithm;
  }

  /**
   * The TOTP algorithm used to generate the OTP.
   * @param algorithm algorithm or {@code null} for none
   */
  public RotatingBarcodeTotpDetails setAlgorithm(java.lang.String algorithm) {
    this.algorithm = algorithm;
    return this;
  }

  /**
   * The TOTP parameters for each of the {totp_value_*} substitutions. The TotpParameters at index n
   * is used for the {totp_value_n} substitution.
   * @return value or {@code null} for none
   */
  public java.util.List<RotatingBarcodeTotpDetailsTotpParameters> getParameters() {
    return parameters;
  }

  /**
   * The TOTP parameters for each of the {totp_value_*} substitutions. The TotpParameters at index n
   * is used for the {totp_value_n} substitution.
   * @param parameters parameters or {@code null} for none
   */
  public RotatingBarcodeTotpDetails setParameters(java.util.List<RotatingBarcodeTotpDetailsTotpParameters> parameters) {
    this.parameters = parameters;
    return this;
  }

  /**
   * The time interval used for the TOTP value generation, in milliseconds.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPeriodMillis() {
    return periodMillis;
  }

  /**
   * The time interval used for the TOTP value generation, in milliseconds.
   * @param periodMillis periodMillis or {@code null} for none
   */
  public RotatingBarcodeTotpDetails setPeriodMillis(java.lang.Long periodMillis) {
    this.periodMillis = periodMillis;
    return this;
  }

  @Override
  public RotatingBarcodeTotpDetails set(String fieldName, Object value) {
    return (RotatingBarcodeTotpDetails) super.set(fieldName, value);
  }

  @Override
  public RotatingBarcodeTotpDetails clone() {
    return (RotatingBarcodeTotpDetails) super.clone();
  }

}
