/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Indicates if the object needs to have notification enabled. We support only one of
 * ExpiryNotification/UpcomingNotification. `expiryNotification` takes precedence over
 * `upcomingNotification`. In other words if `expiryNotification` is set, we ignore the
 * `upcomingNotification` field.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Notifications extends com.google.api.client.json.GenericJson {

  /**
   * A notification would be triggered at a specific time before the card expires.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ExpiryNotification expiryNotification;

  /**
   * A notification would be triggered at a specific time before the card becomes usable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpcomingNotification upcomingNotification;

  /**
   * A notification would be triggered at a specific time before the card expires.
   * @return value or {@code null} for none
   */
  public ExpiryNotification getExpiryNotification() {
    return expiryNotification;
  }

  /**
   * A notification would be triggered at a specific time before the card expires.
   * @param expiryNotification expiryNotification or {@code null} for none
   */
  public Notifications setExpiryNotification(ExpiryNotification expiryNotification) {
    this.expiryNotification = expiryNotification;
    return this;
  }

  /**
   * A notification would be triggered at a specific time before the card becomes usable.
   * @return value or {@code null} for none
   */
  public UpcomingNotification getUpcomingNotification() {
    return upcomingNotification;
  }

  /**
   * A notification would be triggered at a specific time before the card becomes usable.
   * @param upcomingNotification upcomingNotification or {@code null} for none
   */
  public Notifications setUpcomingNotification(UpcomingNotification upcomingNotification) {
    this.upcomingNotification = upcomingNotification;
    return this;
  }

  @Override
  public Notifications set(String fieldName, Object value) {
    return (Notifications) super.set(fieldName, value);
  }

  @Override
  public Notifications clone() {
    return (Notifications) super.clone();
  }

}
