/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for Money.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Money extends com.google.api.client.json.GenericJson {

  /**
   * The currency code, such as "USD" or "EUR."
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currencyCode;

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#money"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The unit of money amount in micros. For example, $1 USD would be represented as 1000000 micros.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long micros;

  /**
   * The currency code, such as "USD" or "EUR."
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrencyCode() {
    return currencyCode;
  }

  /**
   * The currency code, such as "USD" or "EUR."
   * @param currencyCode currencyCode or {@code null} for none
   */
  public Money setCurrencyCode(java.lang.String currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#money"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#money"`.
   * @param kind kind or {@code null} for none
   */
  public Money setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The unit of money amount in micros. For example, $1 USD would be represented as 1000000 micros.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMicros() {
    return micros;
  }

  /**
   * The unit of money amount in micros. For example, $1 USD would be represented as 1000000 micros.
   * @param micros micros or {@code null} for none
   */
  public Money setMicros(java.lang.Long micros) {
    this.micros = micros;
    return this;
  }

  @Override
  public Money set(String fieldName, Object value) {
    return (Money) super.set(fieldName, value);
  }

  @Override
  public Money clone() {
    return (Money) super.clone();
  }

}
