/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for ModifyLinkedOfferObjects.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ModifyLinkedOfferObjects extends com.google.api.client.json.GenericJson {

  /**
   * The linked offer object ids to add to the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> addLinkedOfferObjectIds;

  /**
   * The linked offer object ids to remove from the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> removeLinkedOfferObjectIds;

  /**
   * The linked offer object ids to add to the object.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAddLinkedOfferObjectIds() {
    return addLinkedOfferObjectIds;
  }

  /**
   * The linked offer object ids to add to the object.
   * @param addLinkedOfferObjectIds addLinkedOfferObjectIds or {@code null} for none
   */
  public ModifyLinkedOfferObjects setAddLinkedOfferObjectIds(java.util.List<java.lang.String> addLinkedOfferObjectIds) {
    this.addLinkedOfferObjectIds = addLinkedOfferObjectIds;
    return this;
  }

  /**
   * The linked offer object ids to remove from the object.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRemoveLinkedOfferObjectIds() {
    return removeLinkedOfferObjectIds;
  }

  /**
   * The linked offer object ids to remove from the object.
   * @param removeLinkedOfferObjectIds removeLinkedOfferObjectIds or {@code null} for none
   */
  public ModifyLinkedOfferObjects setRemoveLinkedOfferObjectIds(java.util.List<java.lang.String> removeLinkedOfferObjectIds) {
    this.removeLinkedOfferObjectIds = removeLinkedOfferObjectIds;
    return this;
  }

  @Override
  public ModifyLinkedOfferObjects set(String fieldName, Object value) {
    return (ModifyLinkedOfferObjects) super.set(fieldName, value);
  }

  @Override
  public ModifyLinkedOfferObjects clone() {
    return (ModifyLinkedOfferObjects) super.clone();
  }

}
