/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for LoyaltyPoints.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LoyaltyPoints extends com.google.api.client.json.GenericJson {

  /**
   * The account holder's loyalty point balance, such as "500" or "$10.00". Recommended maximum
   * length is 7 characters. This is a required field of `loyaltyPoints` and
   * `secondaryLoyaltyPoints`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LoyaltyPointsBalance balance;

  /**
   * The loyalty points label, such as "Points". Recommended maximum length is 9 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * Translated strings for the label. Recommended maximum length is 9 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedLabel;

  /**
   * The account holder's loyalty point balance, such as "500" or "$10.00". Recommended maximum
   * length is 7 characters. This is a required field of `loyaltyPoints` and
   * `secondaryLoyaltyPoints`.
   * @return value or {@code null} for none
   */
  public LoyaltyPointsBalance getBalance() {
    return balance;
  }

  /**
   * The account holder's loyalty point balance, such as "500" or "$10.00". Recommended maximum
   * length is 7 characters. This is a required field of `loyaltyPoints` and
   * `secondaryLoyaltyPoints`.
   * @param balance balance or {@code null} for none
   */
  public LoyaltyPoints setBalance(LoyaltyPointsBalance balance) {
    this.balance = balance;
    return this;
  }

  /**
   * The loyalty points label, such as "Points". Recommended maximum length is 9 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * The loyalty points label, such as "Points". Recommended maximum length is 9 characters.
   * @param label label or {@code null} for none
   */
  public LoyaltyPoints setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * Translated strings for the label. Recommended maximum length is 9 characters.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedLabel() {
    return localizedLabel;
  }

  /**
   * Translated strings for the label. Recommended maximum length is 9 characters.
   * @param localizedLabel localizedLabel or {@code null} for none
   */
  public LoyaltyPoints setLocalizedLabel(LocalizedString localizedLabel) {
    this.localizedLabel = localizedLabel;
    return this;
  }

  @Override
  public LoyaltyPoints set(String fieldName, Object value) {
    return (LoyaltyPoints) super.set(fieldName, value);
  }

  @Override
  public LoyaltyPoints clone() {
    return (LoyaltyPoints) super.clone();
  }

}
