/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for LatLongPoint.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LatLongPoint extends com.google.api.client.json.GenericJson {

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#latLongPoint"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The latitude specified as any value in the range of -90.0 through +90.0, both inclusive. Values
   * outside these bounds will be rejected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double latitude;

  /**
   * The longitude specified in the range -180.0 through +180.0, both inclusive. Values outside
   * these bounds will be rejected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double longitude;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#latLongPoint"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#latLongPoint"`.
   * @param kind kind or {@code null} for none
   */
  public LatLongPoint setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The latitude specified as any value in the range of -90.0 through +90.0, both inclusive. Values
   * outside these bounds will be rejected.
   * @return value or {@code null} for none
   */
  public java.lang.Double getLatitude() {
    return latitude;
  }

  /**
   * The latitude specified as any value in the range of -90.0 through +90.0, both inclusive. Values
   * outside these bounds will be rejected.
   * @param latitude latitude or {@code null} for none
   */
  public LatLongPoint setLatitude(java.lang.Double latitude) {
    this.latitude = latitude;
    return this;
  }

  /**
   * The longitude specified in the range -180.0 through +180.0, both inclusive. Values outside
   * these bounds will be rejected.
   * @return value or {@code null} for none
   */
  public java.lang.Double getLongitude() {
    return longitude;
  }

  /**
   * The longitude specified in the range -180.0 through +180.0, both inclusive. Values outside
   * these bounds will be rejected.
   * @param longitude longitude or {@code null} for none
   */
  public LatLongPoint setLongitude(java.lang.Double longitude) {
    this.longitude = longitude;
    return this;
  }

  @Override
  public LatLongPoint set(String fieldName, Object value) {
    return (LatLongPoint) super.set(fieldName, value);
  }

  @Override
  public LatLongPoint clone() {
    return (LatLongPoint) super.clone();
  }

}
