/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for JwtInsertResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class JwtInsertResponse extends com.google.api.client.json.GenericJson {

  /**
   * Data that corresponds to the ids of the provided classes and objects in the JWT. resources will
   * only include the non-empty arrays (i.e. if the JWT only includes eventTicketObjects, then that
   * is the only field that will be present in resources).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Resources resources;

  /**
   * A URI that, when opened, will allow the end user to save the object(s) identified in the JWT to
   * their Google account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String saveUri;

  /**
   * Data that corresponds to the ids of the provided classes and objects in the JWT. resources will
   * only include the non-empty arrays (i.e. if the JWT only includes eventTicketObjects, then that
   * is the only field that will be present in resources).
   * @return value or {@code null} for none
   */
  public Resources getResources() {
    return resources;
  }

  /**
   * Data that corresponds to the ids of the provided classes and objects in the JWT. resources will
   * only include the non-empty arrays (i.e. if the JWT only includes eventTicketObjects, then that
   * is the only field that will be present in resources).
   * @param resources resources or {@code null} for none
   */
  public JwtInsertResponse setResources(Resources resources) {
    this.resources = resources;
    return this;
  }

  /**
   * A URI that, when opened, will allow the end user to save the object(s) identified in the JWT to
   * their Google account.
   * @return value or {@code null} for none
   */
  public java.lang.String getSaveUri() {
    return saveUri;
  }

  /**
   * A URI that, when opened, will allow the end user to save the object(s) identified in the JWT to
   * their Google account.
   * @param saveUri saveUri or {@code null} for none
   */
  public JwtInsertResponse setSaveUri(java.lang.String saveUri) {
    this.saveUri = saveUri;
    return this;
  }

  @Override
  public JwtInsertResponse set(String fieldName, Object value) {
    return (JwtInsertResponse) super.set(fieldName, value);
  }

  @Override
  public JwtInsertResponse clone() {
    return (JwtInsertResponse) super.clone();
  }

}
