/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for GiftCardClass.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GiftCardClass extends com.google.api.client.json.GenericJson {

  /**
   * Determines whether the merchant supports gift card redemption using barcode. If true, app
   * displays a barcode for the gift card on the Gift card details screen. If false, a barcode is
   * not displayed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowBarcodeRedemption;

  /**
   * Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowMultipleUsersPerObject;

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppLinkData appLinkData;

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CallbackOptions callbackOptions;

  /**
   * The label to display for the card number, such as "Card Number".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cardNumberLabel;

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ClassTemplateInfo classTemplateInfo;

  /**
   * Country code used to display the card's country (when the user is not in that country), as well
   * as to display localized content when content is not available in the user's locale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String countryCode;

  /**
   * Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
   * `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support
   * Smart Tap.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableSmartTap;

  /**
   * The label to display for event number, such as "Target Event #".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eventNumberLabel;

  /**
   * Optional banner image displayed on the front of the card. If none is present, nothing will be
   * displayed. The image will display at 100% width.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image heroImage;

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hexBackgroundColor;

  /**
   * The URI of your application's home page. Populating the URI in this field results in the exact
   * same behavior as populating an URI in linksModuleData (when an object is rendered, a link to
   * the homepage is shown in what would usually be thought of as the linksModuleData section of the
   * object).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Uri homepageUri;

  /**
   * Required. The unique identifier for a class. This ID must be unique across all classes from an
   * issuer. This value should follow the format issuer ID. identifier where the former is issued by
   * Google and latter is chosen by you. Your unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ImageModuleData> imageModulesData;

  /**
   * Deprecated. Use textModulesData instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InfoModuleData infoModuleData;

  /**
   * Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
   * displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String issuerName;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#giftCardClass"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Links module data. If links module data is also defined on the object, both will be displayed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LinksModuleData linksModuleData;

  /**
   * Translated strings for the card_number_label.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedCardNumberLabel;

  /**
   * Translated strings for the event_number_label.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedEventNumberLabel;

  /**
   * Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure
   * full string is displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedIssuerName;

  /**
   * Translated strings for the merchant_name. The app may display an ellipsis after the first 20
   * characters to ensure full string is displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedMerchantName;

  /**
   * Translated strings for the pin_label.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedPinLabel;

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LatLongPoint> locations;

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MerchantLocation> merchantLocations;

  /**
   * Merchant name, such as "Adam's Apparel". The app may display an ellipsis after the first 20
   * characters to ensure full string is displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String merchantName;

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Message> messages;

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String multipleDevicesAndHoldersAllowedStatus;

  /**
   * Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
   * will attempt to trigger a field update notification to users. These notifications will only be
   * sent to users if the field is part of an allowlist. If not specified, no notification will be
   * triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE request,
   * otherwise a notification will not be triggered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String notifyPreference;

  /**
   * The label to display for the PIN, such as "4-digit PIN".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pinLabel;

  /**
   * The logo of the gift card program or company. This logo is displayed in both the details and
   * list views of the app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image programLogo;

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> redemptionIssuers;

  /**
   * The review comments set by the platform when a class is marked `approved` or `rejected`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Review review;

  /**
   * Required. The status of the class. This field can be set to `draft` or `underReview` using the
   * insert, patch, or update API calls. Once the review state is changed from `draft` it may not be
   * changed back to `draft`. You should keep this field to `draft` when the class is under
   * development. A `draft` class cannot be used to create any object. You should set this field to
   * `underReview` when you believe the class is ready for use. The platform will automatically set
   * this field to `approved` and it can be immediately used to create or migrate objects. When
   * updating an already `approved` class you should keep setting this field to `underReview`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reviewStatus;

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SecurityAnimation securityAnimation;

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TextModuleData> textModulesData;

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ValueAddedModuleData> valueAddedModuleData;

  /**
   * Deprecated
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long version;

  /**
   * View Unlock Requirement options for the gift card.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String viewUnlockRequirement;

  /**
   * The wide logo of the gift card program or company. When provided, this will be used in place of
   * the program logo in the top left of the card view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image wideProgramLogo;

  /**
   * Deprecated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image wordMark;

  /**
   * Determines whether the merchant supports gift card redemption using barcode. If true, app
   * displays a barcode for the gift card on the Gift card details screen. If false, a barcode is
   * not displayed.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowBarcodeRedemption() {
    return allowBarcodeRedemption;
  }

  /**
   * Determines whether the merchant supports gift card redemption using barcode. If true, app
   * displays a barcode for the gift card on the Gift card details screen. If false, a barcode is
   * not displayed.
   * @param allowBarcodeRedemption allowBarcodeRedemption or {@code null} for none
   */
  public GiftCardClass setAllowBarcodeRedemption(java.lang.Boolean allowBarcodeRedemption) {
    this.allowBarcodeRedemption = allowBarcodeRedemption;
    return this;
  }

  /**
   * Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowMultipleUsersPerObject() {
    return allowMultipleUsersPerObject;
  }

  /**
   * Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.
   * @param allowMultipleUsersPerObject allowMultipleUsersPerObject or {@code null} for none
   */
  public GiftCardClass setAllowMultipleUsersPerObject(java.lang.Boolean allowMultipleUsersPerObject) {
    this.allowMultipleUsersPerObject = allowMultipleUsersPerObject;
    return this;
  }

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * @return value or {@code null} for none
   */
  public AppLinkData getAppLinkData() {
    return appLinkData;
  }

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * @param appLinkData appLinkData or {@code null} for none
   */
  public GiftCardClass setAppLinkData(AppLinkData appLinkData) {
    this.appLinkData = appLinkData;
    return this;
  }

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * @return value or {@code null} for none
   */
  public CallbackOptions getCallbackOptions() {
    return callbackOptions;
  }

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * @param callbackOptions callbackOptions or {@code null} for none
   */
  public GiftCardClass setCallbackOptions(CallbackOptions callbackOptions) {
    this.callbackOptions = callbackOptions;
    return this;
  }

  /**
   * The label to display for the card number, such as "Card Number".
   * @return value or {@code null} for none
   */
  public java.lang.String getCardNumberLabel() {
    return cardNumberLabel;
  }

  /**
   * The label to display for the card number, such as "Card Number".
   * @param cardNumberLabel cardNumberLabel or {@code null} for none
   */
  public GiftCardClass setCardNumberLabel(java.lang.String cardNumberLabel) {
    this.cardNumberLabel = cardNumberLabel;
    return this;
  }

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * @return value or {@code null} for none
   */
  public ClassTemplateInfo getClassTemplateInfo() {
    return classTemplateInfo;
  }

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * @param classTemplateInfo classTemplateInfo or {@code null} for none
   */
  public GiftCardClass setClassTemplateInfo(ClassTemplateInfo classTemplateInfo) {
    this.classTemplateInfo = classTemplateInfo;
    return this;
  }

  /**
   * Country code used to display the card's country (when the user is not in that country), as well
   * as to display localized content when content is not available in the user's locale.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountryCode() {
    return countryCode;
  }

  /**
   * Country code used to display the card's country (when the user is not in that country), as well
   * as to display localized content when content is not available in the user's locale.
   * @param countryCode countryCode or {@code null} for none
   */
  public GiftCardClass setCountryCode(java.lang.String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
   * `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support
   * Smart Tap.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableSmartTap() {
    return enableSmartTap;
  }

  /**
   * Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
   * `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support
   * Smart Tap.
   * @param enableSmartTap enableSmartTap or {@code null} for none
   */
  public GiftCardClass setEnableSmartTap(java.lang.Boolean enableSmartTap) {
    this.enableSmartTap = enableSmartTap;
    return this;
  }

  /**
   * The label to display for event number, such as "Target Event #".
   * @return value or {@code null} for none
   */
  public java.lang.String getEventNumberLabel() {
    return eventNumberLabel;
  }

  /**
   * The label to display for event number, such as "Target Event #".
   * @param eventNumberLabel eventNumberLabel or {@code null} for none
   */
  public GiftCardClass setEventNumberLabel(java.lang.String eventNumberLabel) {
    this.eventNumberLabel = eventNumberLabel;
    return this;
  }

  /**
   * Optional banner image displayed on the front of the card. If none is present, nothing will be
   * displayed. The image will display at 100% width.
   * @return value or {@code null} for none
   */
  public Image getHeroImage() {
    return heroImage;
  }

  /**
   * Optional banner image displayed on the front of the card. If none is present, nothing will be
   * displayed. The image will display at 100% width.
   * @param heroImage heroImage or {@code null} for none
   */
  public GiftCardClass setHeroImage(Image heroImage) {
    this.heroImage = heroImage;
    return this;
  }

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * @return value or {@code null} for none
   */
  public java.lang.String getHexBackgroundColor() {
    return hexBackgroundColor;
  }

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * @param hexBackgroundColor hexBackgroundColor or {@code null} for none
   */
  public GiftCardClass setHexBackgroundColor(java.lang.String hexBackgroundColor) {
    this.hexBackgroundColor = hexBackgroundColor;
    return this;
  }

  /**
   * The URI of your application's home page. Populating the URI in this field results in the exact
   * same behavior as populating an URI in linksModuleData (when an object is rendered, a link to
   * the homepage is shown in what would usually be thought of as the linksModuleData section of the
   * object).
   * @return value or {@code null} for none
   */
  public Uri getHomepageUri() {
    return homepageUri;
  }

  /**
   * The URI of your application's home page. Populating the URI in this field results in the exact
   * same behavior as populating an URI in linksModuleData (when an object is rendered, a link to
   * the homepage is shown in what would usually be thought of as the linksModuleData section of the
   * object).
   * @param homepageUri homepageUri or {@code null} for none
   */
  public GiftCardClass setHomepageUri(Uri homepageUri) {
    this.homepageUri = homepageUri;
    return this;
  }

  /**
   * Required. The unique identifier for a class. This ID must be unique across all classes from an
   * issuer. This value should follow the format issuer ID. identifier where the former is issued by
   * Google and latter is chosen by you. Your unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Required. The unique identifier for a class. This ID must be unique across all classes from an
   * issuer. This value should follow the format issuer ID. identifier where the former is issued by
   * Google and latter is chosen by you. Your unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * @param id id or {@code null} for none
   */
  public GiftCardClass setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * @return value or {@code null} for none
   */
  public java.util.List<ImageModuleData> getImageModulesData() {
    return imageModulesData;
  }

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * @param imageModulesData imageModulesData or {@code null} for none
   */
  public GiftCardClass setImageModulesData(java.util.List<ImageModuleData> imageModulesData) {
    this.imageModulesData = imageModulesData;
    return this;
  }

  /**
   * Deprecated. Use textModulesData instead.
   * @return value or {@code null} for none
   */
  public InfoModuleData getInfoModuleData() {
    return infoModuleData;
  }

  /**
   * Deprecated. Use textModulesData instead.
   * @param infoModuleData infoModuleData or {@code null} for none
   */
  public GiftCardClass setInfoModuleData(InfoModuleData infoModuleData) {
    this.infoModuleData = infoModuleData;
    return this;
  }

  /**
   * Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
   * displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public java.lang.String getIssuerName() {
    return issuerName;
  }

  /**
   * Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
   * displayed on smaller screens.
   * @param issuerName issuerName or {@code null} for none
   */
  public GiftCardClass setIssuerName(java.lang.String issuerName) {
    this.issuerName = issuerName;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#giftCardClass"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#giftCardClass"`.
   * @param kind kind or {@code null} for none
   */
  public GiftCardClass setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Links module data. If links module data is also defined on the object, both will be displayed.
   * @return value or {@code null} for none
   */
  public LinksModuleData getLinksModuleData() {
    return linksModuleData;
  }

  /**
   * Links module data. If links module data is also defined on the object, both will be displayed.
   * @param linksModuleData linksModuleData or {@code null} for none
   */
  public GiftCardClass setLinksModuleData(LinksModuleData linksModuleData) {
    this.linksModuleData = linksModuleData;
    return this;
  }

  /**
   * Translated strings for the card_number_label.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedCardNumberLabel() {
    return localizedCardNumberLabel;
  }

  /**
   * Translated strings for the card_number_label.
   * @param localizedCardNumberLabel localizedCardNumberLabel or {@code null} for none
   */
  public GiftCardClass setLocalizedCardNumberLabel(LocalizedString localizedCardNumberLabel) {
    this.localizedCardNumberLabel = localizedCardNumberLabel;
    return this;
  }

  /**
   * Translated strings for the event_number_label.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedEventNumberLabel() {
    return localizedEventNumberLabel;
  }

  /**
   * Translated strings for the event_number_label.
   * @param localizedEventNumberLabel localizedEventNumberLabel or {@code null} for none
   */
  public GiftCardClass setLocalizedEventNumberLabel(LocalizedString localizedEventNumberLabel) {
    this.localizedEventNumberLabel = localizedEventNumberLabel;
    return this;
  }

  /**
   * Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure
   * full string is displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedIssuerName() {
    return localizedIssuerName;
  }

  /**
   * Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure
   * full string is displayed on smaller screens.
   * @param localizedIssuerName localizedIssuerName or {@code null} for none
   */
  public GiftCardClass setLocalizedIssuerName(LocalizedString localizedIssuerName) {
    this.localizedIssuerName = localizedIssuerName;
    return this;
  }

  /**
   * Translated strings for the merchant_name. The app may display an ellipsis after the first 20
   * characters to ensure full string is displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedMerchantName() {
    return localizedMerchantName;
  }

  /**
   * Translated strings for the merchant_name. The app may display an ellipsis after the first 20
   * characters to ensure full string is displayed on smaller screens.
   * @param localizedMerchantName localizedMerchantName or {@code null} for none
   */
  public GiftCardClass setLocalizedMerchantName(LocalizedString localizedMerchantName) {
    this.localizedMerchantName = localizedMerchantName;
    return this;
  }

  /**
   * Translated strings for the pin_label.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedPinLabel() {
    return localizedPinLabel;
  }

  /**
   * Translated strings for the pin_label.
   * @param localizedPinLabel localizedPinLabel or {@code null} for none
   */
  public GiftCardClass setLocalizedPinLabel(LocalizedString localizedPinLabel) {
    this.localizedPinLabel = localizedPinLabel;
    return this;
  }

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * @return value or {@code null} for none
   */
  public java.util.List<LatLongPoint> getLocations() {
    return locations;
  }

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * @param locations locations or {@code null} for none
   */
  public GiftCardClass setLocations(java.util.List<LatLongPoint> locations) {
    this.locations = locations;
    return this;
  }

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * @return value or {@code null} for none
   */
  public java.util.List<MerchantLocation> getMerchantLocations() {
    return merchantLocations;
  }

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * @param merchantLocations merchantLocations or {@code null} for none
   */
  public GiftCardClass setMerchantLocations(java.util.List<MerchantLocation> merchantLocations) {
    this.merchantLocations = merchantLocations;
    return this;
  }

  /**
   * Merchant name, such as "Adam's Apparel". The app may display an ellipsis after the first 20
   * characters to ensure full string is displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public java.lang.String getMerchantName() {
    return merchantName;
  }

  /**
   * Merchant name, such as "Adam's Apparel". The app may display an ellipsis after the first 20
   * characters to ensure full string is displayed on smaller screens.
   * @param merchantName merchantName or {@code null} for none
   */
  public GiftCardClass setMerchantName(java.lang.String merchantName) {
    this.merchantName = merchantName;
    return this;
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * @return value or {@code null} for none
   */
  public java.util.List<Message> getMessages() {
    return messages;
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * @param messages messages or {@code null} for none
   */
  public GiftCardClass setMessages(java.util.List<Message> messages) {
    this.messages = messages;
    return this;
  }

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * @return value or {@code null} for none
   */
  public java.lang.String getMultipleDevicesAndHoldersAllowedStatus() {
    return multipleDevicesAndHoldersAllowedStatus;
  }

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * @param multipleDevicesAndHoldersAllowedStatus multipleDevicesAndHoldersAllowedStatus or {@code null} for none
   */
  public GiftCardClass setMultipleDevicesAndHoldersAllowedStatus(java.lang.String multipleDevicesAndHoldersAllowedStatus) {
    this.multipleDevicesAndHoldersAllowedStatus = multipleDevicesAndHoldersAllowedStatus;
    return this;
  }

  /**
   * Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
   * will attempt to trigger a field update notification to users. These notifications will only be
   * sent to users if the field is part of an allowlist. If not specified, no notification will be
   * triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE request,
   * otherwise a notification will not be triggered.
   * @return value or {@code null} for none
   */
  public java.lang.String getNotifyPreference() {
    return notifyPreference;
  }

  /**
   * Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
   * will attempt to trigger a field update notification to users. These notifications will only be
   * sent to users if the field is part of an allowlist. If not specified, no notification will be
   * triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE request,
   * otherwise a notification will not be triggered.
   * @param notifyPreference notifyPreference or {@code null} for none
   */
  public GiftCardClass setNotifyPreference(java.lang.String notifyPreference) {
    this.notifyPreference = notifyPreference;
    return this;
  }

  /**
   * The label to display for the PIN, such as "4-digit PIN".
   * @return value or {@code null} for none
   */
  public java.lang.String getPinLabel() {
    return pinLabel;
  }

  /**
   * The label to display for the PIN, such as "4-digit PIN".
   * @param pinLabel pinLabel or {@code null} for none
   */
  public GiftCardClass setPinLabel(java.lang.String pinLabel) {
    this.pinLabel = pinLabel;
    return this;
  }

  /**
   * The logo of the gift card program or company. This logo is displayed in both the details and
   * list views of the app.
   * @return value or {@code null} for none
   */
  public Image getProgramLogo() {
    return programLogo;
  }

  /**
   * The logo of the gift card program or company. This logo is displayed in both the details and
   * list views of the app.
   * @param programLogo programLogo or {@code null} for none
   */
  public GiftCardClass setProgramLogo(Image programLogo) {
    this.programLogo = programLogo;
    return this;
  }

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getRedemptionIssuers() {
    return redemptionIssuers;
  }

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * @param redemptionIssuers redemptionIssuers or {@code null} for none
   */
  public GiftCardClass setRedemptionIssuers(java.util.List<java.lang.Long> redemptionIssuers) {
    this.redemptionIssuers = redemptionIssuers;
    return this;
  }

  /**
   * The review comments set by the platform when a class is marked `approved` or `rejected`.
   * @return value or {@code null} for none
   */
  public Review getReview() {
    return review;
  }

  /**
   * The review comments set by the platform when a class is marked `approved` or `rejected`.
   * @param review review or {@code null} for none
   */
  public GiftCardClass setReview(Review review) {
    this.review = review;
    return this;
  }

  /**
   * Required. The status of the class. This field can be set to `draft` or `underReview` using the
   * insert, patch, or update API calls. Once the review state is changed from `draft` it may not be
   * changed back to `draft`. You should keep this field to `draft` when the class is under
   * development. A `draft` class cannot be used to create any object. You should set this field to
   * `underReview` when you believe the class is ready for use. The platform will automatically set
   * this field to `approved` and it can be immediately used to create or migrate objects. When
   * updating an already `approved` class you should keep setting this field to `underReview`.
   * @return value or {@code null} for none
   */
  public java.lang.String getReviewStatus() {
    return reviewStatus;
  }

  /**
   * Required. The status of the class. This field can be set to `draft` or `underReview` using the
   * insert, patch, or update API calls. Once the review state is changed from `draft` it may not be
   * changed back to `draft`. You should keep this field to `draft` when the class is under
   * development. A `draft` class cannot be used to create any object. You should set this field to
   * `underReview` when you believe the class is ready for use. The platform will automatically set
   * this field to `approved` and it can be immediately used to create or migrate objects. When
   * updating an already `approved` class you should keep setting this field to `underReview`.
   * @param reviewStatus reviewStatus or {@code null} for none
   */
  public GiftCardClass setReviewStatus(java.lang.String reviewStatus) {
    this.reviewStatus = reviewStatus;
    return this;
  }

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * @return value or {@code null} for none
   */
  public SecurityAnimation getSecurityAnimation() {
    return securityAnimation;
  }

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * @param securityAnimation securityAnimation or {@code null} for none
   */
  public GiftCardClass setSecurityAnimation(SecurityAnimation securityAnimation) {
    this.securityAnimation = securityAnimation;
    return this;
  }

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * @return value or {@code null} for none
   */
  public java.util.List<TextModuleData> getTextModulesData() {
    return textModulesData;
  }

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * @param textModulesData textModulesData or {@code null} for none
   */
  public GiftCardClass setTextModulesData(java.util.List<TextModuleData> textModulesData) {
    this.textModulesData = textModulesData;
    return this;
  }

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * @return value or {@code null} for none
   */
  public java.util.List<ValueAddedModuleData> getValueAddedModuleData() {
    return valueAddedModuleData;
  }

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * @param valueAddedModuleData valueAddedModuleData or {@code null} for none
   */
  public GiftCardClass setValueAddedModuleData(java.util.List<ValueAddedModuleData> valueAddedModuleData) {
    this.valueAddedModuleData = valueAddedModuleData;
    return this;
  }

  /**
   * Deprecated
   * @return value or {@code null} for none
   */
  public java.lang.Long getVersion() {
    return version;
  }

  /**
   * Deprecated
   * @param version version or {@code null} for none
   */
  public GiftCardClass setVersion(java.lang.Long version) {
    this.version = version;
    return this;
  }

  /**
   * View Unlock Requirement options for the gift card.
   * @return value or {@code null} for none
   */
  public java.lang.String getViewUnlockRequirement() {
    return viewUnlockRequirement;
  }

  /**
   * View Unlock Requirement options for the gift card.
   * @param viewUnlockRequirement viewUnlockRequirement or {@code null} for none
   */
  public GiftCardClass setViewUnlockRequirement(java.lang.String viewUnlockRequirement) {
    this.viewUnlockRequirement = viewUnlockRequirement;
    return this;
  }

  /**
   * The wide logo of the gift card program or company. When provided, this will be used in place of
   * the program logo in the top left of the card view.
   * @return value or {@code null} for none
   */
  public Image getWideProgramLogo() {
    return wideProgramLogo;
  }

  /**
   * The wide logo of the gift card program or company. When provided, this will be used in place of
   * the program logo in the top left of the card view.
   * @param wideProgramLogo wideProgramLogo or {@code null} for none
   */
  public GiftCardClass setWideProgramLogo(Image wideProgramLogo) {
    this.wideProgramLogo = wideProgramLogo;
    return this;
  }

  /**
   * Deprecated.
   * @return value or {@code null} for none
   */
  public Image getWordMark() {
    return wordMark;
  }

  /**
   * Deprecated.
   * @param wordMark wordMark or {@code null} for none
   */
  public GiftCardClass setWordMark(Image wordMark) {
    this.wordMark = wordMark;
    return this;
  }

  @Override
  public GiftCardClass set(String fieldName, Object value) {
    return (GiftCardClass) super.set(fieldName, value);
  }

  @Override
  public GiftCardClass clone() {
    return (GiftCardClass) super.clone();
  }

}
