/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Generic Object
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GenericObject extends com.google.api.client.json.GenericJson {

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding class only object AppLinkData will be displayed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppLinkData appLinkData;

  /**
   * The barcode type and value. If pass does not have a barcode, we can allow the issuer to set
   * Barcode.alternate_text and display just that.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Barcode barcode;

  /**
   * Required. The header of the pass. This is usually the Business name such as "XXX Gym", "AAA
   * Insurance". This field is required and appears in the header row at the very top of the pass.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString cardTitle;

  /**
   * Required. The class associated with this object. The class must be of the same type as this
   * object, must already exist, and must be approved. Class IDs should follow the format
   * `issuerID.identifier` where `issuerID` is issued by Google and `identifier` is chosen by you.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String classId;

  /**
   * Specify which `GenericType` the card belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String genericType;

  /**
   * Information that controls how passes are grouped together.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GroupingInfo groupingInfo;

  /**
   * Indicates if the object has users. This field is set by the platform.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasUsers;

  /**
   * Required. The title of the pass, such as "50% off coupon" or "Library card" or "Voucher". This
   * field is required and appears in the title row of the pass detail view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString header;

  /**
   * Banner image displayed on the front of the card if present. The image will be displayed at 100%
   * width.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image heroImage;

  /**
   * The background color for the card. If not set, the dominant color of the hero image is used,
   * and if no hero image is set, the dominant color of the logo is used and if logo is not set, a
   * color would be chosen by Google.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hexBackgroundColor;

  /**
   * Required. The unique identifier for an object. This ID must be unique across all objects from
   * an issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is
   * issued by Google and `identifier` is chosen by you. The unique identifier can only include
   * alphanumeric characters, `.`, `_`, or `-`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Image module data. Only one of the image from class and one from object level will be rendered
   * when both set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ImageModuleData> imageModulesData;

  /**
   * linked_object_ids are a list of other objects such as event ticket, loyalty, offer, generic,
   * giftcard, transit and boarding pass that should be automatically attached to this generic
   * object. If a user had saved this generic card, then these linked_object_ids would be
   * automatically pushed to the user's wallet (unless they turned off the setting to receive such
   * linked passes). Make sure that objects present in linked_object_ids are already inserted - if
   * not, calls would fail. Once linked, the linked objects cannot be unlinked. You cannot link
   * objects belonging to another issuer. There is a limit to the number of objects that can be
   * linked to a single object. After the limit is reached, new linked objects in the call will be
   * ignored silently. Object IDs should follow the format issuer ID. identifier where the former is
   * issued by Google and the latter is chosen by you.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> linkedObjectIds;

  /**
   * Links module data. If `linksModuleData` is also defined on the class, both will be displayed.
   * The maximum number of these fields displayed is 10 from class and 10 from object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LinksModuleData linksModuleData;

  /**
   * The logo image of the pass. This image is displayed in the card detail view in upper left, and
   * also on the list/thumbnail view. If the logo is not present, the first letter of `cardTitle`
   * would be shown as logo.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image logo;

  /**
   * Merchant locations. There is a maximum of ten on the object. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MerchantLocation> merchantLocations;

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Message> messages;

  /**
   * The notification settings that are enabled for this object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Notifications notifications;

  /**
   * Pass constraints for the object. Includes limiting NFC and screenshot behaviors.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PassConstraints passConstraints;

  /**
   * The rotating barcode settings/details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RotatingBarcode rotatingBarcode;

  /**
   * Restrictions on the object that needs to be verified before the user tries to save the pass.
   * Note that this restrictions will only be applied during save time. If the restrictions changed
   * after a user saves the pass, the new restrictions will not be applied to an already saved pass.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SaveRestrictions saveRestrictions;

  /**
   * The value that will be transmitted to a Smart Tap certified terminal over NFC for this object.
   * The class level fields `enableSmartTap` and `redemptionIssuers` must also be set up correctly
   * in order for the pass to support Smart Tap. Only ASCII characters are supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String smartTapRedemptionValue;

  /**
   * The state of the object. This field is used to determine how an object is displayed in the app.
   * For example, an `inactive` object is moved to the "Expired passes" section. If this is not
   * provided, the object would be considered `ACTIVE`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * The title label of the pass, such as location where this pass can be used. Appears right above
   * the title in the title row in the pass detail view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString subheader;

  /**
   * Text module data. If `textModulesData` is also defined on the class, both will be displayed.
   * The maximum number of these fields displayed is 10 from class and 10 from object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TextModuleData> textModulesData;

  /**
   * The time period this object will be considered valid or usable. When the time period is passed,
   * the object will be considered expired, which will affect the rendering on user's devices.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeInterval validTimeInterval;

  /**
   * Optional value added module data. Maximum of ten on the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ValueAddedModuleData> valueAddedModuleData;

  /**
   * The wide logo of the pass. When provided, this will be used in place of the logo in the top
   * left of the card view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image wideLogo;

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding class only object AppLinkData will be displayed.
   * @return value or {@code null} for none
   */
  public AppLinkData getAppLinkData() {
    return appLinkData;
  }

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding class only object AppLinkData will be displayed.
   * @param appLinkData appLinkData or {@code null} for none
   */
  public GenericObject setAppLinkData(AppLinkData appLinkData) {
    this.appLinkData = appLinkData;
    return this;
  }

  /**
   * The barcode type and value. If pass does not have a barcode, we can allow the issuer to set
   * Barcode.alternate_text and display just that.
   * @return value or {@code null} for none
   */
  public Barcode getBarcode() {
    return barcode;
  }

  /**
   * The barcode type and value. If pass does not have a barcode, we can allow the issuer to set
   * Barcode.alternate_text and display just that.
   * @param barcode barcode or {@code null} for none
   */
  public GenericObject setBarcode(Barcode barcode) {
    this.barcode = barcode;
    return this;
  }

  /**
   * Required. The header of the pass. This is usually the Business name such as "XXX Gym", "AAA
   * Insurance". This field is required and appears in the header row at the very top of the pass.
   * @return value or {@code null} for none
   */
  public LocalizedString getCardTitle() {
    return cardTitle;
  }

  /**
   * Required. The header of the pass. This is usually the Business name such as "XXX Gym", "AAA
   * Insurance". This field is required and appears in the header row at the very top of the pass.
   * @param cardTitle cardTitle or {@code null} for none
   */
  public GenericObject setCardTitle(LocalizedString cardTitle) {
    this.cardTitle = cardTitle;
    return this;
  }

  /**
   * Required. The class associated with this object. The class must be of the same type as this
   * object, must already exist, and must be approved. Class IDs should follow the format
   * `issuerID.identifier` where `issuerID` is issued by Google and `identifier` is chosen by you.
   * @return value or {@code null} for none
   */
  public java.lang.String getClassId() {
    return classId;
  }

  /**
   * Required. The class associated with this object. The class must be of the same type as this
   * object, must already exist, and must be approved. Class IDs should follow the format
   * `issuerID.identifier` where `issuerID` is issued by Google and `identifier` is chosen by you.
   * @param classId classId or {@code null} for none
   */
  public GenericObject setClassId(java.lang.String classId) {
    this.classId = classId;
    return this;
  }

  /**
   * Specify which `GenericType` the card belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.String getGenericType() {
    return genericType;
  }

  /**
   * Specify which `GenericType` the card belongs to.
   * @param genericType genericType or {@code null} for none
   */
  public GenericObject setGenericType(java.lang.String genericType) {
    this.genericType = genericType;
    return this;
  }

  /**
   * Information that controls how passes are grouped together.
   * @return value or {@code null} for none
   */
  public GroupingInfo getGroupingInfo() {
    return groupingInfo;
  }

  /**
   * Information that controls how passes are grouped together.
   * @param groupingInfo groupingInfo or {@code null} for none
   */
  public GenericObject setGroupingInfo(GroupingInfo groupingInfo) {
    this.groupingInfo = groupingInfo;
    return this;
  }

  /**
   * Indicates if the object has users. This field is set by the platform.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasUsers() {
    return hasUsers;
  }

  /**
   * Indicates if the object has users. This field is set by the platform.
   * @param hasUsers hasUsers or {@code null} for none
   */
  public GenericObject setHasUsers(java.lang.Boolean hasUsers) {
    this.hasUsers = hasUsers;
    return this;
  }

  /**
   * Required. The title of the pass, such as "50% off coupon" or "Library card" or "Voucher". This
   * field is required and appears in the title row of the pass detail view.
   * @return value or {@code null} for none
   */
  public LocalizedString getHeader() {
    return header;
  }

  /**
   * Required. The title of the pass, such as "50% off coupon" or "Library card" or "Voucher". This
   * field is required and appears in the title row of the pass detail view.
   * @param header header or {@code null} for none
   */
  public GenericObject setHeader(LocalizedString header) {
    this.header = header;
    return this;
  }

  /**
   * Banner image displayed on the front of the card if present. The image will be displayed at 100%
   * width.
   * @return value or {@code null} for none
   */
  public Image getHeroImage() {
    return heroImage;
  }

  /**
   * Banner image displayed on the front of the card if present. The image will be displayed at 100%
   * width.
   * @param heroImage heroImage or {@code null} for none
   */
  public GenericObject setHeroImage(Image heroImage) {
    this.heroImage = heroImage;
    return this;
  }

  /**
   * The background color for the card. If not set, the dominant color of the hero image is used,
   * and if no hero image is set, the dominant color of the logo is used and if logo is not set, a
   * color would be chosen by Google.
   * @return value or {@code null} for none
   */
  public java.lang.String getHexBackgroundColor() {
    return hexBackgroundColor;
  }

  /**
   * The background color for the card. If not set, the dominant color of the hero image is used,
   * and if no hero image is set, the dominant color of the logo is used and if logo is not set, a
   * color would be chosen by Google.
   * @param hexBackgroundColor hexBackgroundColor or {@code null} for none
   */
  public GenericObject setHexBackgroundColor(java.lang.String hexBackgroundColor) {
    this.hexBackgroundColor = hexBackgroundColor;
    return this;
  }

  /**
   * Required. The unique identifier for an object. This ID must be unique across all objects from
   * an issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is
   * issued by Google and `identifier` is chosen by you. The unique identifier can only include
   * alphanumeric characters, `.`, `_`, or `-`.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Required. The unique identifier for an object. This ID must be unique across all objects from
   * an issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is
   * issued by Google and `identifier` is chosen by you. The unique identifier can only include
   * alphanumeric characters, `.`, `_`, or `-`.
   * @param id id or {@code null} for none
   */
  public GenericObject setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Image module data. Only one of the image from class and one from object level will be rendered
   * when both set.
   * @return value or {@code null} for none
   */
  public java.util.List<ImageModuleData> getImageModulesData() {
    return imageModulesData;
  }

  /**
   * Image module data. Only one of the image from class and one from object level will be rendered
   * when both set.
   * @param imageModulesData imageModulesData or {@code null} for none
   */
  public GenericObject setImageModulesData(java.util.List<ImageModuleData> imageModulesData) {
    this.imageModulesData = imageModulesData;
    return this;
  }

  /**
   * linked_object_ids are a list of other objects such as event ticket, loyalty, offer, generic,
   * giftcard, transit and boarding pass that should be automatically attached to this generic
   * object. If a user had saved this generic card, then these linked_object_ids would be
   * automatically pushed to the user's wallet (unless they turned off the setting to receive such
   * linked passes). Make sure that objects present in linked_object_ids are already inserted - if
   * not, calls would fail. Once linked, the linked objects cannot be unlinked. You cannot link
   * objects belonging to another issuer. There is a limit to the number of objects that can be
   * linked to a single object. After the limit is reached, new linked objects in the call will be
   * ignored silently. Object IDs should follow the format issuer ID. identifier where the former is
   * issued by Google and the latter is chosen by you.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLinkedObjectIds() {
    return linkedObjectIds;
  }

  /**
   * linked_object_ids are a list of other objects such as event ticket, loyalty, offer, generic,
   * giftcard, transit and boarding pass that should be automatically attached to this generic
   * object. If a user had saved this generic card, then these linked_object_ids would be
   * automatically pushed to the user's wallet (unless they turned off the setting to receive such
   * linked passes). Make sure that objects present in linked_object_ids are already inserted - if
   * not, calls would fail. Once linked, the linked objects cannot be unlinked. You cannot link
   * objects belonging to another issuer. There is a limit to the number of objects that can be
   * linked to a single object. After the limit is reached, new linked objects in the call will be
   * ignored silently. Object IDs should follow the format issuer ID. identifier where the former is
   * issued by Google and the latter is chosen by you.
   * @param linkedObjectIds linkedObjectIds or {@code null} for none
   */
  public GenericObject setLinkedObjectIds(java.util.List<java.lang.String> linkedObjectIds) {
    this.linkedObjectIds = linkedObjectIds;
    return this;
  }

  /**
   * Links module data. If `linksModuleData` is also defined on the class, both will be displayed.
   * The maximum number of these fields displayed is 10 from class and 10 from object.
   * @return value or {@code null} for none
   */
  public LinksModuleData getLinksModuleData() {
    return linksModuleData;
  }

  /**
   * Links module data. If `linksModuleData` is also defined on the class, both will be displayed.
   * The maximum number of these fields displayed is 10 from class and 10 from object.
   * @param linksModuleData linksModuleData or {@code null} for none
   */
  public GenericObject setLinksModuleData(LinksModuleData linksModuleData) {
    this.linksModuleData = linksModuleData;
    return this;
  }

  /**
   * The logo image of the pass. This image is displayed in the card detail view in upper left, and
   * also on the list/thumbnail view. If the logo is not present, the first letter of `cardTitle`
   * would be shown as logo.
   * @return value or {@code null} for none
   */
  public Image getLogo() {
    return logo;
  }

  /**
   * The logo image of the pass. This image is displayed in the card detail view in upper left, and
   * also on the list/thumbnail view. If the logo is not present, the first letter of `cardTitle`
   * would be shown as logo.
   * @param logo logo or {@code null} for none
   */
  public GenericObject setLogo(Image logo) {
    this.logo = logo;
    return this;
  }

  /**
   * Merchant locations. There is a maximum of ten on the object. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * @return value or {@code null} for none
   */
  public java.util.List<MerchantLocation> getMerchantLocations() {
    return merchantLocations;
  }

  /**
   * Merchant locations. There is a maximum of ten on the object. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * @param merchantLocations merchantLocations or {@code null} for none
   */
  public GenericObject setMerchantLocations(java.util.List<MerchantLocation> merchantLocations) {
    this.merchantLocations = merchantLocations;
    return this;
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * @return value or {@code null} for none
   */
  public java.util.List<Message> getMessages() {
    return messages;
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * @param messages messages or {@code null} for none
   */
  public GenericObject setMessages(java.util.List<Message> messages) {
    this.messages = messages;
    return this;
  }

  /**
   * The notification settings that are enabled for this object.
   * @return value or {@code null} for none
   */
  public Notifications getNotifications() {
    return notifications;
  }

  /**
   * The notification settings that are enabled for this object.
   * @param notifications notifications or {@code null} for none
   */
  public GenericObject setNotifications(Notifications notifications) {
    this.notifications = notifications;
    return this;
  }

  /**
   * Pass constraints for the object. Includes limiting NFC and screenshot behaviors.
   * @return value or {@code null} for none
   */
  public PassConstraints getPassConstraints() {
    return passConstraints;
  }

  /**
   * Pass constraints for the object. Includes limiting NFC and screenshot behaviors.
   * @param passConstraints passConstraints or {@code null} for none
   */
  public GenericObject setPassConstraints(PassConstraints passConstraints) {
    this.passConstraints = passConstraints;
    return this;
  }

  /**
   * The rotating barcode settings/details.
   * @return value or {@code null} for none
   */
  public RotatingBarcode getRotatingBarcode() {
    return rotatingBarcode;
  }

  /**
   * The rotating barcode settings/details.
   * @param rotatingBarcode rotatingBarcode or {@code null} for none
   */
  public GenericObject setRotatingBarcode(RotatingBarcode rotatingBarcode) {
    this.rotatingBarcode = rotatingBarcode;
    return this;
  }

  /**
   * Restrictions on the object that needs to be verified before the user tries to save the pass.
   * Note that this restrictions will only be applied during save time. If the restrictions changed
   * after a user saves the pass, the new restrictions will not be applied to an already saved pass.
   * @return value or {@code null} for none
   */
  public SaveRestrictions getSaveRestrictions() {
    return saveRestrictions;
  }

  /**
   * Restrictions on the object that needs to be verified before the user tries to save the pass.
   * Note that this restrictions will only be applied during save time. If the restrictions changed
   * after a user saves the pass, the new restrictions will not be applied to an already saved pass.
   * @param saveRestrictions saveRestrictions or {@code null} for none
   */
  public GenericObject setSaveRestrictions(SaveRestrictions saveRestrictions) {
    this.saveRestrictions = saveRestrictions;
    return this;
  }

  /**
   * The value that will be transmitted to a Smart Tap certified terminal over NFC for this object.
   * The class level fields `enableSmartTap` and `redemptionIssuers` must also be set up correctly
   * in order for the pass to support Smart Tap. Only ASCII characters are supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getSmartTapRedemptionValue() {
    return smartTapRedemptionValue;
  }

  /**
   * The value that will be transmitted to a Smart Tap certified terminal over NFC for this object.
   * The class level fields `enableSmartTap` and `redemptionIssuers` must also be set up correctly
   * in order for the pass to support Smart Tap. Only ASCII characters are supported.
   * @param smartTapRedemptionValue smartTapRedemptionValue or {@code null} for none
   */
  public GenericObject setSmartTapRedemptionValue(java.lang.String smartTapRedemptionValue) {
    this.smartTapRedemptionValue = smartTapRedemptionValue;
    return this;
  }

  /**
   * The state of the object. This field is used to determine how an object is displayed in the app.
   * For example, an `inactive` object is moved to the "Expired passes" section. If this is not
   * provided, the object would be considered `ACTIVE`.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * The state of the object. This field is used to determine how an object is displayed in the app.
   * For example, an `inactive` object is moved to the "Expired passes" section. If this is not
   * provided, the object would be considered `ACTIVE`.
   * @param state state or {@code null} for none
   */
  public GenericObject setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * The title label of the pass, such as location where this pass can be used. Appears right above
   * the title in the title row in the pass detail view.
   * @return value or {@code null} for none
   */
  public LocalizedString getSubheader() {
    return subheader;
  }

  /**
   * The title label of the pass, such as location where this pass can be used. Appears right above
   * the title in the title row in the pass detail view.
   * @param subheader subheader or {@code null} for none
   */
  public GenericObject setSubheader(LocalizedString subheader) {
    this.subheader = subheader;
    return this;
  }

  /**
   * Text module data. If `textModulesData` is also defined on the class, both will be displayed.
   * The maximum number of these fields displayed is 10 from class and 10 from object.
   * @return value or {@code null} for none
   */
  public java.util.List<TextModuleData> getTextModulesData() {
    return textModulesData;
  }

  /**
   * Text module data. If `textModulesData` is also defined on the class, both will be displayed.
   * The maximum number of these fields displayed is 10 from class and 10 from object.
   * @param textModulesData textModulesData or {@code null} for none
   */
  public GenericObject setTextModulesData(java.util.List<TextModuleData> textModulesData) {
    this.textModulesData = textModulesData;
    return this;
  }

  /**
   * The time period this object will be considered valid or usable. When the time period is passed,
   * the object will be considered expired, which will affect the rendering on user's devices.
   * @return value or {@code null} for none
   */
  public TimeInterval getValidTimeInterval() {
    return validTimeInterval;
  }

  /**
   * The time period this object will be considered valid or usable. When the time period is passed,
   * the object will be considered expired, which will affect the rendering on user's devices.
   * @param validTimeInterval validTimeInterval or {@code null} for none
   */
  public GenericObject setValidTimeInterval(TimeInterval validTimeInterval) {
    this.validTimeInterval = validTimeInterval;
    return this;
  }

  /**
   * Optional value added module data. Maximum of ten on the object.
   * @return value or {@code null} for none
   */
  public java.util.List<ValueAddedModuleData> getValueAddedModuleData() {
    return valueAddedModuleData;
  }

  /**
   * Optional value added module data. Maximum of ten on the object.
   * @param valueAddedModuleData valueAddedModuleData or {@code null} for none
   */
  public GenericObject setValueAddedModuleData(java.util.List<ValueAddedModuleData> valueAddedModuleData) {
    this.valueAddedModuleData = valueAddedModuleData;
    return this;
  }

  /**
   * The wide logo of the pass. When provided, this will be used in place of the logo in the top
   * left of the card view.
   * @return value or {@code null} for none
   */
  public Image getWideLogo() {
    return wideLogo;
  }

  /**
   * The wide logo of the pass. When provided, this will be used in place of the logo in the top
   * left of the card view.
   * @param wideLogo wideLogo or {@code null} for none
   */
  public GenericObject setWideLogo(Image wideLogo) {
    this.wideLogo = wideLogo;
    return this;
  }

  @Override
  public GenericObject set(String fieldName, Object value) {
    return (GenericObject) super.set(fieldName, value);
  }

  @Override
  public GenericObject clone() {
    return (GenericObject) super.clone();
  }

}
