/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for FrequentFlyerInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FrequentFlyerInfo extends com.google.api.client.json.GenericJson {

  /**
   * Frequent flyer number. Required for each nested object of kind
   * `walletobjects#frequentFlyerInfo`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String frequentFlyerNumber;

  /**
   * Frequent flyer program name. eg: "Lufthansa Miles & More"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString frequentFlyerProgramName;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#frequentFlyerInfo"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Frequent flyer number. Required for each nested object of kind
   * `walletobjects#frequentFlyerInfo`.
   * @return value or {@code null} for none
   */
  public java.lang.String getFrequentFlyerNumber() {
    return frequentFlyerNumber;
  }

  /**
   * Frequent flyer number. Required for each nested object of kind
   * `walletobjects#frequentFlyerInfo`.
   * @param frequentFlyerNumber frequentFlyerNumber or {@code null} for none
   */
  public FrequentFlyerInfo setFrequentFlyerNumber(java.lang.String frequentFlyerNumber) {
    this.frequentFlyerNumber = frequentFlyerNumber;
    return this;
  }

  /**
   * Frequent flyer program name. eg: "Lufthansa Miles & More"
   * @return value or {@code null} for none
   */
  public LocalizedString getFrequentFlyerProgramName() {
    return frequentFlyerProgramName;
  }

  /**
   * Frequent flyer program name. eg: "Lufthansa Miles & More"
   * @param frequentFlyerProgramName frequentFlyerProgramName or {@code null} for none
   */
  public FrequentFlyerInfo setFrequentFlyerProgramName(LocalizedString frequentFlyerProgramName) {
    this.frequentFlyerProgramName = frequentFlyerProgramName;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#frequentFlyerInfo"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#frequentFlyerInfo"`.
   * @param kind kind or {@code null} for none
   */
  public FrequentFlyerInfo setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public FrequentFlyerInfo set(String fieldName, Object value) {
    return (FrequentFlyerInfo) super.set(fieldName, value);
  }

  @Override
  public FrequentFlyerInfo clone() {
    return (FrequentFlyerInfo) super.clone();
  }

}
