/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for FlightClass.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FlightClass extends com.google.api.client.json.GenericJson {

  /**
   * Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowMultipleUsersPerObject;

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppLinkData appLinkData;

  /**
   * Policies for boarding and seating. These will inform which labels will be shown to users.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BoardingAndSeatingPolicy boardingAndSeatingPolicy;

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CallbackOptions callbackOptions;

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ClassTemplateInfo classTemplateInfo;

  /**
   * Country code used to display the card's country (when the user is not in that country), as well
   * as to display localized content when content is not available in the user's locale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String countryCode;

  /**
   * Required. Destination airport.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AirportInfo destination;

  /**
   * Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
   * `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support
   * Smart Tap.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableSmartTap;

  /**
   * Required. Information about the flight carrier and number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FlightHeader flightHeader;

  /**
   * Status of this flight. If unset, Google will compute status based on data from other sources,
   * such as FlightStats, etc. Note: Google-computed status will not be returned in API responses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String flightStatus;

  /**
   * Optional banner image displayed on the front of the card. If none is present, nothing will be
   * displayed. The image will display at 100% width.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image heroImage;

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hexBackgroundColor;

  /**
   * The URI of your application's home page. Populating the URI in this field results in the exact
   * same behavior as populating an URI in linksModuleData (when an object is rendered, a link to
   * the homepage is shown in what would usually be thought of as the linksModuleData section of the
   * object).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Uri homepageUri;

  /**
   * Required. The unique identifier for a class. This ID must be unique across all classes from an
   * issuer. This value should follow the format issuer ID. identifier where the former is issued by
   * Google and latter is chosen by you. Your unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ImageModuleData> imageModulesData;

  /**
   * Deprecated. Use textModulesData instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InfoModuleData infoModuleData;

  /**
   * Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
   * displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String issuerName;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#flightClass"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * If this field is present, boarding passes served to a user's device will always be in this
   * language. Represents the BCP 47 language tag. Example values are "en-US", "en-GB", "de", or
   * "de-AT".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageOverride;

  /**
   * Links module data. If links module data is also defined on the object, both will be displayed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LinksModuleData linksModuleData;

  /**
   * The boarding time as it would be printed on the boarding pass. This is an ISO 8601 extended
   * format date/time without an offset. Time may be specified up to millisecond precision. eg:
   * `2027-03-05T06:30:00` This should be the local date/time at the airport (not a UTC time).
   * Google will reject the request if UTC offset is provided. Time zones will be calculated by
   * Google based on departure airport.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String localBoardingDateTime;

  /**
   * The estimated time the aircraft plans to reach the destination gate (not the runway) or the
   * actual time it reached the gate. This field should be set if at least one of the below is true:
   * - It differs from the scheduled time. Google will use it to calculate the delay. - The aircraft
   * already arrived at the gate. Google will use it to inform the user that the flight has arrived
   * at the gate. This is an ISO 8601 extended format date/time without an offset. Time may be
   * specified up to millisecond precision. eg: `2027-03-05T06:30:00` This should be the local
   * date/time at the airport (not a UTC time). Google will reject the request if UTC offset is
   * provided. Time zones will be calculated by Google based on arrival airport.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String localEstimatedOrActualArrivalDateTime;

  /**
   * The estimated time the aircraft plans to pull from the gate or the actual time the aircraft
   * already pulled from the gate. Note: This is not the runway time. This field should be set if at
   * least one of the below is true: - It differs from the scheduled time. Google will use it to
   * calculate the delay. - The aircraft already pulled from the gate. Google will use it to inform
   * the user when the flight actually departed. This is an ISO 8601 extended format date/time
   * without an offset. Time may be specified up to millisecond precision. eg: `2027-03-05T06:30:00`
   * This should be the local date/time at the airport (not a UTC time). Google will reject the
   * request if UTC offset is provided. Time zones will be calculated by Google based on departure
   * airport.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String localEstimatedOrActualDepartureDateTime;

  /**
   * The gate closing time as it would be printed on the boarding pass. Do not set this field if you
   * do not want to print it in the boarding pass. This is an ISO 8601 extended format date/time
   * without an offset. Time may be specified up to millisecond precision. eg: `2027-03-05T06:30:00`
   * This should be the local date/time at the airport (not a UTC time). Google will reject the
   * request if UTC offset is provided. Time zones will be calculated by Google based on departure
   * airport.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String localGateClosingDateTime;

  /**
   * The scheduled time the aircraft plans to reach the destination gate (not the runway). Note:
   * This field should not change too close to the flight time. For updates to departure times
   * (delays, etc), please set `localEstimatedOrActualArrivalDateTime`. This is an ISO 8601 extended
   * format date/time without an offset. Time may be specified up to millisecond precision. eg:
   * `2027-03-05T06:30:00` This should be the local date/time at the airport (not a UTC time).
   * Google will reject the request if UTC offset is provided. Time zones will be calculated by
   * Google based on arrival airport.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String localScheduledArrivalDateTime;

  /**
   * Required. The scheduled date and time when the aircraft is expected to depart the gate (not the
   * runway) Note: This field should not change too close to the departure time. For updates to
   * departure times (delays, etc), please set `localEstimatedOrActualDepartureDateTime`. This is an
   * ISO 8601 extended format date/time without an offset. Time may be specified up to millisecond
   * precision. eg: `2027-03-05T06:30:00` This should be the local date/time at the airport (not a
   * UTC time). Google will reject the request if UTC offset is provided. Time zones will be
   * calculated by Google based on departure airport.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String localScheduledDepartureDateTime;

  /**
   * Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure
   * full string is displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedIssuerName;

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LatLongPoint> locations;

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected by the validator. These locations will trigger a
   * notification when a user enters within a Google-set radius of the point. This field replaces
   * the deprecated LatLongPoints.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MerchantLocation> merchantLocations;

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Message> messages;

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String multipleDevicesAndHoldersAllowedStatus;

  /**
   * Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
   * will attempt to trigger a field update notification to users. These notifications will only be
   * sent to users if the field is part of an allowlist. If not specified, no notification will be
   * triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE request,
   * otherwise a notification will not be triggered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String notifyPreference;

  /**
   * Required. Origin airport.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AirportInfo origin;

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> redemptionIssuers;

  /**
   * The review comments set by the platform when a class is marked `approved` or `rejected`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Review review;

  /**
   * Required. The status of the class. This field can be set to `draft` or `underReview` using the
   * insert, patch, or update API calls. Once the review state is changed from `draft` it may not be
   * changed back to `draft`. You should keep this field to `draft` when the class is under
   * development. A `draft` class cannot be used to create any object. You should set this field to
   * `underReview` when you believe the class is ready for use. The platform will automatically set
   * this field to `approved` and it can be immediately used to create or migrate objects. When
   * updating an already `approved` class you should keep setting this field to `underReview`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reviewStatus;

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SecurityAnimation securityAnimation;

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TextModuleData> textModulesData;

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ValueAddedModuleData> valueAddedModuleData;

  /**
   * Deprecated
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long version;

  /**
   * View Unlock Requirement options for the boarding pass.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String viewUnlockRequirement;

  /**
   * Deprecated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image wordMark;

  /**
   * Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowMultipleUsersPerObject() {
    return allowMultipleUsersPerObject;
  }

  /**
   * Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.
   * @param allowMultipleUsersPerObject allowMultipleUsersPerObject or {@code null} for none
   */
  public FlightClass setAllowMultipleUsersPerObject(java.lang.Boolean allowMultipleUsersPerObject) {
    this.allowMultipleUsersPerObject = allowMultipleUsersPerObject;
    return this;
  }

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * @return value or {@code null} for none
   */
  public AppLinkData getAppLinkData() {
    return appLinkData;
  }

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * @param appLinkData appLinkData or {@code null} for none
   */
  public FlightClass setAppLinkData(AppLinkData appLinkData) {
    this.appLinkData = appLinkData;
    return this;
  }

  /**
   * Policies for boarding and seating. These will inform which labels will be shown to users.
   * @return value or {@code null} for none
   */
  public BoardingAndSeatingPolicy getBoardingAndSeatingPolicy() {
    return boardingAndSeatingPolicy;
  }

  /**
   * Policies for boarding and seating. These will inform which labels will be shown to users.
   * @param boardingAndSeatingPolicy boardingAndSeatingPolicy or {@code null} for none
   */
  public FlightClass setBoardingAndSeatingPolicy(BoardingAndSeatingPolicy boardingAndSeatingPolicy) {
    this.boardingAndSeatingPolicy = boardingAndSeatingPolicy;
    return this;
  }

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * @return value or {@code null} for none
   */
  public CallbackOptions getCallbackOptions() {
    return callbackOptions;
  }

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * @param callbackOptions callbackOptions or {@code null} for none
   */
  public FlightClass setCallbackOptions(CallbackOptions callbackOptions) {
    this.callbackOptions = callbackOptions;
    return this;
  }

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * @return value or {@code null} for none
   */
  public ClassTemplateInfo getClassTemplateInfo() {
    return classTemplateInfo;
  }

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * @param classTemplateInfo classTemplateInfo or {@code null} for none
   */
  public FlightClass setClassTemplateInfo(ClassTemplateInfo classTemplateInfo) {
    this.classTemplateInfo = classTemplateInfo;
    return this;
  }

  /**
   * Country code used to display the card's country (when the user is not in that country), as well
   * as to display localized content when content is not available in the user's locale.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountryCode() {
    return countryCode;
  }

  /**
   * Country code used to display the card's country (when the user is not in that country), as well
   * as to display localized content when content is not available in the user's locale.
   * @param countryCode countryCode or {@code null} for none
   */
  public FlightClass setCountryCode(java.lang.String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * Required. Destination airport.
   * @return value or {@code null} for none
   */
  public AirportInfo getDestination() {
    return destination;
  }

  /**
   * Required. Destination airport.
   * @param destination destination or {@code null} for none
   */
  public FlightClass setDestination(AirportInfo destination) {
    this.destination = destination;
    return this;
  }

  /**
   * Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
   * `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support
   * Smart Tap.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableSmartTap() {
    return enableSmartTap;
  }

  /**
   * Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
   * `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support
   * Smart Tap.
   * @param enableSmartTap enableSmartTap or {@code null} for none
   */
  public FlightClass setEnableSmartTap(java.lang.Boolean enableSmartTap) {
    this.enableSmartTap = enableSmartTap;
    return this;
  }

  /**
   * Required. Information about the flight carrier and number.
   * @return value or {@code null} for none
   */
  public FlightHeader getFlightHeader() {
    return flightHeader;
  }

  /**
   * Required. Information about the flight carrier and number.
   * @param flightHeader flightHeader or {@code null} for none
   */
  public FlightClass setFlightHeader(FlightHeader flightHeader) {
    this.flightHeader = flightHeader;
    return this;
  }

  /**
   * Status of this flight. If unset, Google will compute status based on data from other sources,
   * such as FlightStats, etc. Note: Google-computed status will not be returned in API responses.
   * @return value or {@code null} for none
   */
  public java.lang.String getFlightStatus() {
    return flightStatus;
  }

  /**
   * Status of this flight. If unset, Google will compute status based on data from other sources,
   * such as FlightStats, etc. Note: Google-computed status will not be returned in API responses.
   * @param flightStatus flightStatus or {@code null} for none
   */
  public FlightClass setFlightStatus(java.lang.String flightStatus) {
    this.flightStatus = flightStatus;
    return this;
  }

  /**
   * Optional banner image displayed on the front of the card. If none is present, nothing will be
   * displayed. The image will display at 100% width.
   * @return value or {@code null} for none
   */
  public Image getHeroImage() {
    return heroImage;
  }

  /**
   * Optional banner image displayed on the front of the card. If none is present, nothing will be
   * displayed. The image will display at 100% width.
   * @param heroImage heroImage or {@code null} for none
   */
  public FlightClass setHeroImage(Image heroImage) {
    this.heroImage = heroImage;
    return this;
  }

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * @return value or {@code null} for none
   */
  public java.lang.String getHexBackgroundColor() {
    return hexBackgroundColor;
  }

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * @param hexBackgroundColor hexBackgroundColor or {@code null} for none
   */
  public FlightClass setHexBackgroundColor(java.lang.String hexBackgroundColor) {
    this.hexBackgroundColor = hexBackgroundColor;
    return this;
  }

  /**
   * The URI of your application's home page. Populating the URI in this field results in the exact
   * same behavior as populating an URI in linksModuleData (when an object is rendered, a link to
   * the homepage is shown in what would usually be thought of as the linksModuleData section of the
   * object).
   * @return value or {@code null} for none
   */
  public Uri getHomepageUri() {
    return homepageUri;
  }

  /**
   * The URI of your application's home page. Populating the URI in this field results in the exact
   * same behavior as populating an URI in linksModuleData (when an object is rendered, a link to
   * the homepage is shown in what would usually be thought of as the linksModuleData section of the
   * object).
   * @param homepageUri homepageUri or {@code null} for none
   */
  public FlightClass setHomepageUri(Uri homepageUri) {
    this.homepageUri = homepageUri;
    return this;
  }

  /**
   * Required. The unique identifier for a class. This ID must be unique across all classes from an
   * issuer. This value should follow the format issuer ID. identifier where the former is issued by
   * Google and latter is chosen by you. Your unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Required. The unique identifier for a class. This ID must be unique across all classes from an
   * issuer. This value should follow the format issuer ID. identifier where the former is issued by
   * Google and latter is chosen by you. Your unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * @param id id or {@code null} for none
   */
  public FlightClass setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * @return value or {@code null} for none
   */
  public java.util.List<ImageModuleData> getImageModulesData() {
    return imageModulesData;
  }

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * @param imageModulesData imageModulesData or {@code null} for none
   */
  public FlightClass setImageModulesData(java.util.List<ImageModuleData> imageModulesData) {
    this.imageModulesData = imageModulesData;
    return this;
  }

  /**
   * Deprecated. Use textModulesData instead.
   * @return value or {@code null} for none
   */
  public InfoModuleData getInfoModuleData() {
    return infoModuleData;
  }

  /**
   * Deprecated. Use textModulesData instead.
   * @param infoModuleData infoModuleData or {@code null} for none
   */
  public FlightClass setInfoModuleData(InfoModuleData infoModuleData) {
    this.infoModuleData = infoModuleData;
    return this;
  }

  /**
   * Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
   * displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public java.lang.String getIssuerName() {
    return issuerName;
  }

  /**
   * Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
   * displayed on smaller screens.
   * @param issuerName issuerName or {@code null} for none
   */
  public FlightClass setIssuerName(java.lang.String issuerName) {
    this.issuerName = issuerName;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#flightClass"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#flightClass"`.
   * @param kind kind or {@code null} for none
   */
  public FlightClass setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * If this field is present, boarding passes served to a user's device will always be in this
   * language. Represents the BCP 47 language tag. Example values are "en-US", "en-GB", "de", or
   * "de-AT".
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageOverride() {
    return languageOverride;
  }

  /**
   * If this field is present, boarding passes served to a user's device will always be in this
   * language. Represents the BCP 47 language tag. Example values are "en-US", "en-GB", "de", or
   * "de-AT".
   * @param languageOverride languageOverride or {@code null} for none
   */
  public FlightClass setLanguageOverride(java.lang.String languageOverride) {
    this.languageOverride = languageOverride;
    return this;
  }

  /**
   * Links module data. If links module data is also defined on the object, both will be displayed.
   * @return value or {@code null} for none
   */
  public LinksModuleData getLinksModuleData() {
    return linksModuleData;
  }

  /**
   * Links module data. If links module data is also defined on the object, both will be displayed.
   * @param linksModuleData linksModuleData or {@code null} for none
   */
  public FlightClass setLinksModuleData(LinksModuleData linksModuleData) {
    this.linksModuleData = linksModuleData;
    return this;
  }

  /**
   * The boarding time as it would be printed on the boarding pass. This is an ISO 8601 extended
   * format date/time without an offset. Time may be specified up to millisecond precision. eg:
   * `2027-03-05T06:30:00` This should be the local date/time at the airport (not a UTC time).
   * Google will reject the request if UTC offset is provided. Time zones will be calculated by
   * Google based on departure airport.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocalBoardingDateTime() {
    return localBoardingDateTime;
  }

  /**
   * The boarding time as it would be printed on the boarding pass. This is an ISO 8601 extended
   * format date/time without an offset. Time may be specified up to millisecond precision. eg:
   * `2027-03-05T06:30:00` This should be the local date/time at the airport (not a UTC time).
   * Google will reject the request if UTC offset is provided. Time zones will be calculated by
   * Google based on departure airport.
   * @param localBoardingDateTime localBoardingDateTime or {@code null} for none
   */
  public FlightClass setLocalBoardingDateTime(java.lang.String localBoardingDateTime) {
    this.localBoardingDateTime = localBoardingDateTime;
    return this;
  }

  /**
   * The estimated time the aircraft plans to reach the destination gate (not the runway) or the
   * actual time it reached the gate. This field should be set if at least one of the below is true:
   * - It differs from the scheduled time. Google will use it to calculate the delay. - The aircraft
   * already arrived at the gate. Google will use it to inform the user that the flight has arrived
   * at the gate. This is an ISO 8601 extended format date/time without an offset. Time may be
   * specified up to millisecond precision. eg: `2027-03-05T06:30:00` This should be the local
   * date/time at the airport (not a UTC time). Google will reject the request if UTC offset is
   * provided. Time zones will be calculated by Google based on arrival airport.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocalEstimatedOrActualArrivalDateTime() {
    return localEstimatedOrActualArrivalDateTime;
  }

  /**
   * The estimated time the aircraft plans to reach the destination gate (not the runway) or the
   * actual time it reached the gate. This field should be set if at least one of the below is true:
   * - It differs from the scheduled time. Google will use it to calculate the delay. - The aircraft
   * already arrived at the gate. Google will use it to inform the user that the flight has arrived
   * at the gate. This is an ISO 8601 extended format date/time without an offset. Time may be
   * specified up to millisecond precision. eg: `2027-03-05T06:30:00` This should be the local
   * date/time at the airport (not a UTC time). Google will reject the request if UTC offset is
   * provided. Time zones will be calculated by Google based on arrival airport.
   * @param localEstimatedOrActualArrivalDateTime localEstimatedOrActualArrivalDateTime or {@code null} for none
   */
  public FlightClass setLocalEstimatedOrActualArrivalDateTime(java.lang.String localEstimatedOrActualArrivalDateTime) {
    this.localEstimatedOrActualArrivalDateTime = localEstimatedOrActualArrivalDateTime;
    return this;
  }

  /**
   * The estimated time the aircraft plans to pull from the gate or the actual time the aircraft
   * already pulled from the gate. Note: This is not the runway time. This field should be set if at
   * least one of the below is true: - It differs from the scheduled time. Google will use it to
   * calculate the delay. - The aircraft already pulled from the gate. Google will use it to inform
   * the user when the flight actually departed. This is an ISO 8601 extended format date/time
   * without an offset. Time may be specified up to millisecond precision. eg: `2027-03-05T06:30:00`
   * This should be the local date/time at the airport (not a UTC time). Google will reject the
   * request if UTC offset is provided. Time zones will be calculated by Google based on departure
   * airport.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocalEstimatedOrActualDepartureDateTime() {
    return localEstimatedOrActualDepartureDateTime;
  }

  /**
   * The estimated time the aircraft plans to pull from the gate or the actual time the aircraft
   * already pulled from the gate. Note: This is not the runway time. This field should be set if at
   * least one of the below is true: - It differs from the scheduled time. Google will use it to
   * calculate the delay. - The aircraft already pulled from the gate. Google will use it to inform
   * the user when the flight actually departed. This is an ISO 8601 extended format date/time
   * without an offset. Time may be specified up to millisecond precision. eg: `2027-03-05T06:30:00`
   * This should be the local date/time at the airport (not a UTC time). Google will reject the
   * request if UTC offset is provided. Time zones will be calculated by Google based on departure
   * airport.
   * @param localEstimatedOrActualDepartureDateTime localEstimatedOrActualDepartureDateTime or {@code null} for none
   */
  public FlightClass setLocalEstimatedOrActualDepartureDateTime(java.lang.String localEstimatedOrActualDepartureDateTime) {
    this.localEstimatedOrActualDepartureDateTime = localEstimatedOrActualDepartureDateTime;
    return this;
  }

  /**
   * The gate closing time as it would be printed on the boarding pass. Do not set this field if you
   * do not want to print it in the boarding pass. This is an ISO 8601 extended format date/time
   * without an offset. Time may be specified up to millisecond precision. eg: `2027-03-05T06:30:00`
   * This should be the local date/time at the airport (not a UTC time). Google will reject the
   * request if UTC offset is provided. Time zones will be calculated by Google based on departure
   * airport.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocalGateClosingDateTime() {
    return localGateClosingDateTime;
  }

  /**
   * The gate closing time as it would be printed on the boarding pass. Do not set this field if you
   * do not want to print it in the boarding pass. This is an ISO 8601 extended format date/time
   * without an offset. Time may be specified up to millisecond precision. eg: `2027-03-05T06:30:00`
   * This should be the local date/time at the airport (not a UTC time). Google will reject the
   * request if UTC offset is provided. Time zones will be calculated by Google based on departure
   * airport.
   * @param localGateClosingDateTime localGateClosingDateTime or {@code null} for none
   */
  public FlightClass setLocalGateClosingDateTime(java.lang.String localGateClosingDateTime) {
    this.localGateClosingDateTime = localGateClosingDateTime;
    return this;
  }

  /**
   * The scheduled time the aircraft plans to reach the destination gate (not the runway). Note:
   * This field should not change too close to the flight time. For updates to departure times
   * (delays, etc), please set `localEstimatedOrActualArrivalDateTime`. This is an ISO 8601 extended
   * format date/time without an offset. Time may be specified up to millisecond precision. eg:
   * `2027-03-05T06:30:00` This should be the local date/time at the airport (not a UTC time).
   * Google will reject the request if UTC offset is provided. Time zones will be calculated by
   * Google based on arrival airport.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocalScheduledArrivalDateTime() {
    return localScheduledArrivalDateTime;
  }

  /**
   * The scheduled time the aircraft plans to reach the destination gate (not the runway). Note:
   * This field should not change too close to the flight time. For updates to departure times
   * (delays, etc), please set `localEstimatedOrActualArrivalDateTime`. This is an ISO 8601 extended
   * format date/time without an offset. Time may be specified up to millisecond precision. eg:
   * `2027-03-05T06:30:00` This should be the local date/time at the airport (not a UTC time).
   * Google will reject the request if UTC offset is provided. Time zones will be calculated by
   * Google based on arrival airport.
   * @param localScheduledArrivalDateTime localScheduledArrivalDateTime or {@code null} for none
   */
  public FlightClass setLocalScheduledArrivalDateTime(java.lang.String localScheduledArrivalDateTime) {
    this.localScheduledArrivalDateTime = localScheduledArrivalDateTime;
    return this;
  }

  /**
   * Required. The scheduled date and time when the aircraft is expected to depart the gate (not the
   * runway) Note: This field should not change too close to the departure time. For updates to
   * departure times (delays, etc), please set `localEstimatedOrActualDepartureDateTime`. This is an
   * ISO 8601 extended format date/time without an offset. Time may be specified up to millisecond
   * precision. eg: `2027-03-05T06:30:00` This should be the local date/time at the airport (not a
   * UTC time). Google will reject the request if UTC offset is provided. Time zones will be
   * calculated by Google based on departure airport.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocalScheduledDepartureDateTime() {
    return localScheduledDepartureDateTime;
  }

  /**
   * Required. The scheduled date and time when the aircraft is expected to depart the gate (not the
   * runway) Note: This field should not change too close to the departure time. For updates to
   * departure times (delays, etc), please set `localEstimatedOrActualDepartureDateTime`. This is an
   * ISO 8601 extended format date/time without an offset. Time may be specified up to millisecond
   * precision. eg: `2027-03-05T06:30:00` This should be the local date/time at the airport (not a
   * UTC time). Google will reject the request if UTC offset is provided. Time zones will be
   * calculated by Google based on departure airport.
   * @param localScheduledDepartureDateTime localScheduledDepartureDateTime or {@code null} for none
   */
  public FlightClass setLocalScheduledDepartureDateTime(java.lang.String localScheduledDepartureDateTime) {
    this.localScheduledDepartureDateTime = localScheduledDepartureDateTime;
    return this;
  }

  /**
   * Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure
   * full string is displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedIssuerName() {
    return localizedIssuerName;
  }

  /**
   * Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure
   * full string is displayed on smaller screens.
   * @param localizedIssuerName localizedIssuerName or {@code null} for none
   */
  public FlightClass setLocalizedIssuerName(LocalizedString localizedIssuerName) {
    this.localizedIssuerName = localizedIssuerName;
    return this;
  }

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * @return value or {@code null} for none
   */
  public java.util.List<LatLongPoint> getLocations() {
    return locations;
  }

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * @param locations locations or {@code null} for none
   */
  public FlightClass setLocations(java.util.List<LatLongPoint> locations) {
    this.locations = locations;
    return this;
  }

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected by the validator. These locations will trigger a
   * notification when a user enters within a Google-set radius of the point. This field replaces
   * the deprecated LatLongPoints.
   * @return value or {@code null} for none
   */
  public java.util.List<MerchantLocation> getMerchantLocations() {
    return merchantLocations;
  }

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected by the validator. These locations will trigger a
   * notification when a user enters within a Google-set radius of the point. This field replaces
   * the deprecated LatLongPoints.
   * @param merchantLocations merchantLocations or {@code null} for none
   */
  public FlightClass setMerchantLocations(java.util.List<MerchantLocation> merchantLocations) {
    this.merchantLocations = merchantLocations;
    return this;
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * @return value or {@code null} for none
   */
  public java.util.List<Message> getMessages() {
    return messages;
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * @param messages messages or {@code null} for none
   */
  public FlightClass setMessages(java.util.List<Message> messages) {
    this.messages = messages;
    return this;
  }

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * @return value or {@code null} for none
   */
  public java.lang.String getMultipleDevicesAndHoldersAllowedStatus() {
    return multipleDevicesAndHoldersAllowedStatus;
  }

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * @param multipleDevicesAndHoldersAllowedStatus multipleDevicesAndHoldersAllowedStatus or {@code null} for none
   */
  public FlightClass setMultipleDevicesAndHoldersAllowedStatus(java.lang.String multipleDevicesAndHoldersAllowedStatus) {
    this.multipleDevicesAndHoldersAllowedStatus = multipleDevicesAndHoldersAllowedStatus;
    return this;
  }

  /**
   * Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
   * will attempt to trigger a field update notification to users. These notifications will only be
   * sent to users if the field is part of an allowlist. If not specified, no notification will be
   * triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE request,
   * otherwise a notification will not be triggered.
   * @return value or {@code null} for none
   */
  public java.lang.String getNotifyPreference() {
    return notifyPreference;
  }

  /**
   * Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
   * will attempt to trigger a field update notification to users. These notifications will only be
   * sent to users if the field is part of an allowlist. If not specified, no notification will be
   * triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE request,
   * otherwise a notification will not be triggered.
   * @param notifyPreference notifyPreference or {@code null} for none
   */
  public FlightClass setNotifyPreference(java.lang.String notifyPreference) {
    this.notifyPreference = notifyPreference;
    return this;
  }

  /**
   * Required. Origin airport.
   * @return value or {@code null} for none
   */
  public AirportInfo getOrigin() {
    return origin;
  }

  /**
   * Required. Origin airport.
   * @param origin origin or {@code null} for none
   */
  public FlightClass setOrigin(AirportInfo origin) {
    this.origin = origin;
    return this;
  }

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getRedemptionIssuers() {
    return redemptionIssuers;
  }

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * @param redemptionIssuers redemptionIssuers or {@code null} for none
   */
  public FlightClass setRedemptionIssuers(java.util.List<java.lang.Long> redemptionIssuers) {
    this.redemptionIssuers = redemptionIssuers;
    return this;
  }

  /**
   * The review comments set by the platform when a class is marked `approved` or `rejected`.
   * @return value or {@code null} for none
   */
  public Review getReview() {
    return review;
  }

  /**
   * The review comments set by the platform when a class is marked `approved` or `rejected`.
   * @param review review or {@code null} for none
   */
  public FlightClass setReview(Review review) {
    this.review = review;
    return this;
  }

  /**
   * Required. The status of the class. This field can be set to `draft` or `underReview` using the
   * insert, patch, or update API calls. Once the review state is changed from `draft` it may not be
   * changed back to `draft`. You should keep this field to `draft` when the class is under
   * development. A `draft` class cannot be used to create any object. You should set this field to
   * `underReview` when you believe the class is ready for use. The platform will automatically set
   * this field to `approved` and it can be immediately used to create or migrate objects. When
   * updating an already `approved` class you should keep setting this field to `underReview`.
   * @return value or {@code null} for none
   */
  public java.lang.String getReviewStatus() {
    return reviewStatus;
  }

  /**
   * Required. The status of the class. This field can be set to `draft` or `underReview` using the
   * insert, patch, or update API calls. Once the review state is changed from `draft` it may not be
   * changed back to `draft`. You should keep this field to `draft` when the class is under
   * development. A `draft` class cannot be used to create any object. You should set this field to
   * `underReview` when you believe the class is ready for use. The platform will automatically set
   * this field to `approved` and it can be immediately used to create or migrate objects. When
   * updating an already `approved` class you should keep setting this field to `underReview`.
   * @param reviewStatus reviewStatus or {@code null} for none
   */
  public FlightClass setReviewStatus(java.lang.String reviewStatus) {
    this.reviewStatus = reviewStatus;
    return this;
  }

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * @return value or {@code null} for none
   */
  public SecurityAnimation getSecurityAnimation() {
    return securityAnimation;
  }

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * @param securityAnimation securityAnimation or {@code null} for none
   */
  public FlightClass setSecurityAnimation(SecurityAnimation securityAnimation) {
    this.securityAnimation = securityAnimation;
    return this;
  }

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * @return value or {@code null} for none
   */
  public java.util.List<TextModuleData> getTextModulesData() {
    return textModulesData;
  }

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * @param textModulesData textModulesData or {@code null} for none
   */
  public FlightClass setTextModulesData(java.util.List<TextModuleData> textModulesData) {
    this.textModulesData = textModulesData;
    return this;
  }

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * @return value or {@code null} for none
   */
  public java.util.List<ValueAddedModuleData> getValueAddedModuleData() {
    return valueAddedModuleData;
  }

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * @param valueAddedModuleData valueAddedModuleData or {@code null} for none
   */
  public FlightClass setValueAddedModuleData(java.util.List<ValueAddedModuleData> valueAddedModuleData) {
    this.valueAddedModuleData = valueAddedModuleData;
    return this;
  }

  /**
   * Deprecated
   * @return value or {@code null} for none
   */
  public java.lang.Long getVersion() {
    return version;
  }

  /**
   * Deprecated
   * @param version version or {@code null} for none
   */
  public FlightClass setVersion(java.lang.Long version) {
    this.version = version;
    return this;
  }

  /**
   * View Unlock Requirement options for the boarding pass.
   * @return value or {@code null} for none
   */
  public java.lang.String getViewUnlockRequirement() {
    return viewUnlockRequirement;
  }

  /**
   * View Unlock Requirement options for the boarding pass.
   * @param viewUnlockRequirement viewUnlockRequirement or {@code null} for none
   */
  public FlightClass setViewUnlockRequirement(java.lang.String viewUnlockRequirement) {
    this.viewUnlockRequirement = viewUnlockRequirement;
    return this;
  }

  /**
   * Deprecated.
   * @return value or {@code null} for none
   */
  public Image getWordMark() {
    return wordMark;
  }

  /**
   * Deprecated.
   * @param wordMark wordMark or {@code null} for none
   */
  public FlightClass setWordMark(Image wordMark) {
    this.wordMark = wordMark;
    return this;
  }

  @Override
  public FlightClass set(String fieldName, Object value) {
    return (FlightClass) super.set(fieldName, value);
  }

  @Override
  public FlightClass clone() {
    return (FlightClass) super.clone();
  }

}
