/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for FlightCarrier.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FlightCarrier extends com.google.api.client.json.GenericJson {

  /**
   * A logo for the airline alliance, displayed below the QR code that the passenger scans to board.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image airlineAllianceLogo;

  /**
   * A logo for the airline described by carrierIataCode and localizedAirlineName. This logo will be
   * rendered at the top of the detailed card view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image airlineLogo;

  /**
   * A localized name of the airline specified by carrierIataCode. If unset, `issuer_name` or
   * `localized_issuer_name` from `FlightClass` will be used for display purposes. eg: "Swiss Air"
   * for "LX"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString airlineName;

  /**
   * Two character IATA airline code of the marketing carrier (as opposed to operating carrier).
   * Exactly one of this or `carrierIcaoCode` needs to be provided for `carrier` and
   * `operatingCarrier`. eg: "LX" for Swiss Air
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String carrierIataCode;

  /**
   * Three character ICAO airline code of the marketing carrier (as opposed to operating carrier).
   * Exactly one of this or `carrierIataCode` needs to be provided for `carrier` and
   * `operatingCarrier`. eg: "EZY" for Easy Jet
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String carrierIcaoCode;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#flightCarrier"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The wide logo of the airline. When provided, this will be used in place of the airline logo in
   * the top left of the card view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image wideAirlineLogo;

  /**
   * A logo for the airline alliance, displayed below the QR code that the passenger scans to board.
   * @return value or {@code null} for none
   */
  public Image getAirlineAllianceLogo() {
    return airlineAllianceLogo;
  }

  /**
   * A logo for the airline alliance, displayed below the QR code that the passenger scans to board.
   * @param airlineAllianceLogo airlineAllianceLogo or {@code null} for none
   */
  public FlightCarrier setAirlineAllianceLogo(Image airlineAllianceLogo) {
    this.airlineAllianceLogo = airlineAllianceLogo;
    return this;
  }

  /**
   * A logo for the airline described by carrierIataCode and localizedAirlineName. This logo will be
   * rendered at the top of the detailed card view.
   * @return value or {@code null} for none
   */
  public Image getAirlineLogo() {
    return airlineLogo;
  }

  /**
   * A logo for the airline described by carrierIataCode and localizedAirlineName. This logo will be
   * rendered at the top of the detailed card view.
   * @param airlineLogo airlineLogo or {@code null} for none
   */
  public FlightCarrier setAirlineLogo(Image airlineLogo) {
    this.airlineLogo = airlineLogo;
    return this;
  }

  /**
   * A localized name of the airline specified by carrierIataCode. If unset, `issuer_name` or
   * `localized_issuer_name` from `FlightClass` will be used for display purposes. eg: "Swiss Air"
   * for "LX"
   * @return value or {@code null} for none
   */
  public LocalizedString getAirlineName() {
    return airlineName;
  }

  /**
   * A localized name of the airline specified by carrierIataCode. If unset, `issuer_name` or
   * `localized_issuer_name` from `FlightClass` will be used for display purposes. eg: "Swiss Air"
   * for "LX"
   * @param airlineName airlineName or {@code null} for none
   */
  public FlightCarrier setAirlineName(LocalizedString airlineName) {
    this.airlineName = airlineName;
    return this;
  }

  /**
   * Two character IATA airline code of the marketing carrier (as opposed to operating carrier).
   * Exactly one of this or `carrierIcaoCode` needs to be provided for `carrier` and
   * `operatingCarrier`. eg: "LX" for Swiss Air
   * @return value or {@code null} for none
   */
  public java.lang.String getCarrierIataCode() {
    return carrierIataCode;
  }

  /**
   * Two character IATA airline code of the marketing carrier (as opposed to operating carrier).
   * Exactly one of this or `carrierIcaoCode` needs to be provided for `carrier` and
   * `operatingCarrier`. eg: "LX" for Swiss Air
   * @param carrierIataCode carrierIataCode or {@code null} for none
   */
  public FlightCarrier setCarrierIataCode(java.lang.String carrierIataCode) {
    this.carrierIataCode = carrierIataCode;
    return this;
  }

  /**
   * Three character ICAO airline code of the marketing carrier (as opposed to operating carrier).
   * Exactly one of this or `carrierIataCode` needs to be provided for `carrier` and
   * `operatingCarrier`. eg: "EZY" for Easy Jet
   * @return value or {@code null} for none
   */
  public java.lang.String getCarrierIcaoCode() {
    return carrierIcaoCode;
  }

  /**
   * Three character ICAO airline code of the marketing carrier (as opposed to operating carrier).
   * Exactly one of this or `carrierIataCode` needs to be provided for `carrier` and
   * `operatingCarrier`. eg: "EZY" for Easy Jet
   * @param carrierIcaoCode carrierIcaoCode or {@code null} for none
   */
  public FlightCarrier setCarrierIcaoCode(java.lang.String carrierIcaoCode) {
    this.carrierIcaoCode = carrierIcaoCode;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#flightCarrier"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#flightCarrier"`.
   * @param kind kind or {@code null} for none
   */
  public FlightCarrier setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The wide logo of the airline. When provided, this will be used in place of the airline logo in
   * the top left of the card view.
   * @return value or {@code null} for none
   */
  public Image getWideAirlineLogo() {
    return wideAirlineLogo;
  }

  /**
   * The wide logo of the airline. When provided, this will be used in place of the airline logo in
   * the top left of the card view.
   * @param wideAirlineLogo wideAirlineLogo or {@code null} for none
   */
  public FlightCarrier setWideAirlineLogo(Image wideAirlineLogo) {
    this.wideAirlineLogo = wideAirlineLogo;
    return this;
  }

  @Override
  public FlightCarrier set(String fieldName, Object value) {
    return (FlightCarrier) super.set(fieldName, value);
  }

  @Override
  public FlightCarrier clone() {
    return (FlightCarrier) super.clone();
  }

}
