/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Custom field selector to use with field overrides.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FieldSelector extends com.google.api.client.json.GenericJson {

  /**
   * If more than one reference is supplied, then the first one that references a non-empty field
   * will be displayed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FieldReference> fields;

  static {
    // hack to force ProGuard to consider FieldReference used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FieldReference.class);
  }

  /**
   * If more than one reference is supplied, then the first one that references a non-empty field
   * will be displayed.
   * @return value or {@code null} for none
   */
  public java.util.List<FieldReference> getFields() {
    return fields;
  }

  /**
   * If more than one reference is supplied, then the first one that references a non-empty field
   * will be displayed.
   * @param fields fields or {@code null} for none
   */
  public FieldSelector setFields(java.util.List<FieldReference> fields) {
    this.fields = fields;
    return this;
  }

  @Override
  public FieldSelector set(String fieldName, Object value) {
    return (FieldSelector) super.set(fieldName, value);
  }

  @Override
  public FieldSelector clone() {
    return (FieldSelector) super.clone();
  }

}
