/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for EventTicketClass.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventTicketClass extends com.google.api.client.json.GenericJson {

  /**
   * Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowMultipleUsersPerObject;

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppLinkData appLinkData;

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CallbackOptions callbackOptions;

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ClassTemplateInfo classTemplateInfo;

  /**
   * The label to use for the confirmation code value
   * (`eventTicketObject.reservationInfo.confirmationCode`) on the card detail view. Each available
   * option maps to a set of localized strings, so that translations are shown to the user based on
   * their locale. Both `confirmationCodeLabel` and `customConfirmationCodeLabel` may not be set. If
   * neither is set, the label will default to "Confirmation Code", localized. If the confirmation
   * code field is unset, this label will not be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String confirmationCodeLabel;

  /**
   * Country code used to display the card's country (when the user is not in that country), as well
   * as to display localized content when content is not available in the user's locale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String countryCode;

  /**
   * A custom label to use for the confirmation code value
   * (`eventTicketObject.reservationInfo.confirmationCode`) on the card detail view. This should
   * only be used if the default "Confirmation Code" label or one of the `confirmationCodeLabel`
   * options is not sufficient. Both `confirmationCodeLabel` and `customConfirmationCodeLabel` may
   * not be set. If neither is set, the label will default to "Confirmation Code", localized. If the
   * confirmation code field is unset, this label will not be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customConfirmationCodeLabel;

  /**
   * A custom label to use for the gate value (`eventTicketObject.seatInfo.gate`) on the card detail
   * view. This should only be used if the default "Gate" label or one of the `gateLabel` options is
   * not sufficient. Both `gateLabel` and `customGateLabel` may not be set. If neither is set, the
   * label will default to "Gate", localized. If the gate field is unset, this label will not be
   * used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customGateLabel;

  /**
   * A custom label to use for the row value (`eventTicketObject.seatInfo.row`) on the card detail
   * view. This should only be used if the default "Row" label or one of the `rowLabel` options is
   * not sufficient. Both `rowLabel` and `customRowLabel` may not be set. If neither is set, the
   * label will default to "Row", localized. If the row field is unset, this label will not be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customRowLabel;

  /**
   * A custom label to use for the seat value (`eventTicketObject.seatInfo.seat`) on the card detail
   * view. This should only be used if the default "Seat" label or one of the `seatLabel` options is
   * not sufficient. Both `seatLabel` and `customSeatLabel` may not be set. If neither is set, the
   * label will default to "Seat", localized. If the seat field is unset, this label will not be
   * used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customSeatLabel;

  /**
   * A custom label to use for the section value (`eventTicketObject.seatInfo.section`) on the card
   * detail view. This should only be used if the default "Section" label or one of the
   * `sectionLabel` options is not sufficient. Both `sectionLabel` and `customSectionLabel` may not
   * be set. If neither is set, the label will default to "Section", localized. If the section field
   * is unset, this label will not be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customSectionLabel;

  /**
   * The date & time information of the event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EventDateTime dateTime;

  /**
   * Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
   * `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support
   * Smart Tap.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableSmartTap;

  /**
   * The ID of the event. This ID should be unique for every event in an account. It is used to
   * group tickets together if the user has saved multiple tickets for the same event. It can be at
   * most 64 characters. If provided, the grouping will be stable. Be wary of unintentional
   * collision to avoid grouping tickets that should not be grouped. If you use only one class per
   * event, you can simply set this to the `classId` (with or without the issuer ID portion). If not
   * provided, the platform will attempt to use other data to group tickets (potentially unstable).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eventId;

  /**
   * Required. The name of the event, such as "LA Dodgers at SF Giants".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString eventName;

  /**
   * The fine print, terms, or conditions of the ticket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString finePrint;

  /**
   * The label to use for the gate value (`eventTicketObject.seatInfo.gate`) on the card detail
   * view. Each available option maps to a set of localized strings, so that translations are shown
   * to the user based on their locale. Both `gateLabel` and `customGateLabel` may not be set. If
   * neither is set, the label will default to "Gate", localized. If the gate field is unset, this
   * label will not be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gateLabel;

  /**
   * Optional banner image displayed on the front of the card. If none is present, nothing will be
   * displayed. The image will display at 100% width.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image heroImage;

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hexBackgroundColor;

  /**
   * The URI of your application's home page. Populating the URI in this field results in the exact
   * same behavior as populating an URI in linksModuleData (when an object is rendered, a link to
   * the homepage is shown in what would usually be thought of as the linksModuleData section of the
   * object).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Uri homepageUri;

  /**
   * Required. The unique identifier for a class. This ID must be unique across all classes from an
   * issuer. This value should follow the format issuer ID. identifier where the former is issued by
   * Google and latter is chosen by you. Your unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ImageModuleData> imageModulesData;

  /**
   * Deprecated. Use textModulesData instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InfoModuleData infoModuleData;

  /**
   * Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
   * displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String issuerName;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#eventTicketClass"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Links module data. If links module data is also defined on the object, both will be displayed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LinksModuleData linksModuleData;

  /**
   * Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure
   * full string is displayed on smaller screens.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedIssuerName;

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LatLongPoint> locations;

  /**
   * The logo image of the ticket. This image is displayed in the card detail view of the app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image logo;

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MerchantLocation> merchantLocations;

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Message> messages;

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String multipleDevicesAndHoldersAllowedStatus;

  /**
   * Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
   * will attempt to trigger a field update notification to users. These notifications will only be
   * sent to users if the field is part of an allowlist. If not specified, no notification will be
   * triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE request,
   * otherwise a notification will not be triggered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String notifyPreference;

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> redemptionIssuers;

  /**
   * The review comments set by the platform when a class is marked `approved` or `rejected`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Review review;

  /**
   * Required. The status of the class. This field can be set to `draft` or `underReview` using the
   * insert, patch, or update API calls. Once the review state is changed from `draft` it may not be
   * changed back to `draft`. You should keep this field to `draft` when the class is under
   * development. A `draft` class cannot be used to create any object. You should set this field to
   * `underReview` when you believe the class is ready for use. The platform will automatically set
   * this field to `approved` and it can be immediately used to create or migrate objects. When
   * updating an already `approved` class you should keep setting this field to `underReview`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reviewStatus;

  /**
   * The label to use for the row value (`eventTicketObject.seatInfo.row`) on the card detail view.
   * Each available option maps to a set of localized strings, so that translations are shown to the
   * user based on their locale. Both `rowLabel` and `customRowLabel` may not be set. If neither is
   * set, the label will default to "Row", localized. If the row field is unset, this label will not
   * be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rowLabel;

  /**
   * The label to use for the seat value (`eventTicketObject.seatInfo.seat`) on the card detail
   * view. Each available option maps to a set of localized strings, so that translations are shown
   * to the user based on their locale. Both `seatLabel` and `customSeatLabel` may not be set. If
   * neither is set, the label will default to "Seat", localized. If the seat field is unset, this
   * label will not be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String seatLabel;

  /**
   * The label to use for the section value (`eventTicketObject.seatInfo.section`) on the card
   * detail view. Each available option maps to a set of localized strings, so that translations are
   * shown to the user based on their locale. Both `sectionLabel` and `customSectionLabel` may not
   * be set. If neither is set, the label will default to "Section", localized. If the section field
   * is unset, this label will not be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sectionLabel;

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SecurityAnimation securityAnimation;

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TextModuleData> textModulesData;

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ValueAddedModuleData> valueAddedModuleData;

  /**
   * Event venue details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EventVenue venue;

  /**
   * Deprecated
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long version;

  /**
   * View Unlock Requirement options for the event ticket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String viewUnlockRequirement;

  /**
   * The wide logo of the ticket. When provided, this will be used in place of the logo in the top
   * left of the card view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image wideLogo;

  /**
   * Deprecated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image wordMark;

  /**
   * Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowMultipleUsersPerObject() {
    return allowMultipleUsersPerObject;
  }

  /**
   * Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.
   * @param allowMultipleUsersPerObject allowMultipleUsersPerObject or {@code null} for none
   */
  public EventTicketClass setAllowMultipleUsersPerObject(java.lang.Boolean allowMultipleUsersPerObject) {
    this.allowMultipleUsersPerObject = allowMultipleUsersPerObject;
    return this;
  }

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * @return value or {@code null} for none
   */
  public AppLinkData getAppLinkData() {
    return appLinkData;
  }

  /**
   * Optional app or website link that will be displayed as a button on the front of the pass. If
   * AppLinkData is provided for the corresponding object that will be used instead.
   * @param appLinkData appLinkData or {@code null} for none
   */
  public EventTicketClass setAppLinkData(AppLinkData appLinkData) {
    this.appLinkData = appLinkData;
    return this;
  }

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * @return value or {@code null} for none
   */
  public CallbackOptions getCallbackOptions() {
    return callbackOptions;
  }

  /**
   * Callback options to be used to call the issuer back for every save/delete of an object for this
   * class by the end-user. All objects of this class are eligible for the callback.
   * @param callbackOptions callbackOptions or {@code null} for none
   */
  public EventTicketClass setCallbackOptions(CallbackOptions callbackOptions) {
    this.callbackOptions = callbackOptions;
    return this;
  }

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * @return value or {@code null} for none
   */
  public ClassTemplateInfo getClassTemplateInfo() {
    return classTemplateInfo;
  }

  /**
   * Template information about how the class should be displayed. If unset, Google will fallback to
   * a default set of fields to display.
   * @param classTemplateInfo classTemplateInfo or {@code null} for none
   */
  public EventTicketClass setClassTemplateInfo(ClassTemplateInfo classTemplateInfo) {
    this.classTemplateInfo = classTemplateInfo;
    return this;
  }

  /**
   * The label to use for the confirmation code value
   * (`eventTicketObject.reservationInfo.confirmationCode`) on the card detail view. Each available
   * option maps to a set of localized strings, so that translations are shown to the user based on
   * their locale. Both `confirmationCodeLabel` and `customConfirmationCodeLabel` may not be set. If
   * neither is set, the label will default to "Confirmation Code", localized. If the confirmation
   * code field is unset, this label will not be used.
   * @return value or {@code null} for none
   */
  public java.lang.String getConfirmationCodeLabel() {
    return confirmationCodeLabel;
  }

  /**
   * The label to use for the confirmation code value
   * (`eventTicketObject.reservationInfo.confirmationCode`) on the card detail view. Each available
   * option maps to a set of localized strings, so that translations are shown to the user based on
   * their locale. Both `confirmationCodeLabel` and `customConfirmationCodeLabel` may not be set. If
   * neither is set, the label will default to "Confirmation Code", localized. If the confirmation
   * code field is unset, this label will not be used.
   * @param confirmationCodeLabel confirmationCodeLabel or {@code null} for none
   */
  public EventTicketClass setConfirmationCodeLabel(java.lang.String confirmationCodeLabel) {
    this.confirmationCodeLabel = confirmationCodeLabel;
    return this;
  }

  /**
   * Country code used to display the card's country (when the user is not in that country), as well
   * as to display localized content when content is not available in the user's locale.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountryCode() {
    return countryCode;
  }

  /**
   * Country code used to display the card's country (when the user is not in that country), as well
   * as to display localized content when content is not available in the user's locale.
   * @param countryCode countryCode or {@code null} for none
   */
  public EventTicketClass setCountryCode(java.lang.String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * A custom label to use for the confirmation code value
   * (`eventTicketObject.reservationInfo.confirmationCode`) on the card detail view. This should
   * only be used if the default "Confirmation Code" label or one of the `confirmationCodeLabel`
   * options is not sufficient. Both `confirmationCodeLabel` and `customConfirmationCodeLabel` may
   * not be set. If neither is set, the label will default to "Confirmation Code", localized. If the
   * confirmation code field is unset, this label will not be used.
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomConfirmationCodeLabel() {
    return customConfirmationCodeLabel;
  }

  /**
   * A custom label to use for the confirmation code value
   * (`eventTicketObject.reservationInfo.confirmationCode`) on the card detail view. This should
   * only be used if the default "Confirmation Code" label or one of the `confirmationCodeLabel`
   * options is not sufficient. Both `confirmationCodeLabel` and `customConfirmationCodeLabel` may
   * not be set. If neither is set, the label will default to "Confirmation Code", localized. If the
   * confirmation code field is unset, this label will not be used.
   * @param customConfirmationCodeLabel customConfirmationCodeLabel or {@code null} for none
   */
  public EventTicketClass setCustomConfirmationCodeLabel(LocalizedString customConfirmationCodeLabel) {
    this.customConfirmationCodeLabel = customConfirmationCodeLabel;
    return this;
  }

  /**
   * A custom label to use for the gate value (`eventTicketObject.seatInfo.gate`) on the card detail
   * view. This should only be used if the default "Gate" label or one of the `gateLabel` options is
   * not sufficient. Both `gateLabel` and `customGateLabel` may not be set. If neither is set, the
   * label will default to "Gate", localized. If the gate field is unset, this label will not be
   * used.
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomGateLabel() {
    return customGateLabel;
  }

  /**
   * A custom label to use for the gate value (`eventTicketObject.seatInfo.gate`) on the card detail
   * view. This should only be used if the default "Gate" label or one of the `gateLabel` options is
   * not sufficient. Both `gateLabel` and `customGateLabel` may not be set. If neither is set, the
   * label will default to "Gate", localized. If the gate field is unset, this label will not be
   * used.
   * @param customGateLabel customGateLabel or {@code null} for none
   */
  public EventTicketClass setCustomGateLabel(LocalizedString customGateLabel) {
    this.customGateLabel = customGateLabel;
    return this;
  }

  /**
   * A custom label to use for the row value (`eventTicketObject.seatInfo.row`) on the card detail
   * view. This should only be used if the default "Row" label or one of the `rowLabel` options is
   * not sufficient. Both `rowLabel` and `customRowLabel` may not be set. If neither is set, the
   * label will default to "Row", localized. If the row field is unset, this label will not be used.
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomRowLabel() {
    return customRowLabel;
  }

  /**
   * A custom label to use for the row value (`eventTicketObject.seatInfo.row`) on the card detail
   * view. This should only be used if the default "Row" label or one of the `rowLabel` options is
   * not sufficient. Both `rowLabel` and `customRowLabel` may not be set. If neither is set, the
   * label will default to "Row", localized. If the row field is unset, this label will not be used.
   * @param customRowLabel customRowLabel or {@code null} for none
   */
  public EventTicketClass setCustomRowLabel(LocalizedString customRowLabel) {
    this.customRowLabel = customRowLabel;
    return this;
  }

  /**
   * A custom label to use for the seat value (`eventTicketObject.seatInfo.seat`) on the card detail
   * view. This should only be used if the default "Seat" label or one of the `seatLabel` options is
   * not sufficient. Both `seatLabel` and `customSeatLabel` may not be set. If neither is set, the
   * label will default to "Seat", localized. If the seat field is unset, this label will not be
   * used.
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomSeatLabel() {
    return customSeatLabel;
  }

  /**
   * A custom label to use for the seat value (`eventTicketObject.seatInfo.seat`) on the card detail
   * view. This should only be used if the default "Seat" label or one of the `seatLabel` options is
   * not sufficient. Both `seatLabel` and `customSeatLabel` may not be set. If neither is set, the
   * label will default to "Seat", localized. If the seat field is unset, this label will not be
   * used.
   * @param customSeatLabel customSeatLabel or {@code null} for none
   */
  public EventTicketClass setCustomSeatLabel(LocalizedString customSeatLabel) {
    this.customSeatLabel = customSeatLabel;
    return this;
  }

  /**
   * A custom label to use for the section value (`eventTicketObject.seatInfo.section`) on the card
   * detail view. This should only be used if the default "Section" label or one of the
   * `sectionLabel` options is not sufficient. Both `sectionLabel` and `customSectionLabel` may not
   * be set. If neither is set, the label will default to "Section", localized. If the section field
   * is unset, this label will not be used.
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomSectionLabel() {
    return customSectionLabel;
  }

  /**
   * A custom label to use for the section value (`eventTicketObject.seatInfo.section`) on the card
   * detail view. This should only be used if the default "Section" label or one of the
   * `sectionLabel` options is not sufficient. Both `sectionLabel` and `customSectionLabel` may not
   * be set. If neither is set, the label will default to "Section", localized. If the section field
   * is unset, this label will not be used.
   * @param customSectionLabel customSectionLabel or {@code null} for none
   */
  public EventTicketClass setCustomSectionLabel(LocalizedString customSectionLabel) {
    this.customSectionLabel = customSectionLabel;
    return this;
  }

  /**
   * The date & time information of the event.
   * @return value or {@code null} for none
   */
  public EventDateTime getDateTime() {
    return dateTime;
  }

  /**
   * The date & time information of the event.
   * @param dateTime dateTime or {@code null} for none
   */
  public EventTicketClass setDateTime(EventDateTime dateTime) {
    this.dateTime = dateTime;
    return this;
  }

  /**
   * Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
   * `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support
   * Smart Tap.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableSmartTap() {
    return enableSmartTap;
  }

  /**
   * Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
   * `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support
   * Smart Tap.
   * @param enableSmartTap enableSmartTap or {@code null} for none
   */
  public EventTicketClass setEnableSmartTap(java.lang.Boolean enableSmartTap) {
    this.enableSmartTap = enableSmartTap;
    return this;
  }

  /**
   * The ID of the event. This ID should be unique for every event in an account. It is used to
   * group tickets together if the user has saved multiple tickets for the same event. It can be at
   * most 64 characters. If provided, the grouping will be stable. Be wary of unintentional
   * collision to avoid grouping tickets that should not be grouped. If you use only one class per
   * event, you can simply set this to the `classId` (with or without the issuer ID portion). If not
   * provided, the platform will attempt to use other data to group tickets (potentially unstable).
   * @return value or {@code null} for none
   */
  public java.lang.String getEventId() {
    return eventId;
  }

  /**
   * The ID of the event. This ID should be unique for every event in an account. It is used to
   * group tickets together if the user has saved multiple tickets for the same event. It can be at
   * most 64 characters. If provided, the grouping will be stable. Be wary of unintentional
   * collision to avoid grouping tickets that should not be grouped. If you use only one class per
   * event, you can simply set this to the `classId` (with or without the issuer ID portion). If not
   * provided, the platform will attempt to use other data to group tickets (potentially unstable).
   * @param eventId eventId or {@code null} for none
   */
  public EventTicketClass setEventId(java.lang.String eventId) {
    this.eventId = eventId;
    return this;
  }

  /**
   * Required. The name of the event, such as "LA Dodgers at SF Giants".
   * @return value or {@code null} for none
   */
  public LocalizedString getEventName() {
    return eventName;
  }

  /**
   * Required. The name of the event, such as "LA Dodgers at SF Giants".
   * @param eventName eventName or {@code null} for none
   */
  public EventTicketClass setEventName(LocalizedString eventName) {
    this.eventName = eventName;
    return this;
  }

  /**
   * The fine print, terms, or conditions of the ticket.
   * @return value or {@code null} for none
   */
  public LocalizedString getFinePrint() {
    return finePrint;
  }

  /**
   * The fine print, terms, or conditions of the ticket.
   * @param finePrint finePrint or {@code null} for none
   */
  public EventTicketClass setFinePrint(LocalizedString finePrint) {
    this.finePrint = finePrint;
    return this;
  }

  /**
   * The label to use for the gate value (`eventTicketObject.seatInfo.gate`) on the card detail
   * view. Each available option maps to a set of localized strings, so that translations are shown
   * to the user based on their locale. Both `gateLabel` and `customGateLabel` may not be set. If
   * neither is set, the label will default to "Gate", localized. If the gate field is unset, this
   * label will not be used.
   * @return value or {@code null} for none
   */
  public java.lang.String getGateLabel() {
    return gateLabel;
  }

  /**
   * The label to use for the gate value (`eventTicketObject.seatInfo.gate`) on the card detail
   * view. Each available option maps to a set of localized strings, so that translations are shown
   * to the user based on their locale. Both `gateLabel` and `customGateLabel` may not be set. If
   * neither is set, the label will default to "Gate", localized. If the gate field is unset, this
   * label will not be used.
   * @param gateLabel gateLabel or {@code null} for none
   */
  public EventTicketClass setGateLabel(java.lang.String gateLabel) {
    this.gateLabel = gateLabel;
    return this;
  }

  /**
   * Optional banner image displayed on the front of the card. If none is present, nothing will be
   * displayed. The image will display at 100% width.
   * @return value or {@code null} for none
   */
  public Image getHeroImage() {
    return heroImage;
  }

  /**
   * Optional banner image displayed on the front of the card. If none is present, nothing will be
   * displayed. The image will display at 100% width.
   * @param heroImage heroImage or {@code null} for none
   */
  public EventTicketClass setHeroImage(Image heroImage) {
    this.heroImage = heroImage;
    return this;
  }

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * @return value or {@code null} for none
   */
  public java.lang.String getHexBackgroundColor() {
    return hexBackgroundColor;
  }

  /**
   * The background color for the card. If not set the dominant color of the hero image is used, and
   * if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
   * rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the
   * RGB triplet which is #rgb, such as `#fc0`.
   * @param hexBackgroundColor hexBackgroundColor or {@code null} for none
   */
  public EventTicketClass setHexBackgroundColor(java.lang.String hexBackgroundColor) {
    this.hexBackgroundColor = hexBackgroundColor;
    return this;
  }

  /**
   * The URI of your application's home page. Populating the URI in this field results in the exact
   * same behavior as populating an URI in linksModuleData (when an object is rendered, a link to
   * the homepage is shown in what would usually be thought of as the linksModuleData section of the
   * object).
   * @return value or {@code null} for none
   */
  public Uri getHomepageUri() {
    return homepageUri;
  }

  /**
   * The URI of your application's home page. Populating the URI in this field results in the exact
   * same behavior as populating an URI in linksModuleData (when an object is rendered, a link to
   * the homepage is shown in what would usually be thought of as the linksModuleData section of the
   * object).
   * @param homepageUri homepageUri or {@code null} for none
   */
  public EventTicketClass setHomepageUri(Uri homepageUri) {
    this.homepageUri = homepageUri;
    return this;
  }

  /**
   * Required. The unique identifier for a class. This ID must be unique across all classes from an
   * issuer. This value should follow the format issuer ID. identifier where the former is issued by
   * Google and latter is chosen by you. Your unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Required. The unique identifier for a class. This ID must be unique across all classes from an
   * issuer. This value should follow the format issuer ID. identifier where the former is issued by
   * Google and latter is chosen by you. Your unique identifier should only include alphanumeric
   * characters, '.', '_', or '-'.
   * @param id id or {@code null} for none
   */
  public EventTicketClass setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * @return value or {@code null} for none
   */
  public java.util.List<ImageModuleData> getImageModulesData() {
    return imageModulesData;
  }

  /**
   * Image module data. The maximum number of these fields displayed is 1 from object level and 1
   * for class object level.
   * @param imageModulesData imageModulesData or {@code null} for none
   */
  public EventTicketClass setImageModulesData(java.util.List<ImageModuleData> imageModulesData) {
    this.imageModulesData = imageModulesData;
    return this;
  }

  /**
   * Deprecated. Use textModulesData instead.
   * @return value or {@code null} for none
   */
  public InfoModuleData getInfoModuleData() {
    return infoModuleData;
  }

  /**
   * Deprecated. Use textModulesData instead.
   * @param infoModuleData infoModuleData or {@code null} for none
   */
  public EventTicketClass setInfoModuleData(InfoModuleData infoModuleData) {
    this.infoModuleData = infoModuleData;
    return this;
  }

  /**
   * Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
   * displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public java.lang.String getIssuerName() {
    return issuerName;
  }

  /**
   * Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
   * displayed on smaller screens.
   * @param issuerName issuerName or {@code null} for none
   */
  public EventTicketClass setIssuerName(java.lang.String issuerName) {
    this.issuerName = issuerName;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#eventTicketClass"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#eventTicketClass"`.
   * @param kind kind or {@code null} for none
   */
  public EventTicketClass setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Links module data. If links module data is also defined on the object, both will be displayed.
   * @return value or {@code null} for none
   */
  public LinksModuleData getLinksModuleData() {
    return linksModuleData;
  }

  /**
   * Links module data. If links module data is also defined on the object, both will be displayed.
   * @param linksModuleData linksModuleData or {@code null} for none
   */
  public EventTicketClass setLinksModuleData(LinksModuleData linksModuleData) {
    this.linksModuleData = linksModuleData;
    return this;
  }

  /**
   * Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure
   * full string is displayed on smaller screens.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedIssuerName() {
    return localizedIssuerName;
  }

  /**
   * Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure
   * full string is displayed on smaller screens.
   * @param localizedIssuerName localizedIssuerName or {@code null} for none
   */
  public EventTicketClass setLocalizedIssuerName(LocalizedString localizedIssuerName) {
    this.localizedIssuerName = localizedIssuerName;
    return this;
  }

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * @return value or {@code null} for none
   */
  public java.util.List<LatLongPoint> getLocations() {
    return locations;
  }

  /**
   * Note: This field is currently not supported to trigger geo notifications.
   * @param locations locations or {@code null} for none
   */
  public EventTicketClass setLocations(java.util.List<LatLongPoint> locations) {
    this.locations = locations;
    return this;
  }

  /**
   * The logo image of the ticket. This image is displayed in the card detail view of the app.
   * @return value or {@code null} for none
   */
  public Image getLogo() {
    return logo;
  }

  /**
   * The logo image of the ticket. This image is displayed in the card detail view of the app.
   * @param logo logo or {@code null} for none
   */
  public EventTicketClass setLogo(Image logo) {
    this.logo = logo;
    return this;
  }

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * @return value or {@code null} for none
   */
  public java.util.List<MerchantLocation> getMerchantLocations() {
    return merchantLocations;
  }

  /**
   * Merchant locations. There is a maximum of ten on the class. Any additional MerchantLocations
   * added beyond the 10 will be rejected. These locations will trigger a notification when a user
   * enters within a Google-set radius of the point. This field replaces the deprecated
   * LatLongPoints.
   * @param merchantLocations merchantLocations or {@code null} for none
   */
  public EventTicketClass setMerchantLocations(java.util.List<MerchantLocation> merchantLocations) {
    this.merchantLocations = merchantLocations;
    return this;
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * @return value or {@code null} for none
   */
  public java.util.List<Message> getMessages() {
    return messages;
  }

  /**
   * An array of messages displayed in the app. All users of this object will receive its associated
   * messages. The maximum number of these fields is 10.
   * @param messages messages or {@code null} for none
   */
  public EventTicketClass setMessages(java.util.List<Message> messages) {
    this.messages = messages;
    return this;
  }

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * @return value or {@code null} for none
   */
  public java.lang.String getMultipleDevicesAndHoldersAllowedStatus() {
    return multipleDevicesAndHoldersAllowedStatus;
  }

  /**
   * Identifies whether multiple users and devices will save the same object referencing this class.
   * @param multipleDevicesAndHoldersAllowedStatus multipleDevicesAndHoldersAllowedStatus or {@code null} for none
   */
  public EventTicketClass setMultipleDevicesAndHoldersAllowedStatus(java.lang.String multipleDevicesAndHoldersAllowedStatus) {
    this.multipleDevicesAndHoldersAllowedStatus = multipleDevicesAndHoldersAllowedStatus;
    return this;
  }

  /**
   * Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
   * will attempt to trigger a field update notification to users. These notifications will only be
   * sent to users if the field is part of an allowlist. If not specified, no notification will be
   * triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE request,
   * otherwise a notification will not be triggered.
   * @return value or {@code null} for none
   */
  public java.lang.String getNotifyPreference() {
    return notifyPreference;
  }

  /**
   * Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
   * will attempt to trigger a field update notification to users. These notifications will only be
   * sent to users if the field is part of an allowlist. If not specified, no notification will be
   * triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE request,
   * otherwise a notification will not be triggered.
   * @param notifyPreference notifyPreference or {@code null} for none
   */
  public EventTicketClass setNotifyPreference(java.lang.String notifyPreference) {
    this.notifyPreference = notifyPreference;
    return this;
  }

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getRedemptionIssuers() {
    return redemptionIssuers;
  }

  /**
   * Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
   * identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
   * configured. The `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be
   * set up correctly in order for a pass to support Smart Tap.
   * @param redemptionIssuers redemptionIssuers or {@code null} for none
   */
  public EventTicketClass setRedemptionIssuers(java.util.List<java.lang.Long> redemptionIssuers) {
    this.redemptionIssuers = redemptionIssuers;
    return this;
  }

  /**
   * The review comments set by the platform when a class is marked `approved` or `rejected`.
   * @return value or {@code null} for none
   */
  public Review getReview() {
    return review;
  }

  /**
   * The review comments set by the platform when a class is marked `approved` or `rejected`.
   * @param review review or {@code null} for none
   */
  public EventTicketClass setReview(Review review) {
    this.review = review;
    return this;
  }

  /**
   * Required. The status of the class. This field can be set to `draft` or `underReview` using the
   * insert, patch, or update API calls. Once the review state is changed from `draft` it may not be
   * changed back to `draft`. You should keep this field to `draft` when the class is under
   * development. A `draft` class cannot be used to create any object. You should set this field to
   * `underReview` when you believe the class is ready for use. The platform will automatically set
   * this field to `approved` and it can be immediately used to create or migrate objects. When
   * updating an already `approved` class you should keep setting this field to `underReview`.
   * @return value or {@code null} for none
   */
  public java.lang.String getReviewStatus() {
    return reviewStatus;
  }

  /**
   * Required. The status of the class. This field can be set to `draft` or `underReview` using the
   * insert, patch, or update API calls. Once the review state is changed from `draft` it may not be
   * changed back to `draft`. You should keep this field to `draft` when the class is under
   * development. A `draft` class cannot be used to create any object. You should set this field to
   * `underReview` when you believe the class is ready for use. The platform will automatically set
   * this field to `approved` and it can be immediately used to create or migrate objects. When
   * updating an already `approved` class you should keep setting this field to `underReview`.
   * @param reviewStatus reviewStatus or {@code null} for none
   */
  public EventTicketClass setReviewStatus(java.lang.String reviewStatus) {
    this.reviewStatus = reviewStatus;
    return this;
  }

  /**
   * The label to use for the row value (`eventTicketObject.seatInfo.row`) on the card detail view.
   * Each available option maps to a set of localized strings, so that translations are shown to the
   * user based on their locale. Both `rowLabel` and `customRowLabel` may not be set. If neither is
   * set, the label will default to "Row", localized. If the row field is unset, this label will not
   * be used.
   * @return value or {@code null} for none
   */
  public java.lang.String getRowLabel() {
    return rowLabel;
  }

  /**
   * The label to use for the row value (`eventTicketObject.seatInfo.row`) on the card detail view.
   * Each available option maps to a set of localized strings, so that translations are shown to the
   * user based on their locale. Both `rowLabel` and `customRowLabel` may not be set. If neither is
   * set, the label will default to "Row", localized. If the row field is unset, this label will not
   * be used.
   * @param rowLabel rowLabel or {@code null} for none
   */
  public EventTicketClass setRowLabel(java.lang.String rowLabel) {
    this.rowLabel = rowLabel;
    return this;
  }

  /**
   * The label to use for the seat value (`eventTicketObject.seatInfo.seat`) on the card detail
   * view. Each available option maps to a set of localized strings, so that translations are shown
   * to the user based on their locale. Both `seatLabel` and `customSeatLabel` may not be set. If
   * neither is set, the label will default to "Seat", localized. If the seat field is unset, this
   * label will not be used.
   * @return value or {@code null} for none
   */
  public java.lang.String getSeatLabel() {
    return seatLabel;
  }

  /**
   * The label to use for the seat value (`eventTicketObject.seatInfo.seat`) on the card detail
   * view. Each available option maps to a set of localized strings, so that translations are shown
   * to the user based on their locale. Both `seatLabel` and `customSeatLabel` may not be set. If
   * neither is set, the label will default to "Seat", localized. If the seat field is unset, this
   * label will not be used.
   * @param seatLabel seatLabel or {@code null} for none
   */
  public EventTicketClass setSeatLabel(java.lang.String seatLabel) {
    this.seatLabel = seatLabel;
    return this;
  }

  /**
   * The label to use for the section value (`eventTicketObject.seatInfo.section`) on the card
   * detail view. Each available option maps to a set of localized strings, so that translations are
   * shown to the user based on their locale. Both `sectionLabel` and `customSectionLabel` may not
   * be set. If neither is set, the label will default to "Section", localized. If the section field
   * is unset, this label will not be used.
   * @return value or {@code null} for none
   */
  public java.lang.String getSectionLabel() {
    return sectionLabel;
  }

  /**
   * The label to use for the section value (`eventTicketObject.seatInfo.section`) on the card
   * detail view. Each available option maps to a set of localized strings, so that translations are
   * shown to the user based on their locale. Both `sectionLabel` and `customSectionLabel` may not
   * be set. If neither is set, the label will default to "Section", localized. If the section field
   * is unset, this label will not be used.
   * @param sectionLabel sectionLabel or {@code null} for none
   */
  public EventTicketClass setSectionLabel(java.lang.String sectionLabel) {
    this.sectionLabel = sectionLabel;
    return this;
  }

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * @return value or {@code null} for none
   */
  public SecurityAnimation getSecurityAnimation() {
    return securityAnimation;
  }

  /**
   * Optional information about the security animation. If this is set a security animation will be
   * rendered on pass details.
   * @param securityAnimation securityAnimation or {@code null} for none
   */
  public EventTicketClass setSecurityAnimation(SecurityAnimation securityAnimation) {
    this.securityAnimation = securityAnimation;
    return this;
  }

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * @return value or {@code null} for none
   */
  public java.util.List<TextModuleData> getTextModulesData() {
    return textModulesData;
  }

  /**
   * Text module data. If text module data is also defined on the class, both will be displayed. The
   * maximum number of these fields displayed is 10 from the object and 10 from the class.
   * @param textModulesData textModulesData or {@code null} for none
   */
  public EventTicketClass setTextModulesData(java.util.List<TextModuleData> textModulesData) {
    this.textModulesData = textModulesData;
    return this;
  }

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * @return value or {@code null} for none
   */
  public java.util.List<ValueAddedModuleData> getValueAddedModuleData() {
    return valueAddedModuleData;
  }

  /**
   * Optional value added module data. Maximum of ten on the class. For a pass only ten will be
   * displayed, prioritizing those from the object.
   * @param valueAddedModuleData valueAddedModuleData or {@code null} for none
   */
  public EventTicketClass setValueAddedModuleData(java.util.List<ValueAddedModuleData> valueAddedModuleData) {
    this.valueAddedModuleData = valueAddedModuleData;
    return this;
  }

  /**
   * Event venue details.
   * @return value or {@code null} for none
   */
  public EventVenue getVenue() {
    return venue;
  }

  /**
   * Event venue details.
   * @param venue venue or {@code null} for none
   */
  public EventTicketClass setVenue(EventVenue venue) {
    this.venue = venue;
    return this;
  }

  /**
   * Deprecated
   * @return value or {@code null} for none
   */
  public java.lang.Long getVersion() {
    return version;
  }

  /**
   * Deprecated
   * @param version version or {@code null} for none
   */
  public EventTicketClass setVersion(java.lang.Long version) {
    this.version = version;
    return this;
  }

  /**
   * View Unlock Requirement options for the event ticket.
   * @return value or {@code null} for none
   */
  public java.lang.String getViewUnlockRequirement() {
    return viewUnlockRequirement;
  }

  /**
   * View Unlock Requirement options for the event ticket.
   * @param viewUnlockRequirement viewUnlockRequirement or {@code null} for none
   */
  public EventTicketClass setViewUnlockRequirement(java.lang.String viewUnlockRequirement) {
    this.viewUnlockRequirement = viewUnlockRequirement;
    return this;
  }

  /**
   * The wide logo of the ticket. When provided, this will be used in place of the logo in the top
   * left of the card view.
   * @return value or {@code null} for none
   */
  public Image getWideLogo() {
    return wideLogo;
  }

  /**
   * The wide logo of the ticket. When provided, this will be used in place of the logo in the top
   * left of the card view.
   * @param wideLogo wideLogo or {@code null} for none
   */
  public EventTicketClass setWideLogo(Image wideLogo) {
    this.wideLogo = wideLogo;
    return this;
  }

  /**
   * Deprecated.
   * @return value or {@code null} for none
   */
  public Image getWordMark() {
    return wordMark;
  }

  /**
   * Deprecated.
   * @param wordMark wordMark or {@code null} for none
   */
  public EventTicketClass setWordMark(Image wordMark) {
    this.wordMark = wordMark;
    return this;
  }

  @Override
  public EventTicketClass set(String fieldName, Object value) {
    return (EventTicketClass) super.set(fieldName, value);
  }

  @Override
  public EventTicketClass clone() {
    return (EventTicketClass) super.clone();
  }

}
