/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for EventSeat.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventSeat extends com.google.api.client.json.GenericJson {

  /**
   * The gate the ticket holder should enter to get to their seat, such as "A" or "West". This field
   * is localizable so you may translate words or use different alphabets for the characters in an
   * identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString gate;

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#eventSeat"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The row of the seat, such as "1", E", "BB", or "A5". This field is localizable so you may
   * translate words or use different alphabets for the characters in an identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString row;

  /**
   * The seat number, such as "1", "2", "3", or any other seat identifier. This field is localizable
   * so you may translate words or use different alphabets for the characters in an identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString seat;

  /**
   * The section of the seat, such as "121". This field is localizable so you may translate words or
   * use different alphabets for the characters in an identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString section;

  /**
   * The gate the ticket holder should enter to get to their seat, such as "A" or "West". This field
   * is localizable so you may translate words or use different alphabets for the characters in an
   * identifier.
   * @return value or {@code null} for none
   */
  public LocalizedString getGate() {
    return gate;
  }

  /**
   * The gate the ticket holder should enter to get to their seat, such as "A" or "West". This field
   * is localizable so you may translate words or use different alphabets for the characters in an
   * identifier.
   * @param gate gate or {@code null} for none
   */
  public EventSeat setGate(LocalizedString gate) {
    this.gate = gate;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#eventSeat"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#eventSeat"`.
   * @param kind kind or {@code null} for none
   */
  public EventSeat setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The row of the seat, such as "1", E", "BB", or "A5". This field is localizable so you may
   * translate words or use different alphabets for the characters in an identifier.
   * @return value or {@code null} for none
   */
  public LocalizedString getRow() {
    return row;
  }

  /**
   * The row of the seat, such as "1", E", "BB", or "A5". This field is localizable so you may
   * translate words or use different alphabets for the characters in an identifier.
   * @param row row or {@code null} for none
   */
  public EventSeat setRow(LocalizedString row) {
    this.row = row;
    return this;
  }

  /**
   * The seat number, such as "1", "2", "3", or any other seat identifier. This field is localizable
   * so you may translate words or use different alphabets for the characters in an identifier.
   * @return value or {@code null} for none
   */
  public LocalizedString getSeat() {
    return seat;
  }

  /**
   * The seat number, such as "1", "2", "3", or any other seat identifier. This field is localizable
   * so you may translate words or use different alphabets for the characters in an identifier.
   * @param seat seat or {@code null} for none
   */
  public EventSeat setSeat(LocalizedString seat) {
    this.seat = seat;
    return this;
  }

  /**
   * The section of the seat, such as "121". This field is localizable so you may translate words or
   * use different alphabets for the characters in an identifier.
   * @return value or {@code null} for none
   */
  public LocalizedString getSection() {
    return section;
  }

  /**
   * The section of the seat, such as "121". This field is localizable so you may translate words or
   * use different alphabets for the characters in an identifier.
   * @param section section or {@code null} for none
   */
  public EventSeat setSection(LocalizedString section) {
    this.section = section;
    return this;
  }

  @Override
  public EventSeat set(String fieldName, Object value) {
    return (EventSeat) super.set(fieldName, value);
  }

  @Override
  public EventSeat clone() {
    return (EventSeat) super.clone();
  }

}
