/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for EventDateTime.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventDateTime extends com.google.api.client.json.GenericJson {

  /**
   * A custom label to use for the doors open value (`doorsOpen`) on the card detail view. This
   * should only be used if the default "Doors Open" label or one of the `doorsOpenLabel` options is
   * not sufficient. Both `doorsOpenLabel` and `customDoorsOpenLabel` may not be set. If neither is
   * set, the label will default to "Doors Open", localized. If the doors open field is unset, this
   * label will not be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString customDoorsOpenLabel;

  /**
   * The date/time when the doors open at the venue. This is an ISO 8601 extended format date/time,
   * with or without an offset. Time may be specified up to nanosecond precision. Offsets may be
   * specified with seconds precision (even though offset seconds is not part of ISO 8601). For
   * example: `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of
   * April 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds
   * after the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and
   * 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. The portion
   * of the date/time without the offset is considered the "local date/time". This should be the
   * local date/time at the venue. For example, if the event occurs at the 20th hour of June 5th,
   * 2018 at the venue, the local date/time portion should be `2018-06-05T20:00:00`. If the local
   * date/time at the venue is 4 hours before UTC, an offset of `-04:00` may be appended. Without
   * offset information, some rich features may not be available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String doorsOpen;

  /**
   * The label to use for the doors open value (`doorsOpen`) on the card detail view. Each available
   * option maps to a set of localized strings, so that translations are shown to the user based on
   * their locale. Both `doorsOpenLabel` and `customDoorsOpenLabel` may not be set. If neither is
   * set, the label will default to "Doors Open", localized. If the doors open field is unset, this
   * label will not be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String doorsOpenLabel;

  /**
   * The date/time when the event ends. If the event spans multiple days, it should be the end
   * date/time on the last day. This is an ISO 8601 extended format date/time, with or without an
   * offset. Time may be specified up to nanosecond precision. Offsets may be specified with seconds
   * precision (even though offset seconds is not part of ISO 8601). For example:
   * `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of April
   * 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after
   * the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and
   * 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. The portion
   * of the date/time without the offset is considered the "local date/time". This should be the
   * local date/time at the venue. For example, if the event occurs at the 20th hour of June 5th,
   * 2018 at the venue, the local date/time portion should be `2018-06-05T20:00:00`. If the local
   * date/time at the venue is 4 hours before UTC, an offset of `-04:00` may be appended. Without
   * offset information, some rich features may not be available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String end;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#eventDateTime"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The date/time when the event starts. If the event spans multiple days, it should be the start
   * date/time on the first day. This is an ISO 8601 extended format date/time, with or without an
   * offset. Time may be specified up to nanosecond precision. Offsets may be specified with seconds
   * precision (even though offset seconds is not part of ISO 8601). For example:
   * `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of April
   * 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after
   * the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and
   * 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. The portion
   * of the date/time without the offset is considered the "local date/time". This should be the
   * local date/time at the venue. For example, if the event occurs at the 20th hour of June 5th,
   * 2018 at the venue, the local date/time portion should be `2018-06-05T20:00:00`. If the local
   * date/time at the venue is 4 hours before UTC, an offset of `-04:00` may be appended. Without
   * offset information, some rich features may not be available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String start;

  /**
   * A custom label to use for the doors open value (`doorsOpen`) on the card detail view. This
   * should only be used if the default "Doors Open" label or one of the `doorsOpenLabel` options is
   * not sufficient. Both `doorsOpenLabel` and `customDoorsOpenLabel` may not be set. If neither is
   * set, the label will default to "Doors Open", localized. If the doors open field is unset, this
   * label will not be used.
   * @return value or {@code null} for none
   */
  public LocalizedString getCustomDoorsOpenLabel() {
    return customDoorsOpenLabel;
  }

  /**
   * A custom label to use for the doors open value (`doorsOpen`) on the card detail view. This
   * should only be used if the default "Doors Open" label or one of the `doorsOpenLabel` options is
   * not sufficient. Both `doorsOpenLabel` and `customDoorsOpenLabel` may not be set. If neither is
   * set, the label will default to "Doors Open", localized. If the doors open field is unset, this
   * label will not be used.
   * @param customDoorsOpenLabel customDoorsOpenLabel or {@code null} for none
   */
  public EventDateTime setCustomDoorsOpenLabel(LocalizedString customDoorsOpenLabel) {
    this.customDoorsOpenLabel = customDoorsOpenLabel;
    return this;
  }

  /**
   * The date/time when the doors open at the venue. This is an ISO 8601 extended format date/time,
   * with or without an offset. Time may be specified up to nanosecond precision. Offsets may be
   * specified with seconds precision (even though offset seconds is not part of ISO 8601). For
   * example: `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of
   * April 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds
   * after the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and
   * 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. The portion
   * of the date/time without the offset is considered the "local date/time". This should be the
   * local date/time at the venue. For example, if the event occurs at the 20th hour of June 5th,
   * 2018 at the venue, the local date/time portion should be `2018-06-05T20:00:00`. If the local
   * date/time at the venue is 4 hours before UTC, an offset of `-04:00` may be appended. Without
   * offset information, some rich features may not be available.
   * @return value or {@code null} for none
   */
  public java.lang.String getDoorsOpen() {
    return doorsOpen;
  }

  /**
   * The date/time when the doors open at the venue. This is an ISO 8601 extended format date/time,
   * with or without an offset. Time may be specified up to nanosecond precision. Offsets may be
   * specified with seconds precision (even though offset seconds is not part of ISO 8601). For
   * example: `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of
   * April 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds
   * after the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and
   * 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. The portion
   * of the date/time without the offset is considered the "local date/time". This should be the
   * local date/time at the venue. For example, if the event occurs at the 20th hour of June 5th,
   * 2018 at the venue, the local date/time portion should be `2018-06-05T20:00:00`. If the local
   * date/time at the venue is 4 hours before UTC, an offset of `-04:00` may be appended. Without
   * offset information, some rich features may not be available.
   * @param doorsOpen doorsOpen or {@code null} for none
   */
  public EventDateTime setDoorsOpen(java.lang.String doorsOpen) {
    this.doorsOpen = doorsOpen;
    return this;
  }

  /**
   * The label to use for the doors open value (`doorsOpen`) on the card detail view. Each available
   * option maps to a set of localized strings, so that translations are shown to the user based on
   * their locale. Both `doorsOpenLabel` and `customDoorsOpenLabel` may not be set. If neither is
   * set, the label will default to "Doors Open", localized. If the doors open field is unset, this
   * label will not be used.
   * @return value or {@code null} for none
   */
  public java.lang.String getDoorsOpenLabel() {
    return doorsOpenLabel;
  }

  /**
   * The label to use for the doors open value (`doorsOpen`) on the card detail view. Each available
   * option maps to a set of localized strings, so that translations are shown to the user based on
   * their locale. Both `doorsOpenLabel` and `customDoorsOpenLabel` may not be set. If neither is
   * set, the label will default to "Doors Open", localized. If the doors open field is unset, this
   * label will not be used.
   * @param doorsOpenLabel doorsOpenLabel or {@code null} for none
   */
  public EventDateTime setDoorsOpenLabel(java.lang.String doorsOpenLabel) {
    this.doorsOpenLabel = doorsOpenLabel;
    return this;
  }

  /**
   * The date/time when the event ends. If the event spans multiple days, it should be the end
   * date/time on the last day. This is an ISO 8601 extended format date/time, with or without an
   * offset. Time may be specified up to nanosecond precision. Offsets may be specified with seconds
   * precision (even though offset seconds is not part of ISO 8601). For example:
   * `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of April
   * 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after
   * the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and
   * 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. The portion
   * of the date/time without the offset is considered the "local date/time". This should be the
   * local date/time at the venue. For example, if the event occurs at the 20th hour of June 5th,
   * 2018 at the venue, the local date/time portion should be `2018-06-05T20:00:00`. If the local
   * date/time at the venue is 4 hours before UTC, an offset of `-04:00` may be appended. Without
   * offset information, some rich features may not be available.
   * @return value or {@code null} for none
   */
  public java.lang.String getEnd() {
    return end;
  }

  /**
   * The date/time when the event ends. If the event spans multiple days, it should be the end
   * date/time on the last day. This is an ISO 8601 extended format date/time, with or without an
   * offset. Time may be specified up to nanosecond precision. Offsets may be specified with seconds
   * precision (even though offset seconds is not part of ISO 8601). For example:
   * `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of April
   * 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after
   * the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and
   * 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. The portion
   * of the date/time without the offset is considered the "local date/time". This should be the
   * local date/time at the venue. For example, if the event occurs at the 20th hour of June 5th,
   * 2018 at the venue, the local date/time portion should be `2018-06-05T20:00:00`. If the local
   * date/time at the venue is 4 hours before UTC, an offset of `-04:00` may be appended. Without
   * offset information, some rich features may not be available.
   * @param end end or {@code null} for none
   */
  public EventDateTime setEnd(java.lang.String end) {
    this.end = end;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#eventDateTime"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#eventDateTime"`.
   * @param kind kind or {@code null} for none
   */
  public EventDateTime setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The date/time when the event starts. If the event spans multiple days, it should be the start
   * date/time on the first day. This is an ISO 8601 extended format date/time, with or without an
   * offset. Time may be specified up to nanosecond precision. Offsets may be specified with seconds
   * precision (even though offset seconds is not part of ISO 8601). For example:
   * `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of April
   * 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after
   * the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and
   * 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. The portion
   * of the date/time without the offset is considered the "local date/time". This should be the
   * local date/time at the venue. For example, if the event occurs at the 20th hour of June 5th,
   * 2018 at the venue, the local date/time portion should be `2018-06-05T20:00:00`. If the local
   * date/time at the venue is 4 hours before UTC, an offset of `-04:00` may be appended. Without
   * offset information, some rich features may not be available.
   * @return value or {@code null} for none
   */
  public java.lang.String getStart() {
    return start;
  }

  /**
   * The date/time when the event starts. If the event spans multiple days, it should be the start
   * date/time on the first day. This is an ISO 8601 extended format date/time, with or without an
   * offset. Time may be specified up to nanosecond precision. Offsets may be specified with seconds
   * precision (even though offset seconds is not part of ISO 8601). For example:
   * `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of April
   * 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after
   * the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the above
   * example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
   * (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer
   * Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and
   * 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. The portion
   * of the date/time without the offset is considered the "local date/time". This should be the
   * local date/time at the venue. For example, if the event occurs at the 20th hour of June 5th,
   * 2018 at the venue, the local date/time portion should be `2018-06-05T20:00:00`. If the local
   * date/time at the venue is 4 hours before UTC, an offset of `-04:00` may be appended. Without
   * offset information, some rich features may not be available.
   * @param start start or {@code null} for none
   */
  public EventDateTime setStart(java.lang.String start) {
    this.start = start;
    return this;
  }

  @Override
  public EventDateTime set(String fieldName, Object value) {
    return (EventDateTime) super.set(fieldName, value);
  }

  @Override
  public EventDateTime clone() {
    return (EventDateTime) super.clone();
  }

}
