/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Information about how a class may be discovered and instantiated from within the Google Wallet
 * app. This is done by searching for a loyalty or gift card program and scanning or manually
 * entering.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DiscoverableProgram extends com.google.api.client.json.GenericJson {

  /**
   * Information about the ability to signin and add a valuable for this program through a merchant
   * site. Used when MERCHANT_HOSTED_SIGNIN is enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DiscoverableProgramMerchantSigninInfo merchantSigninInfo;

  /**
   * Information about the ability to signup and add a valuable for this program through a merchant
   * site. Used when MERCHANT_HOSTED_SIGNUP is enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DiscoverableProgramMerchantSignupInfo merchantSignupInfo;

  /**
   * Visibility state of the discoverable program.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Information about the ability to signin and add a valuable for this program through a merchant
   * site. Used when MERCHANT_HOSTED_SIGNIN is enabled.
   * @return value or {@code null} for none
   */
  public DiscoverableProgramMerchantSigninInfo getMerchantSigninInfo() {
    return merchantSigninInfo;
  }

  /**
   * Information about the ability to signin and add a valuable for this program through a merchant
   * site. Used when MERCHANT_HOSTED_SIGNIN is enabled.
   * @param merchantSigninInfo merchantSigninInfo or {@code null} for none
   */
  public DiscoverableProgram setMerchantSigninInfo(DiscoverableProgramMerchantSigninInfo merchantSigninInfo) {
    this.merchantSigninInfo = merchantSigninInfo;
    return this;
  }

  /**
   * Information about the ability to signup and add a valuable for this program through a merchant
   * site. Used when MERCHANT_HOSTED_SIGNUP is enabled.
   * @return value or {@code null} for none
   */
  public DiscoverableProgramMerchantSignupInfo getMerchantSignupInfo() {
    return merchantSignupInfo;
  }

  /**
   * Information about the ability to signup and add a valuable for this program through a merchant
   * site. Used when MERCHANT_HOSTED_SIGNUP is enabled.
   * @param merchantSignupInfo merchantSignupInfo or {@code null} for none
   */
  public DiscoverableProgram setMerchantSignupInfo(DiscoverableProgramMerchantSignupInfo merchantSignupInfo) {
    this.merchantSignupInfo = merchantSignupInfo;
    return this;
  }

  /**
   * Visibility state of the discoverable program.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Visibility state of the discoverable program.
   * @param state state or {@code null} for none
   */
  public DiscoverableProgram setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public DiscoverableProgram set(String fieldName, Object value) {
    return (DiscoverableProgram) super.set(fieldName, value);
  }

  @Override
  public DiscoverableProgram clone() {
    return (DiscoverableProgram) super.clone();
  }

}
