/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for ClassTemplateInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ClassTemplateInfo extends com.google.api.client.json.GenericJson {

  /**
   * Specifies extra information to be displayed above and below the barcode.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CardBarcodeSectionDetails cardBarcodeSectionDetails;

  /**
   * Override for the card view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CardTemplateOverride cardTemplateOverride;

  /**
   * Override for the details view (beneath the card view).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DetailsTemplateOverride detailsTemplateOverride;

  /**
   * Override for the passes list view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ListTemplateOverride listTemplateOverride;

  /**
   * Specifies extra information to be displayed above and below the barcode.
   * @return value or {@code null} for none
   */
  public CardBarcodeSectionDetails getCardBarcodeSectionDetails() {
    return cardBarcodeSectionDetails;
  }

  /**
   * Specifies extra information to be displayed above and below the barcode.
   * @param cardBarcodeSectionDetails cardBarcodeSectionDetails or {@code null} for none
   */
  public ClassTemplateInfo setCardBarcodeSectionDetails(CardBarcodeSectionDetails cardBarcodeSectionDetails) {
    this.cardBarcodeSectionDetails = cardBarcodeSectionDetails;
    return this;
  }

  /**
   * Override for the card view.
   * @return value or {@code null} for none
   */
  public CardTemplateOverride getCardTemplateOverride() {
    return cardTemplateOverride;
  }

  /**
   * Override for the card view.
   * @param cardTemplateOverride cardTemplateOverride or {@code null} for none
   */
  public ClassTemplateInfo setCardTemplateOverride(CardTemplateOverride cardTemplateOverride) {
    this.cardTemplateOverride = cardTemplateOverride;
    return this;
  }

  /**
   * Override for the details view (beneath the card view).
   * @return value or {@code null} for none
   */
  public DetailsTemplateOverride getDetailsTemplateOverride() {
    return detailsTemplateOverride;
  }

  /**
   * Override for the details view (beneath the card view).
   * @param detailsTemplateOverride detailsTemplateOverride or {@code null} for none
   */
  public ClassTemplateInfo setDetailsTemplateOverride(DetailsTemplateOverride detailsTemplateOverride) {
    this.detailsTemplateOverride = detailsTemplateOverride;
    return this;
  }

  /**
   * Override for the passes list view.
   * @return value or {@code null} for none
   */
  public ListTemplateOverride getListTemplateOverride() {
    return listTemplateOverride;
  }

  /**
   * Override for the passes list view.
   * @param listTemplateOverride listTemplateOverride or {@code null} for none
   */
  public ClassTemplateInfo setListTemplateOverride(ListTemplateOverride listTemplateOverride) {
    this.listTemplateOverride = listTemplateOverride;
    return this;
  }

  @Override
  public ClassTemplateInfo set(String fieldName, Object value) {
    return (ClassTemplateInfo) super.set(fieldName, value);
  }

  @Override
  public ClassTemplateInfo clone() {
    return (ClassTemplateInfo) super.clone();
  }

}
