/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for CardRowThreeItems.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CardRowThreeItems extends com.google.api.client.json.GenericJson {

  /**
   * The item to be displayed at the end of the row. This item will be aligned to the right.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TemplateItem endItem;

  /**
   * The item to be displayed in the middle of the row. This item will be centered between the start
   * and end items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TemplateItem middleItem;

  /**
   * The item to be displayed at the start of the row. This item will be aligned to the left.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TemplateItem startItem;

  /**
   * The item to be displayed at the end of the row. This item will be aligned to the right.
   * @return value or {@code null} for none
   */
  public TemplateItem getEndItem() {
    return endItem;
  }

  /**
   * The item to be displayed at the end of the row. This item will be aligned to the right.
   * @param endItem endItem or {@code null} for none
   */
  public CardRowThreeItems setEndItem(TemplateItem endItem) {
    this.endItem = endItem;
    return this;
  }

  /**
   * The item to be displayed in the middle of the row. This item will be centered between the start
   * and end items.
   * @return value or {@code null} for none
   */
  public TemplateItem getMiddleItem() {
    return middleItem;
  }

  /**
   * The item to be displayed in the middle of the row. This item will be centered between the start
   * and end items.
   * @param middleItem middleItem or {@code null} for none
   */
  public CardRowThreeItems setMiddleItem(TemplateItem middleItem) {
    this.middleItem = middleItem;
    return this;
  }

  /**
   * The item to be displayed at the start of the row. This item will be aligned to the left.
   * @return value or {@code null} for none
   */
  public TemplateItem getStartItem() {
    return startItem;
  }

  /**
   * The item to be displayed at the start of the row. This item will be aligned to the left.
   * @param startItem startItem or {@code null} for none
   */
  public CardRowThreeItems setStartItem(TemplateItem startItem) {
    this.startItem = startItem;
    return this;
  }

  @Override
  public CardRowThreeItems set(String fieldName, Object value) {
    return (CardRowThreeItems) super.set(fieldName, value);
  }

  @Override
  public CardRowThreeItems clone() {
    return (CardRowThreeItems) super.clone();
  }

}
