/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for CardRowTemplateInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CardRowTemplateInfo extends com.google.api.client.json.GenericJson {

  /**
   * Template for a row containing one item. Exactly one of "one_item", "two_items", "three_items"
   * must be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CardRowOneItem oneItem;

  /**
   * Template for a row containing three items. Exactly one of "one_item", "two_items",
   * "three_items" must be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CardRowThreeItems threeItems;

  /**
   * Template for a row containing two items. Exactly one of "one_item", "two_items", "three_items"
   * must be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CardRowTwoItems twoItems;

  /**
   * Template for a row containing one item. Exactly one of "one_item", "two_items", "three_items"
   * must be set.
   * @return value or {@code null} for none
   */
  public CardRowOneItem getOneItem() {
    return oneItem;
  }

  /**
   * Template for a row containing one item. Exactly one of "one_item", "two_items", "three_items"
   * must be set.
   * @param oneItem oneItem or {@code null} for none
   */
  public CardRowTemplateInfo setOneItem(CardRowOneItem oneItem) {
    this.oneItem = oneItem;
    return this;
  }

  /**
   * Template for a row containing three items. Exactly one of "one_item", "two_items",
   * "three_items" must be set.
   * @return value or {@code null} for none
   */
  public CardRowThreeItems getThreeItems() {
    return threeItems;
  }

  /**
   * Template for a row containing three items. Exactly one of "one_item", "two_items",
   * "three_items" must be set.
   * @param threeItems threeItems or {@code null} for none
   */
  public CardRowTemplateInfo setThreeItems(CardRowThreeItems threeItems) {
    this.threeItems = threeItems;
    return this;
  }

  /**
   * Template for a row containing two items. Exactly one of "one_item", "two_items", "three_items"
   * must be set.
   * @return value or {@code null} for none
   */
  public CardRowTwoItems getTwoItems() {
    return twoItems;
  }

  /**
   * Template for a row containing two items. Exactly one of "one_item", "two_items", "three_items"
   * must be set.
   * @param twoItems twoItems or {@code null} for none
   */
  public CardRowTemplateInfo setTwoItems(CardRowTwoItems twoItems) {
    this.twoItems = twoItems;
    return this;
  }

  @Override
  public CardRowTemplateInfo set(String fieldName, Object value) {
    return (CardRowTemplateInfo) super.set(fieldName, value);
  }

  @Override
  public CardRowTemplateInfo clone() {
    return (CardRowTemplateInfo) super.clone();
  }

}
