/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for BoardingAndSeatingPolicy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BoardingAndSeatingPolicy extends com.google.api.client.json.GenericJson {

  /**
   * Indicates the policy the airline uses for boarding. If unset, Google will default to
   * `zoneBased`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String boardingPolicy;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#boardingAndSeatingPolicy"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Seating policy which dictates how we display the seat class. If unset, Google will default to
   * `cabinBased`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String seatClassPolicy;

  /**
   * Indicates the policy the airline uses for boarding. If unset, Google will default to
   * `zoneBased`.
   * @return value or {@code null} for none
   */
  public java.lang.String getBoardingPolicy() {
    return boardingPolicy;
  }

  /**
   * Indicates the policy the airline uses for boarding. If unset, Google will default to
   * `zoneBased`.
   * @param boardingPolicy boardingPolicy or {@code null} for none
   */
  public BoardingAndSeatingPolicy setBoardingPolicy(java.lang.String boardingPolicy) {
    this.boardingPolicy = boardingPolicy;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#boardingAndSeatingPolicy"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#boardingAndSeatingPolicy"`.
   * @param kind kind or {@code null} for none
   */
  public BoardingAndSeatingPolicy setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Seating policy which dictates how we display the seat class. If unset, Google will default to
   * `cabinBased`.
   * @return value or {@code null} for none
   */
  public java.lang.String getSeatClassPolicy() {
    return seatClassPolicy;
  }

  /**
   * Seating policy which dictates how we display the seat class. If unset, Google will default to
   * `cabinBased`.
   * @param seatClassPolicy seatClassPolicy or {@code null} for none
   */
  public BoardingAndSeatingPolicy setSeatClassPolicy(java.lang.String seatClassPolicy) {
    this.seatClassPolicy = seatClassPolicy;
    return this;
  }

  @Override
  public BoardingAndSeatingPolicy set(String fieldName, Object value) {
    return (BoardingAndSeatingPolicy) super.set(fieldName, value);
  }

  @Override
  public BoardingAndSeatingPolicy clone() {
    return (BoardingAndSeatingPolicy) super.clone();
  }

}
