/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for Barcode.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Barcode extends com.google.api.client.json.GenericJson {

  /**
   * An optional text that will override the default text that shows under the barcode. This field
   * is intended for a human readable equivalent of the barcode value, used when the barcode cannot
   * be scanned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String alternateText;

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#barcode"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The render encoding for the barcode. When specified, barcode is rendered in the given encoding.
   * Otherwise best known encoding is chosen by Google.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String renderEncoding;

  /**
   * Optional text that will be shown when the barcode is hidden behind a click action. This happens
   * in cases where a pass has Smart Tap enabled. If not specified, a default is chosen by Google.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString showCodeText;

  /**
   * The type of barcode.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The value encoded in the barcode.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * An optional text that will override the default text that shows under the barcode. This field
   * is intended for a human readable equivalent of the barcode value, used when the barcode cannot
   * be scanned.
   * @return value or {@code null} for none
   */
  public java.lang.String getAlternateText() {
    return alternateText;
  }

  /**
   * An optional text that will override the default text that shows under the barcode. This field
   * is intended for a human readable equivalent of the barcode value, used when the barcode cannot
   * be scanned.
   * @param alternateText alternateText or {@code null} for none
   */
  public Barcode setAlternateText(java.lang.String alternateText) {
    this.alternateText = alternateText;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#barcode"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#barcode"`.
   * @param kind kind or {@code null} for none
   */
  public Barcode setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The render encoding for the barcode. When specified, barcode is rendered in the given encoding.
   * Otherwise best known encoding is chosen by Google.
   * @return value or {@code null} for none
   */
  public java.lang.String getRenderEncoding() {
    return renderEncoding;
  }

  /**
   * The render encoding for the barcode. When specified, barcode is rendered in the given encoding.
   * Otherwise best known encoding is chosen by Google.
   * @param renderEncoding renderEncoding or {@code null} for none
   */
  public Barcode setRenderEncoding(java.lang.String renderEncoding) {
    this.renderEncoding = renderEncoding;
    return this;
  }

  /**
   * Optional text that will be shown when the barcode is hidden behind a click action. This happens
   * in cases where a pass has Smart Tap enabled. If not specified, a default is chosen by Google.
   * @return value or {@code null} for none
   */
  public LocalizedString getShowCodeText() {
    return showCodeText;
  }

  /**
   * Optional text that will be shown when the barcode is hidden behind a click action. This happens
   * in cases where a pass has Smart Tap enabled. If not specified, a default is chosen by Google.
   * @param showCodeText showCodeText or {@code null} for none
   */
  public Barcode setShowCodeText(LocalizedString showCodeText) {
    this.showCodeText = showCodeText;
    return this;
  }

  /**
   * The type of barcode.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of barcode.
   * @param type type or {@code null} for none
   */
  public Barcode setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * The value encoded in the barcode.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * The value encoded in the barcode.
   * @param value value or {@code null} for none
   */
  public Barcode setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public Barcode set(String fieldName, Object value) {
    return (Barcode) super.set(fieldName, value);
  }

  @Override
  public Barcode clone() {
    return (Barcode) super.clone();
  }

}
