/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for AirportInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AirportInfo extends com.google.api.client.json.GenericJson {

  /**
   * Three character IATA airport code. This is a required field for `origin` and `destination`. Eg:
   * "SFO"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String airportIataCode;

  /**
   * Optional field that overrides the airport city name defined by IATA. By default, Google takes
   * the `airportIataCode` provided and maps it to the official airport city name defined by IATA.
   * Official IATA airport city names can be found at IATA airport city names website. For example,
   * for the airport IATA code "LTN", IATA website tells us that the corresponding airport city is
   * "London". If this field is not populated, Google would display "London". However, populating
   * this field with a custom name (eg: "London Luton") would override it.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString airportNameOverride;

  /**
   * A name of the gate. Eg: "B59" or "59"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gate;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#airportInfo"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Terminal name. Eg: "INTL" or "I"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String terminal;

  /**
   * Three character IATA airport code. This is a required field for `origin` and `destination`. Eg:
   * "SFO"
   * @return value or {@code null} for none
   */
  public java.lang.String getAirportIataCode() {
    return airportIataCode;
  }

  /**
   * Three character IATA airport code. This is a required field for `origin` and `destination`. Eg:
   * "SFO"
   * @param airportIataCode airportIataCode or {@code null} for none
   */
  public AirportInfo setAirportIataCode(java.lang.String airportIataCode) {
    this.airportIataCode = airportIataCode;
    return this;
  }

  /**
   * Optional field that overrides the airport city name defined by IATA. By default, Google takes
   * the `airportIataCode` provided and maps it to the official airport city name defined by IATA.
   * Official IATA airport city names can be found at IATA airport city names website. For example,
   * for the airport IATA code "LTN", IATA website tells us that the corresponding airport city is
   * "London". If this field is not populated, Google would display "London". However, populating
   * this field with a custom name (eg: "London Luton") would override it.
   * @return value or {@code null} for none
   */
  public LocalizedString getAirportNameOverride() {
    return airportNameOverride;
  }

  /**
   * Optional field that overrides the airport city name defined by IATA. By default, Google takes
   * the `airportIataCode` provided and maps it to the official airport city name defined by IATA.
   * Official IATA airport city names can be found at IATA airport city names website. For example,
   * for the airport IATA code "LTN", IATA website tells us that the corresponding airport city is
   * "London". If this field is not populated, Google would display "London". However, populating
   * this field with a custom name (eg: "London Luton") would override it.
   * @param airportNameOverride airportNameOverride or {@code null} for none
   */
  public AirportInfo setAirportNameOverride(LocalizedString airportNameOverride) {
    this.airportNameOverride = airportNameOverride;
    return this;
  }

  /**
   * A name of the gate. Eg: "B59" or "59"
   * @return value or {@code null} for none
   */
  public java.lang.String getGate() {
    return gate;
  }

  /**
   * A name of the gate. Eg: "B59" or "59"
   * @param gate gate or {@code null} for none
   */
  public AirportInfo setGate(java.lang.String gate) {
    this.gate = gate;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#airportInfo"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#airportInfo"`.
   * @param kind kind or {@code null} for none
   */
  public AirportInfo setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Terminal name. Eg: "INTL" or "I"
   * @return value or {@code null} for none
   */
  public java.lang.String getTerminal() {
    return terminal;
  }

  /**
   * Terminal name. Eg: "INTL" or "I"
   * @param terminal terminal or {@code null} for none
   */
  public AirportInfo setTerminal(java.lang.String terminal) {
    this.terminal = terminal;
    return this;
  }

  @Override
  public AirportInfo set(String fieldName, Object value) {
    return (AirportInfo) super.set(fieldName, value);
  }

  @Override
  public AirportInfo clone() {
    return (AirportInfo) super.clone();
  }

}
