/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.vision.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Preconditions;
import com.google.api.services.vision.v1.VisionRequest;
import com.google.api.services.vision.v1.VisionRequestInitializer;
import com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest;
import com.google.api.services.vision.v1.model.BatchAnnotateImagesResponse;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vision
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://vision.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://vision.googleapis.com/";

    public Vision(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Vision(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Images images() {
        return new Images();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.23.0 of the Google Cloud Vision API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://vision.googleapis.com/", Vision.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Vision.DEFAULT_BATCH_PATH);
        }

        public Vision build() {
            return new Vision(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setVisionRequestInitializer(VisionRequestInitializer visionRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)visionRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Images {
        public Annotate annotate(BatchAnnotateImagesRequest batchAnnotateImagesRequest) throws IOException {
            Annotate annotate = new Annotate(batchAnnotateImagesRequest);
            Vision.this.initialize((AbstractGoogleClientRequest<?>)annotate);
            return annotate;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Annotate
        extends VisionRequest<BatchAnnotateImagesResponse> {
            private static final String REST_PATH = "v1/images:annotate";

            protected Annotate(BatchAnnotateImagesRequest batchAnnotateImagesRequest) {
                super(Vision.this, "POST", REST_PATH, (Object)batchAnnotateImagesRequest, BatchAnnotateImagesResponse.class);
            }

            public Annotate set$Xgafv(String string) {
                return (Annotate)super.set$Xgafv(string);
            }

            public Annotate setAccessToken(String string) {
                return (Annotate)super.setAccessToken(string);
            }

            public Annotate setAlt(String string) {
                return (Annotate)super.setAlt(string);
            }

            public Annotate setBearerToken(String string) {
                return (Annotate)super.setBearerToken(string);
            }

            public Annotate setCallback(String string) {
                return (Annotate)super.setCallback(string);
            }

            public Annotate setFields(String string) {
                return (Annotate)super.setFields(string);
            }

            public Annotate setKey(String string) {
                return (Annotate)super.setKey(string);
            }

            public Annotate setOauthToken(String string) {
                return (Annotate)super.setOauthToken(string);
            }

            public Annotate setPp(Boolean bl) {
                return (Annotate)super.setPp(bl);
            }

            public Annotate setPrettyPrint(Boolean bl) {
                return (Annotate)super.setPrettyPrint(bl);
            }

            public Annotate setQuotaUser(String string) {
                return (Annotate)super.setQuotaUser(string);
            }

            public Annotate setUploadType(String string) {
                return (Annotate)super.setUploadType(string);
            }

            public Annotate setUploadProtocol(String string) {
                return (Annotate)super.setUploadProtocol(string);
            }

            @Override
            public Annotate set(String string, Object object) {
                return (Annotate)super.set(string, object);
            }
        }
    }
}

