/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.translate.v3beta1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.translate.v3beta1.TranslateRequest;
import com.google.api.services.translate.v3beta1.TranslateRequestInitializer;
import com.google.api.services.translate.v3beta1.model.BatchTranslateTextRequest;
import com.google.api.services.translate.v3beta1.model.CancelOperationRequest;
import com.google.api.services.translate.v3beta1.model.DetectLanguageRequest;
import com.google.api.services.translate.v3beta1.model.DetectLanguageResponse;
import com.google.api.services.translate.v3beta1.model.Empty;
import com.google.api.services.translate.v3beta1.model.Glossary;
import com.google.api.services.translate.v3beta1.model.ListGlossariesResponse;
import com.google.api.services.translate.v3beta1.model.ListLocationsResponse;
import com.google.api.services.translate.v3beta1.model.ListOperationsResponse;
import com.google.api.services.translate.v3beta1.model.Location;
import com.google.api.services.translate.v3beta1.model.Operation;
import com.google.api.services.translate.v3beta1.model.SupportedLanguages;
import com.google.api.services.translate.v3beta1.model.TranslateTextRequest;
import com.google.api.services.translate.v3beta1.model.TranslateTextResponse;
import com.google.api.services.translate.v3beta1.model.WaitOperationRequest;
import java.io.IOException;
import java.util.regex.Pattern;

public class Translate
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://translation.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://translation.googleapis.com/";

    public Translate(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Translate(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.10 of the Cloud Translation API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://translation.googleapis.com/", Translate.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Translate.DEFAULT_BATCH_PATH);
        }

        public Translate build() {
            return new Translate(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setTranslateRequestInitializer(TranslateRequestInitializer translateRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)translateRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public DetectLanguage detectLanguage(String parent, DetectLanguageRequest content) throws IOException {
            DetectLanguage result = new DetectLanguage(parent, content);
            Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetSupportedLanguages getSupportedLanguages(String parent) throws IOException {
            GetSupportedLanguages result = new GetSupportedLanguages(parent);
            Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TranslateText translateText(String parent, TranslateTextRequest content) throws IOException {
            TranslateText result = new TranslateText(parent, content);
            Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Locations locations() {
            return new Locations();
        }

        public class Locations {
            public BatchTranslateText batchTranslateText(String parent, BatchTranslateTextRequest content) throws IOException {
                BatchTranslateText result = new BatchTranslateText(parent, content);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public DetectLanguage detectLanguage(String parent, DetectLanguageRequest content) throws IOException {
                DetectLanguage result = new DetectLanguage(parent, content);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetSupportedLanguages getSupportedLanguages(String parent) throws IOException {
                GetSupportedLanguages result = new GetSupportedLanguages(parent);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public TranslateText translateText(String parent, TranslateTextRequest content) throws IOException {
                TranslateText result = new TranslateText(parent, content);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Glossaries glossaries() {
                return new Glossaries();
            }

            public Operations operations() {
                return new Operations();
            }

            public class Operations {
                public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
                    Cancel result = new Cancel(name, content);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String name) throws IOException {
                    List result = new List(name);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Wait wait(String name, WaitOperationRequest content) throws IOException {
                    Wait result = new Wait(name, content);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Wait
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3beta1/{+name}:wait";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Wait(String name, WaitOperationRequest content) {
                        super(Translate.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Wait set$Xgafv(String $Xgafv) {
                        return (Wait)super.set$Xgafv($Xgafv);
                    }

                    public Wait setAccessToken(String accessToken) {
                        return (Wait)super.setAccessToken(accessToken);
                    }

                    public Wait setAlt(String alt) {
                        return (Wait)super.setAlt(alt);
                    }

                    public Wait setCallback(String callback) {
                        return (Wait)super.setCallback(callback);
                    }

                    public Wait setFields(String fields) {
                        return (Wait)super.setFields(fields);
                    }

                    public Wait setKey(String key) {
                        return (Wait)super.setKey(key);
                    }

                    public Wait setOauthToken(String oauthToken) {
                        return (Wait)super.setOauthToken(oauthToken);
                    }

                    public Wait setPrettyPrint(Boolean prettyPrint) {
                        return (Wait)super.setPrettyPrint(prettyPrint);
                    }

                    public Wait setQuotaUser(String quotaUser) {
                        return (Wait)super.setQuotaUser(quotaUser);
                    }

                    public Wait setUploadType(String uploadType) {
                        return (Wait)super.setUploadType(uploadType);
                    }

                    public Wait setUploadProtocol(String uploadProtocol) {
                        return (Wait)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Wait setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Wait set(String parameterName, Object value) {
                        return (Wait)super.set(parameterName, value);
                    }
                }

                public class List
                extends TranslateRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v3beta1/{+name}/operations";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String name) {
                        super(Translate.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Translate.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends TranslateRequest<Empty> {
                    private static final String REST_PATH = "v3beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Translate.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Cancel
                extends TranslateRequest<Empty> {
                    private static final String REST_PATH = "v3beta1/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String name, CancelOperationRequest content) {
                        super(Translate.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String $Xgafv) {
                        return (Cancel)super.set$Xgafv($Xgafv);
                    }

                    public Cancel setAccessToken(String accessToken) {
                        return (Cancel)super.setAccessToken(accessToken);
                    }

                    public Cancel setAlt(String alt) {
                        return (Cancel)super.setAlt(alt);
                    }

                    public Cancel setCallback(String callback) {
                        return (Cancel)super.setCallback(callback);
                    }

                    public Cancel setFields(String fields) {
                        return (Cancel)super.setFields(fields);
                    }

                    public Cancel setKey(String key) {
                        return (Cancel)super.setKey(key);
                    }

                    public Cancel setOauthToken(String oauthToken) {
                        return (Cancel)super.setOauthToken(oauthToken);
                    }

                    public Cancel setPrettyPrint(Boolean prettyPrint) {
                        return (Cancel)super.setPrettyPrint(prettyPrint);
                    }

                    public Cancel setQuotaUser(String quotaUser) {
                        return (Cancel)super.setQuotaUser(quotaUser);
                    }

                    public Cancel setUploadType(String uploadType) {
                        return (Cancel)super.setUploadType(uploadType);
                    }

                    public Cancel setUploadProtocol(String uploadProtocol) {
                        return (Cancel)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Cancel set(String parameterName, Object value) {
                        return (Cancel)super.set(parameterName, value);
                    }
                }
            }

            public class Glossaries {
                public Create create(String parent, Glossary content) throws IOException {
                    Create result = new Create(parent, content);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends TranslateRequest<ListGlossariesResponse> {
                    private static final String REST_PATH = "v3beta1/{+parent}/glossaries";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(Translate.this, "GET", REST_PATH, null, ListGlossariesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends TranslateRequest<Glossary> {
                    private static final String REST_PATH = "v3beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(Translate.this, "GET", REST_PATH, null, Glossary.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(Translate.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3beta1/{+parent}/glossaries";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, Glossary content) {
                        super(Translate.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class TranslateText
            extends TranslateRequest<TranslateTextResponse> {
                private static final String REST_PATH = "v3beta1/{+parent}:translateText";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected TranslateText(String parent, TranslateTextRequest content) {
                    super(Translate.this, "POST", REST_PATH, (Object)content, TranslateTextResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public TranslateText set$Xgafv(String $Xgafv) {
                    return (TranslateText)super.set$Xgafv($Xgafv);
                }

                public TranslateText setAccessToken(String accessToken) {
                    return (TranslateText)super.setAccessToken(accessToken);
                }

                public TranslateText setAlt(String alt) {
                    return (TranslateText)super.setAlt(alt);
                }

                public TranslateText setCallback(String callback) {
                    return (TranslateText)super.setCallback(callback);
                }

                public TranslateText setFields(String fields) {
                    return (TranslateText)super.setFields(fields);
                }

                public TranslateText setKey(String key) {
                    return (TranslateText)super.setKey(key);
                }

                public TranslateText setOauthToken(String oauthToken) {
                    return (TranslateText)super.setOauthToken(oauthToken);
                }

                public TranslateText setPrettyPrint(Boolean prettyPrint) {
                    return (TranslateText)super.setPrettyPrint(prettyPrint);
                }

                public TranslateText setQuotaUser(String quotaUser) {
                    return (TranslateText)super.setQuotaUser(quotaUser);
                }

                public TranslateText setUploadType(String uploadType) {
                    return (TranslateText)super.setUploadType(uploadType);
                }

                public TranslateText setUploadProtocol(String uploadProtocol) {
                    return (TranslateText)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public TranslateText setParent(String parent) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public TranslateText set(String parameterName, Object value) {
                    return (TranslateText)super.set(parameterName, value);
                }
            }

            public class List
            extends TranslateRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v3beta1/{+name}/locations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(Translate.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class GetSupportedLanguages
            extends TranslateRequest<SupportedLanguages> {
                private static final String REST_PATH = "v3beta1/{+parent}/supportedLanguages";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String displayLanguageCode;
                @Key
                private String model;

                protected GetSupportedLanguages(String parent) {
                    super(Translate.this, "GET", REST_PATH, null, SupportedLanguages.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetSupportedLanguages set$Xgafv(String $Xgafv) {
                    return (GetSupportedLanguages)super.set$Xgafv($Xgafv);
                }

                public GetSupportedLanguages setAccessToken(String accessToken) {
                    return (GetSupportedLanguages)super.setAccessToken(accessToken);
                }

                public GetSupportedLanguages setAlt(String alt) {
                    return (GetSupportedLanguages)super.setAlt(alt);
                }

                public GetSupportedLanguages setCallback(String callback) {
                    return (GetSupportedLanguages)super.setCallback(callback);
                }

                public GetSupportedLanguages setFields(String fields) {
                    return (GetSupportedLanguages)super.setFields(fields);
                }

                public GetSupportedLanguages setKey(String key) {
                    return (GetSupportedLanguages)super.setKey(key);
                }

                public GetSupportedLanguages setOauthToken(String oauthToken) {
                    return (GetSupportedLanguages)super.setOauthToken(oauthToken);
                }

                public GetSupportedLanguages setPrettyPrint(Boolean prettyPrint) {
                    return (GetSupportedLanguages)super.setPrettyPrint(prettyPrint);
                }

                public GetSupportedLanguages setQuotaUser(String quotaUser) {
                    return (GetSupportedLanguages)super.setQuotaUser(quotaUser);
                }

                public GetSupportedLanguages setUploadType(String uploadType) {
                    return (GetSupportedLanguages)super.setUploadType(uploadType);
                }

                public GetSupportedLanguages setUploadProtocol(String uploadProtocol) {
                    return (GetSupportedLanguages)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public GetSupportedLanguages setParent(String parent) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getDisplayLanguageCode() {
                    return this.displayLanguageCode;
                }

                public GetSupportedLanguages setDisplayLanguageCode(String displayLanguageCode) {
                    this.displayLanguageCode = displayLanguageCode;
                    return this;
                }

                public String getModel() {
                    return this.model;
                }

                public GetSupportedLanguages setModel(String model) {
                    this.model = model;
                    return this;
                }

                @Override
                public GetSupportedLanguages set(String parameterName, Object value) {
                    return (GetSupportedLanguages)super.set(parameterName, value);
                }
            }

            public class Get
            extends TranslateRequest<Location> {
                private static final String REST_PATH = "v3beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(Translate.this, "GET", REST_PATH, null, Location.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class DetectLanguage
            extends TranslateRequest<DetectLanguageResponse> {
                private static final String REST_PATH = "v3beta1/{+parent}:detectLanguage";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected DetectLanguage(String parent, DetectLanguageRequest content) {
                    super(Translate.this, "POST", REST_PATH, (Object)content, DetectLanguageResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public DetectLanguage set$Xgafv(String $Xgafv) {
                    return (DetectLanguage)super.set$Xgafv($Xgafv);
                }

                public DetectLanguage setAccessToken(String accessToken) {
                    return (DetectLanguage)super.setAccessToken(accessToken);
                }

                public DetectLanguage setAlt(String alt) {
                    return (DetectLanguage)super.setAlt(alt);
                }

                public DetectLanguage setCallback(String callback) {
                    return (DetectLanguage)super.setCallback(callback);
                }

                public DetectLanguage setFields(String fields) {
                    return (DetectLanguage)super.setFields(fields);
                }

                public DetectLanguage setKey(String key) {
                    return (DetectLanguage)super.setKey(key);
                }

                public DetectLanguage setOauthToken(String oauthToken) {
                    return (DetectLanguage)super.setOauthToken(oauthToken);
                }

                public DetectLanguage setPrettyPrint(Boolean prettyPrint) {
                    return (DetectLanguage)super.setPrettyPrint(prettyPrint);
                }

                public DetectLanguage setQuotaUser(String quotaUser) {
                    return (DetectLanguage)super.setQuotaUser(quotaUser);
                }

                public DetectLanguage setUploadType(String uploadType) {
                    return (DetectLanguage)super.setUploadType(uploadType);
                }

                public DetectLanguage setUploadProtocol(String uploadProtocol) {
                    return (DetectLanguage)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public DetectLanguage setParent(String parent) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public DetectLanguage set(String parameterName, Object value) {
                    return (DetectLanguage)super.set(parameterName, value);
                }
            }

            public class BatchTranslateText
            extends TranslateRequest<Operation> {
                private static final String REST_PATH = "v3beta1/{+parent}:batchTranslateText";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected BatchTranslateText(String parent, BatchTranslateTextRequest content) {
                    super(Translate.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public BatchTranslateText set$Xgafv(String $Xgafv) {
                    return (BatchTranslateText)super.set$Xgafv($Xgafv);
                }

                public BatchTranslateText setAccessToken(String accessToken) {
                    return (BatchTranslateText)super.setAccessToken(accessToken);
                }

                public BatchTranslateText setAlt(String alt) {
                    return (BatchTranslateText)super.setAlt(alt);
                }

                public BatchTranslateText setCallback(String callback) {
                    return (BatchTranslateText)super.setCallback(callback);
                }

                public BatchTranslateText setFields(String fields) {
                    return (BatchTranslateText)super.setFields(fields);
                }

                public BatchTranslateText setKey(String key) {
                    return (BatchTranslateText)super.setKey(key);
                }

                public BatchTranslateText setOauthToken(String oauthToken) {
                    return (BatchTranslateText)super.setOauthToken(oauthToken);
                }

                public BatchTranslateText setPrettyPrint(Boolean prettyPrint) {
                    return (BatchTranslateText)super.setPrettyPrint(prettyPrint);
                }

                public BatchTranslateText setQuotaUser(String quotaUser) {
                    return (BatchTranslateText)super.setQuotaUser(quotaUser);
                }

                public BatchTranslateText setUploadType(String uploadType) {
                    return (BatchTranslateText)super.setUploadType(uploadType);
                }

                public BatchTranslateText setUploadProtocol(String uploadProtocol) {
                    return (BatchTranslateText)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public BatchTranslateText setParent(String parent) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public BatchTranslateText set(String parameterName, Object value) {
                    return (BatchTranslateText)super.set(parameterName, value);
                }
            }
        }

        public class TranslateText
        extends TranslateRequest<TranslateTextResponse> {
            private static final String REST_PATH = "v3beta1/{+parent}:translateText";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected TranslateText(String parent, TranslateTextRequest content) {
                super(Translate.this, "POST", REST_PATH, (Object)content, TranslateTextResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
            }

            public TranslateText set$Xgafv(String $Xgafv) {
                return (TranslateText)super.set$Xgafv($Xgafv);
            }

            public TranslateText setAccessToken(String accessToken) {
                return (TranslateText)super.setAccessToken(accessToken);
            }

            public TranslateText setAlt(String alt) {
                return (TranslateText)super.setAlt(alt);
            }

            public TranslateText setCallback(String callback) {
                return (TranslateText)super.setCallback(callback);
            }

            public TranslateText setFields(String fields) {
                return (TranslateText)super.setFields(fields);
            }

            public TranslateText setKey(String key) {
                return (TranslateText)super.setKey(key);
            }

            public TranslateText setOauthToken(String oauthToken) {
                return (TranslateText)super.setOauthToken(oauthToken);
            }

            public TranslateText setPrettyPrint(Boolean prettyPrint) {
                return (TranslateText)super.setPrettyPrint(prettyPrint);
            }

            public TranslateText setQuotaUser(String quotaUser) {
                return (TranslateText)super.setQuotaUser(quotaUser);
            }

            public TranslateText setUploadType(String uploadType) {
                return (TranslateText)super.setUploadType(uploadType);
            }

            public TranslateText setUploadProtocol(String uploadProtocol) {
                return (TranslateText)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public TranslateText setParent(String parent) {
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            public TranslateText set(String parameterName, Object value) {
                return (TranslateText)super.set(parameterName, value);
            }
        }

        public class GetSupportedLanguages
        extends TranslateRequest<SupportedLanguages> {
            private static final String REST_PATH = "v3beta1/{+parent}/supportedLanguages";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private String displayLanguageCode;
            @Key
            private String model;

            protected GetSupportedLanguages(String parent) {
                super(Translate.this, "GET", REST_PATH, null, SupportedLanguages.class);
                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetSupportedLanguages set$Xgafv(String $Xgafv) {
                return (GetSupportedLanguages)super.set$Xgafv($Xgafv);
            }

            public GetSupportedLanguages setAccessToken(String accessToken) {
                return (GetSupportedLanguages)super.setAccessToken(accessToken);
            }

            public GetSupportedLanguages setAlt(String alt) {
                return (GetSupportedLanguages)super.setAlt(alt);
            }

            public GetSupportedLanguages setCallback(String callback) {
                return (GetSupportedLanguages)super.setCallback(callback);
            }

            public GetSupportedLanguages setFields(String fields) {
                return (GetSupportedLanguages)super.setFields(fields);
            }

            public GetSupportedLanguages setKey(String key) {
                return (GetSupportedLanguages)super.setKey(key);
            }

            public GetSupportedLanguages setOauthToken(String oauthToken) {
                return (GetSupportedLanguages)super.setOauthToken(oauthToken);
            }

            public GetSupportedLanguages setPrettyPrint(Boolean prettyPrint) {
                return (GetSupportedLanguages)super.setPrettyPrint(prettyPrint);
            }

            public GetSupportedLanguages setQuotaUser(String quotaUser) {
                return (GetSupportedLanguages)super.setQuotaUser(quotaUser);
            }

            public GetSupportedLanguages setUploadType(String uploadType) {
                return (GetSupportedLanguages)super.setUploadType(uploadType);
            }

            public GetSupportedLanguages setUploadProtocol(String uploadProtocol) {
                return (GetSupportedLanguages)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public GetSupportedLanguages setParent(String parent) {
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public String getDisplayLanguageCode() {
                return this.displayLanguageCode;
            }

            public GetSupportedLanguages setDisplayLanguageCode(String displayLanguageCode) {
                this.displayLanguageCode = displayLanguageCode;
                return this;
            }

            public String getModel() {
                return this.model;
            }

            public GetSupportedLanguages setModel(String model) {
                this.model = model;
                return this;
            }

            @Override
            public GetSupportedLanguages set(String parameterName, Object value) {
                return (GetSupportedLanguages)super.set(parameterName, value);
            }
        }

        public class DetectLanguage
        extends TranslateRequest<DetectLanguageResponse> {
            private static final String REST_PATH = "v3beta1/{+parent}:detectLanguage";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected DetectLanguage(String parent, DetectLanguageRequest content) {
                super(Translate.this, "POST", REST_PATH, (Object)content, DetectLanguageResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
            }

            public DetectLanguage set$Xgafv(String $Xgafv) {
                return (DetectLanguage)super.set$Xgafv($Xgafv);
            }

            public DetectLanguage setAccessToken(String accessToken) {
                return (DetectLanguage)super.setAccessToken(accessToken);
            }

            public DetectLanguage setAlt(String alt) {
                return (DetectLanguage)super.setAlt(alt);
            }

            public DetectLanguage setCallback(String callback) {
                return (DetectLanguage)super.setCallback(callback);
            }

            public DetectLanguage setFields(String fields) {
                return (DetectLanguage)super.setFields(fields);
            }

            public DetectLanguage setKey(String key) {
                return (DetectLanguage)super.setKey(key);
            }

            public DetectLanguage setOauthToken(String oauthToken) {
                return (DetectLanguage)super.setOauthToken(oauthToken);
            }

            public DetectLanguage setPrettyPrint(Boolean prettyPrint) {
                return (DetectLanguage)super.setPrettyPrint(prettyPrint);
            }

            public DetectLanguage setQuotaUser(String quotaUser) {
                return (DetectLanguage)super.setQuotaUser(quotaUser);
            }

            public DetectLanguage setUploadType(String uploadType) {
                return (DetectLanguage)super.setUploadType(uploadType);
            }

            public DetectLanguage setUploadProtocol(String uploadProtocol) {
                return (DetectLanguage)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public DetectLanguage setParent(String parent) {
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            public DetectLanguage set(String parameterName, Object value) {
                return (DetectLanguage)super.set(parameterName, value);
            }
        }
    }
}

