/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.translate.v3beta1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.translate.v3beta1.TranslateRequest;
import com.google.api.services.translate.v3beta1.TranslateRequestInitializer;
import com.google.api.services.translate.v3beta1.model.BatchTranslateTextRequest;
import com.google.api.services.translate.v3beta1.model.CancelOperationRequest;
import com.google.api.services.translate.v3beta1.model.DetectLanguageRequest;
import com.google.api.services.translate.v3beta1.model.DetectLanguageResponse;
import com.google.api.services.translate.v3beta1.model.Empty;
import com.google.api.services.translate.v3beta1.model.Glossary;
import com.google.api.services.translate.v3beta1.model.ListGlossariesResponse;
import com.google.api.services.translate.v3beta1.model.ListLocationsResponse;
import com.google.api.services.translate.v3beta1.model.ListOperationsResponse;
import com.google.api.services.translate.v3beta1.model.Location;
import com.google.api.services.translate.v3beta1.model.Operation;
import com.google.api.services.translate.v3beta1.model.SupportedLanguages;
import com.google.api.services.translate.v3beta1.model.TranslateTextRequest;
import com.google.api.services.translate.v3beta1.model.TranslateTextResponse;
import com.google.api.services.translate.v3beta1.model.WaitOperationRequest;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Translate
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://translation.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://translation.googleapis.com/";

    public Translate(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Translate(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Cloud Translation API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://translation.googleapis.com/", Translate.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Translate.DEFAULT_BATCH_PATH);
        }

        public Translate build() {
            return new Translate(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setTranslateRequestInitializer(TranslateRequestInitializer translateRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)translateRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public DetectLanguage detectLanguage(String string, DetectLanguageRequest detectLanguageRequest) throws IOException {
            DetectLanguage detectLanguage = new DetectLanguage(string, detectLanguageRequest);
            Translate.this.initialize((AbstractGoogleClientRequest<?>)detectLanguage);
            return detectLanguage;
        }

        public GetSupportedLanguages getSupportedLanguages(String string) throws IOException {
            GetSupportedLanguages getSupportedLanguages = new GetSupportedLanguages(string);
            Translate.this.initialize((AbstractGoogleClientRequest<?>)getSupportedLanguages);
            return getSupportedLanguages;
        }

        public TranslateText translateText(String string, TranslateTextRequest translateTextRequest) throws IOException {
            TranslateText translateText = new TranslateText(string, translateTextRequest);
            Translate.this.initialize((AbstractGoogleClientRequest<?>)translateText);
            return translateText;
        }

        public Locations locations() {
            return new Locations();
        }

        public class Locations {
            public BatchTranslateText batchTranslateText(String string, BatchTranslateTextRequest batchTranslateTextRequest) throws IOException {
                BatchTranslateText batchTranslateText = new BatchTranslateText(string, batchTranslateTextRequest);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)batchTranslateText);
                return batchTranslateText;
            }

            public DetectLanguage detectLanguage(String string, DetectLanguageRequest detectLanguageRequest) throws IOException {
                DetectLanguage detectLanguage = new DetectLanguage(string, detectLanguageRequest);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)detectLanguage);
                return detectLanguage;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public GetSupportedLanguages getSupportedLanguages(String string) throws IOException {
                GetSupportedLanguages getSupportedLanguages = new GetSupportedLanguages(string);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)getSupportedLanguages);
                return getSupportedLanguages;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public TranslateText translateText(String string, TranslateTextRequest translateTextRequest) throws IOException {
                TranslateText translateText = new TranslateText(string, translateTextRequest);
                Translate.this.initialize((AbstractGoogleClientRequest<?>)translateText);
                return translateText;
            }

            public Glossaries glossaries() {
                return new Glossaries();
            }

            public Operations operations() {
                return new Operations();
            }

            public class Operations {
                public Cancel cancel(String string, CancelOperationRequest cancelOperationRequest) throws IOException {
                    Cancel cancel = new Cancel(string, cancelOperationRequest);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)cancel);
                    return cancel;
                }

                public Delete delete(String string) throws IOException {
                    Delete delete = new Delete(string);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Wait wait(String string, WaitOperationRequest waitOperationRequest) throws IOException {
                    Wait wait = new Wait(string, waitOperationRequest);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)wait);
                    return wait;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Wait
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3beta1/{+name}:wait";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Wait(String string, WaitOperationRequest waitOperationRequest) {
                        super(Translate.this, "POST", REST_PATH, (Object)waitOperationRequest, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Wait set$Xgafv(String string) {
                        return (Wait)super.set$Xgafv(string);
                    }

                    public Wait setAccessToken(String string) {
                        return (Wait)super.setAccessToken(string);
                    }

                    public Wait setAlt(String string) {
                        return (Wait)super.setAlt(string);
                    }

                    public Wait setCallback(String string) {
                        return (Wait)super.setCallback(string);
                    }

                    public Wait setFields(String string) {
                        return (Wait)super.setFields(string);
                    }

                    public Wait setKey(String string) {
                        return (Wait)super.setKey(string);
                    }

                    public Wait setOauthToken(String string) {
                        return (Wait)super.setOauthToken(string);
                    }

                    public Wait setPrettyPrint(Boolean bl) {
                        return (Wait)super.setPrettyPrint(bl);
                    }

                    public Wait setQuotaUser(String string) {
                        return (Wait)super.setQuotaUser(string);
                    }

                    public Wait setUploadType(String string) {
                        return (Wait)super.setUploadType(string);
                    }

                    public Wait setUploadProtocol(String string) {
                        return (Wait)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Wait setName(String string) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Wait set(String string, Object object) {
                        return (Wait)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends TranslateRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v3beta1/{+name}/operations";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String filter;

                    protected List(String string) {
                        super(Translate.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String string) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String string) {
                        this.filter = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String string) {
                        super(Translate.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends TranslateRequest<Empty> {
                    private static final String REST_PATH = "v3beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String string) {
                        super(Translate.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String string) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Cancel
                extends TranslateRequest<Empty> {
                    private static final String REST_PATH = "v3beta1/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String string, CancelOperationRequest cancelOperationRequest) {
                        super(Translate.this, "POST", REST_PATH, (Object)cancelOperationRequest, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String string) {
                        return (Cancel)super.set$Xgafv(string);
                    }

                    public Cancel setAccessToken(String string) {
                        return (Cancel)super.setAccessToken(string);
                    }

                    public Cancel setAlt(String string) {
                        return (Cancel)super.setAlt(string);
                    }

                    public Cancel setCallback(String string) {
                        return (Cancel)super.setCallback(string);
                    }

                    public Cancel setFields(String string) {
                        return (Cancel)super.setFields(string);
                    }

                    public Cancel setKey(String string) {
                        return (Cancel)super.setKey(string);
                    }

                    public Cancel setOauthToken(String string) {
                        return (Cancel)super.setOauthToken(string);
                    }

                    public Cancel setPrettyPrint(Boolean bl) {
                        return (Cancel)super.setPrettyPrint(bl);
                    }

                    public Cancel setQuotaUser(String string) {
                        return (Cancel)super.setQuotaUser(string);
                    }

                    public Cancel setUploadType(String string) {
                        return (Cancel)super.setUploadType(string);
                    }

                    public Cancel setUploadProtocol(String string) {
                        return (Cancel)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String string) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Cancel set(String string, Object object) {
                        return (Cancel)super.set(string, object);
                    }
                }
            }

            public class Glossaries {
                public Create create(String string, Glossary glossary) throws IOException {
                    Create create = new Create(string, glossary);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string) throws IOException {
                    Delete delete = new Delete(string);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Translate.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends TranslateRequest<ListGlossariesResponse> {
                    private static final String REST_PATH = "v3beta1/{+parent}/glossaries";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String filter;

                    protected List(String string) {
                        super(Translate.this, "GET", REST_PATH, null, ListGlossariesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String string) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String string) {
                        this.filter = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends TranslateRequest<Glossary> {
                    private static final String REST_PATH = "v3beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String string) {
                        super(Translate.this, "GET", REST_PATH, null, Glossary.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String string) {
                        super(Translate.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String string) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/glossaries/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends TranslateRequest<Operation> {
                    private static final String REST_PATH = "v3beta1/{+parent}/glossaries";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String string, Glossary glossary) {
                        super(Translate.this, "POST", REST_PATH, (Object)glossary, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String string) {
                        if (!Translate.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class TranslateText
            extends TranslateRequest<TranslateTextResponse> {
                private static final String REST_PATH = "v3beta1/{+parent}:translateText";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected TranslateText(String string, TranslateTextRequest translateTextRequest) {
                    super(Translate.this, "POST", REST_PATH, (Object)translateTextRequest, TranslateTextResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public TranslateText set$Xgafv(String string) {
                    return (TranslateText)super.set$Xgafv(string);
                }

                public TranslateText setAccessToken(String string) {
                    return (TranslateText)super.setAccessToken(string);
                }

                public TranslateText setAlt(String string) {
                    return (TranslateText)super.setAlt(string);
                }

                public TranslateText setCallback(String string) {
                    return (TranslateText)super.setCallback(string);
                }

                public TranslateText setFields(String string) {
                    return (TranslateText)super.setFields(string);
                }

                public TranslateText setKey(String string) {
                    return (TranslateText)super.setKey(string);
                }

                public TranslateText setOauthToken(String string) {
                    return (TranslateText)super.setOauthToken(string);
                }

                public TranslateText setPrettyPrint(Boolean bl) {
                    return (TranslateText)super.setPrettyPrint(bl);
                }

                public TranslateText setQuotaUser(String string) {
                    return (TranslateText)super.setQuotaUser(string);
                }

                public TranslateText setUploadType(String string) {
                    return (TranslateText)super.setUploadType(string);
                }

                public TranslateText setUploadProtocol(String string) {
                    return (TranslateText)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public TranslateText setParent(String string) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public TranslateText set(String string, Object object) {
                    return (TranslateText)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends TranslateRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v3beta1/{+name}/locations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Translate.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String string) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String string) {
                    this.filter = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetSupportedLanguages
            extends TranslateRequest<SupportedLanguages> {
                private static final String REST_PATH = "v3beta1/{+parent}/supportedLanguages";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String model;
                @Key
                private String displayLanguageCode;

                protected GetSupportedLanguages(String string) {
                    super(Translate.this, "GET", REST_PATH, null, SupportedLanguages.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetSupportedLanguages set$Xgafv(String string) {
                    return (GetSupportedLanguages)super.set$Xgafv(string);
                }

                public GetSupportedLanguages setAccessToken(String string) {
                    return (GetSupportedLanguages)super.setAccessToken(string);
                }

                public GetSupportedLanguages setAlt(String string) {
                    return (GetSupportedLanguages)super.setAlt(string);
                }

                public GetSupportedLanguages setCallback(String string) {
                    return (GetSupportedLanguages)super.setCallback(string);
                }

                public GetSupportedLanguages setFields(String string) {
                    return (GetSupportedLanguages)super.setFields(string);
                }

                public GetSupportedLanguages setKey(String string) {
                    return (GetSupportedLanguages)super.setKey(string);
                }

                public GetSupportedLanguages setOauthToken(String string) {
                    return (GetSupportedLanguages)super.setOauthToken(string);
                }

                public GetSupportedLanguages setPrettyPrint(Boolean bl) {
                    return (GetSupportedLanguages)super.setPrettyPrint(bl);
                }

                public GetSupportedLanguages setQuotaUser(String string) {
                    return (GetSupportedLanguages)super.setQuotaUser(string);
                }

                public GetSupportedLanguages setUploadType(String string) {
                    return (GetSupportedLanguages)super.setUploadType(string);
                }

                public GetSupportedLanguages setUploadProtocol(String string) {
                    return (GetSupportedLanguages)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public GetSupportedLanguages setParent(String string) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getModel() {
                    return this.model;
                }

                public GetSupportedLanguages setModel(String string) {
                    this.model = string;
                    return this;
                }

                public String getDisplayLanguageCode() {
                    return this.displayLanguageCode;
                }

                public GetSupportedLanguages setDisplayLanguageCode(String string) {
                    this.displayLanguageCode = string;
                    return this;
                }

                @Override
                public GetSupportedLanguages set(String string, Object object) {
                    return (GetSupportedLanguages)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends TranslateRequest<Location> {
                private static final String REST_PATH = "v3beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String string) {
                    super(Translate.this, "GET", REST_PATH, null, Location.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class DetectLanguage
            extends TranslateRequest<DetectLanguageResponse> {
                private static final String REST_PATH = "v3beta1/{+parent}:detectLanguage";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected DetectLanguage(String string, DetectLanguageRequest detectLanguageRequest) {
                    super(Translate.this, "POST", REST_PATH, (Object)detectLanguageRequest, DetectLanguageResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public DetectLanguage set$Xgafv(String string) {
                    return (DetectLanguage)super.set$Xgafv(string);
                }

                public DetectLanguage setAccessToken(String string) {
                    return (DetectLanguage)super.setAccessToken(string);
                }

                public DetectLanguage setAlt(String string) {
                    return (DetectLanguage)super.setAlt(string);
                }

                public DetectLanguage setCallback(String string) {
                    return (DetectLanguage)super.setCallback(string);
                }

                public DetectLanguage setFields(String string) {
                    return (DetectLanguage)super.setFields(string);
                }

                public DetectLanguage setKey(String string) {
                    return (DetectLanguage)super.setKey(string);
                }

                public DetectLanguage setOauthToken(String string) {
                    return (DetectLanguage)super.setOauthToken(string);
                }

                public DetectLanguage setPrettyPrint(Boolean bl) {
                    return (DetectLanguage)super.setPrettyPrint(bl);
                }

                public DetectLanguage setQuotaUser(String string) {
                    return (DetectLanguage)super.setQuotaUser(string);
                }

                public DetectLanguage setUploadType(String string) {
                    return (DetectLanguage)super.setUploadType(string);
                }

                public DetectLanguage setUploadProtocol(String string) {
                    return (DetectLanguage)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public DetectLanguage setParent(String string) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public DetectLanguage set(String string, Object object) {
                    return (DetectLanguage)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchTranslateText
            extends TranslateRequest<Operation> {
                private static final String REST_PATH = "v3beta1/{+parent}:batchTranslateText";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected BatchTranslateText(String string, BatchTranslateTextRequest batchTranslateTextRequest) {
                    super(Translate.this, "POST", REST_PATH, (Object)batchTranslateTextRequest, Operation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public BatchTranslateText set$Xgafv(String string) {
                    return (BatchTranslateText)super.set$Xgafv(string);
                }

                public BatchTranslateText setAccessToken(String string) {
                    return (BatchTranslateText)super.setAccessToken(string);
                }

                public BatchTranslateText setAlt(String string) {
                    return (BatchTranslateText)super.setAlt(string);
                }

                public BatchTranslateText setCallback(String string) {
                    return (BatchTranslateText)super.setCallback(string);
                }

                public BatchTranslateText setFields(String string) {
                    return (BatchTranslateText)super.setFields(string);
                }

                public BatchTranslateText setKey(String string) {
                    return (BatchTranslateText)super.setKey(string);
                }

                public BatchTranslateText setOauthToken(String string) {
                    return (BatchTranslateText)super.setOauthToken(string);
                }

                public BatchTranslateText setPrettyPrint(Boolean bl) {
                    return (BatchTranslateText)super.setPrettyPrint(bl);
                }

                public BatchTranslateText setQuotaUser(String string) {
                    return (BatchTranslateText)super.setQuotaUser(string);
                }

                public BatchTranslateText setUploadType(String string) {
                    return (BatchTranslateText)super.setUploadType(string);
                }

                public BatchTranslateText setUploadProtocol(String string) {
                    return (BatchTranslateText)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public BatchTranslateText setParent(String string) {
                    if (!Translate.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public BatchTranslateText set(String string, Object object) {
                    return (BatchTranslateText)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class TranslateText
        extends TranslateRequest<TranslateTextResponse> {
            private static final String REST_PATH = "v3beta1/{+parent}:translateText";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected TranslateText(String string, TranslateTextRequest translateTextRequest) {
                super(Translate.this, "POST", REST_PATH, (Object)translateTextRequest, TranslateTextResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
            }

            public TranslateText set$Xgafv(String string) {
                return (TranslateText)super.set$Xgafv(string);
            }

            public TranslateText setAccessToken(String string) {
                return (TranslateText)super.setAccessToken(string);
            }

            public TranslateText setAlt(String string) {
                return (TranslateText)super.setAlt(string);
            }

            public TranslateText setCallback(String string) {
                return (TranslateText)super.setCallback(string);
            }

            public TranslateText setFields(String string) {
                return (TranslateText)super.setFields(string);
            }

            public TranslateText setKey(String string) {
                return (TranslateText)super.setKey(string);
            }

            public TranslateText setOauthToken(String string) {
                return (TranslateText)super.setOauthToken(string);
            }

            public TranslateText setPrettyPrint(Boolean bl) {
                return (TranslateText)super.setPrettyPrint(bl);
            }

            public TranslateText setQuotaUser(String string) {
                return (TranslateText)super.setQuotaUser(string);
            }

            public TranslateText setUploadType(String string) {
                return (TranslateText)super.setUploadType(string);
            }

            public TranslateText setUploadProtocol(String string) {
                return (TranslateText)super.setUploadProtocol(string);
            }

            public String getParent() {
                return this.parent;
            }

            public TranslateText setParent(String string) {
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
                this.parent = string;
                return this;
            }

            @Override
            public TranslateText set(String string, Object object) {
                return (TranslateText)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetSupportedLanguages
        extends TranslateRequest<SupportedLanguages> {
            private static final String REST_PATH = "v3beta1/{+parent}/supportedLanguages";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private String displayLanguageCode;
            @Key
            private String model;

            protected GetSupportedLanguages(String string) {
                super(Translate.this, "GET", REST_PATH, null, SupportedLanguages.class);
                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetSupportedLanguages set$Xgafv(String string) {
                return (GetSupportedLanguages)super.set$Xgafv(string);
            }

            public GetSupportedLanguages setAccessToken(String string) {
                return (GetSupportedLanguages)super.setAccessToken(string);
            }

            public GetSupportedLanguages setAlt(String string) {
                return (GetSupportedLanguages)super.setAlt(string);
            }

            public GetSupportedLanguages setCallback(String string) {
                return (GetSupportedLanguages)super.setCallback(string);
            }

            public GetSupportedLanguages setFields(String string) {
                return (GetSupportedLanguages)super.setFields(string);
            }

            public GetSupportedLanguages setKey(String string) {
                return (GetSupportedLanguages)super.setKey(string);
            }

            public GetSupportedLanguages setOauthToken(String string) {
                return (GetSupportedLanguages)super.setOauthToken(string);
            }

            public GetSupportedLanguages setPrettyPrint(Boolean bl) {
                return (GetSupportedLanguages)super.setPrettyPrint(bl);
            }

            public GetSupportedLanguages setQuotaUser(String string) {
                return (GetSupportedLanguages)super.setQuotaUser(string);
            }

            public GetSupportedLanguages setUploadType(String string) {
                return (GetSupportedLanguages)super.setUploadType(string);
            }

            public GetSupportedLanguages setUploadProtocol(String string) {
                return (GetSupportedLanguages)super.setUploadProtocol(string);
            }

            public String getParent() {
                return this.parent;
            }

            public GetSupportedLanguages setParent(String string) {
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
                this.parent = string;
                return this;
            }

            public String getDisplayLanguageCode() {
                return this.displayLanguageCode;
            }

            public GetSupportedLanguages setDisplayLanguageCode(String string) {
                this.displayLanguageCode = string;
                return this;
            }

            public String getModel() {
                return this.model;
            }

            public GetSupportedLanguages setModel(String string) {
                this.model = string;
                return this;
            }

            @Override
            public GetSupportedLanguages set(String string, Object object) {
                return (GetSupportedLanguages)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class DetectLanguage
        extends TranslateRequest<DetectLanguageResponse> {
            private static final String REST_PATH = "v3beta1/{+parent}:detectLanguage";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected DetectLanguage(String string, DetectLanguageRequest detectLanguageRequest) {
                super(Translate.this, "POST", REST_PATH, (Object)detectLanguageRequest, DetectLanguageResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
            }

            public DetectLanguage set$Xgafv(String string) {
                return (DetectLanguage)super.set$Xgafv(string);
            }

            public DetectLanguage setAccessToken(String string) {
                return (DetectLanguage)super.setAccessToken(string);
            }

            public DetectLanguage setAlt(String string) {
                return (DetectLanguage)super.setAlt(string);
            }

            public DetectLanguage setCallback(String string) {
                return (DetectLanguage)super.setCallback(string);
            }

            public DetectLanguage setFields(String string) {
                return (DetectLanguage)super.setFields(string);
            }

            public DetectLanguage setKey(String string) {
                return (DetectLanguage)super.setKey(string);
            }

            public DetectLanguage setOauthToken(String string) {
                return (DetectLanguage)super.setOauthToken(string);
            }

            public DetectLanguage setPrettyPrint(Boolean bl) {
                return (DetectLanguage)super.setPrettyPrint(bl);
            }

            public DetectLanguage setQuotaUser(String string) {
                return (DetectLanguage)super.setQuotaUser(string);
            }

            public DetectLanguage setUploadType(String string) {
                return (DetectLanguage)super.setUploadType(string);
            }

            public DetectLanguage setUploadProtocol(String string) {
                return (DetectLanguage)super.setUploadProtocol(string);
            }

            public String getParent() {
                return this.parent;
            }

            public DetectLanguage setParent(String string) {
                if (!Translate.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                }
                this.parent = string;
                return this;
            }

            @Override
            public DetectLanguage set(String string, Object object) {
                return (DetectLanguage)super.set(string, object);
            }
        }
    }
}

