/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.translate;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.translate.TranslateRequest;
import com.google.api.services.translate.TranslateRequestInitializer;
import com.google.api.services.translate.model.DetectionsListResponse;
import com.google.api.services.translate.model.LanguagesListResponse;
import com.google.api.services.translate.model.TranslationsListResponse;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Translate
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "language/translate/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/language/translate/";

    public Translate(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Translate(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Detections detections() {
        return new Detections();
    }

    public Languages languages() {
        return new Languages();
    }

    public Translations translations() {
        return new Translations();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.19.1 of the Translate API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Translate.DEFAULT_ROOT_URL, Translate.DEFAULT_SERVICE_PATH, httpRequestInitializer, true);
        }

        public Translate build() {
            return new Translate(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setTranslateRequestInitializer(TranslateRequestInitializer translateRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)translateRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Translations {
        public List list(java.util.List<String> list, String string) throws IOException {
            List list2 = new List(list, string);
            Translate.this.initialize((AbstractGoogleClientRequest<?>)list2);
            return list2;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends TranslateRequest<TranslationsListResponse> {
            private static final String REST_PATH = "v2";
            @Key
            private java.util.List<String> q;
            @Key
            private String target;
            @Key
            private String source;
            @Key
            private String format;
            @Key
            private java.util.List<String> cid;

            protected List(java.util.List<String> list, String string) {
                super(Translate.this, "GET", REST_PATH, null, TranslationsListResponse.class);
                this.q = (java.util.List)Preconditions.checkNotNull(list, (Object)"Required parameter q must be specified.");
                this.target = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter target must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public java.util.List<String> getQ() {
                return this.q;
            }

            public List setQ(java.util.List<String> list) {
                this.q = list;
                return this;
            }

            public String getTarget() {
                return this.target;
            }

            public List setTarget(String string) {
                this.target = string;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public List setSource(String string) {
                this.source = string;
                return this;
            }

            public String getFormat() {
                return this.format;
            }

            public List setFormat(String string) {
                this.format = string;
                return this;
            }

            public java.util.List<String> getCid() {
                return this.cid;
            }

            public List setCid(java.util.List<String> list) {
                this.cid = list;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class Languages {
        public List list() throws IOException {
            List list = new List();
            Translate.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends TranslateRequest<LanguagesListResponse> {
            private static final String REST_PATH = "v2/languages";
            @Key
            private String target;

            protected List() {
                super(Translate.this, "GET", REST_PATH, null, LanguagesListResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getTarget() {
                return this.target;
            }

            public List setTarget(String string) {
                this.target = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Detections {
        public List list(java.util.List<String> list) throws IOException {
            List list2 = new List(list);
            Translate.this.initialize((AbstractGoogleClientRequest<?>)list2);
            return list2;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends TranslateRequest<DetectionsListResponse> {
            private static final String REST_PATH = "v2/detect";
            @Key
            private java.util.List<String> q;

            protected List(java.util.List<String> list) {
                super(Translate.this, "GET", REST_PATH, null, DetectionsListResponse.class);
                this.q = (java.util.List)Preconditions.checkNotNull(list, (Object)"Required parameter q must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public java.util.List<String> getQ() {
                return this.q;
            }

            public List setQ(java.util.List<String> list) {
                this.q = list;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }
}

