/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.model;

/**
 * The main translation request message for the Cloud Translation API.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Translation API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TranslateTextRequest extends com.google.api.client.json.GenericJson {

  /**
   * The format of the source text, in either HTML (default) or plain-text. A value of "html"
   * indicates HTML and a value of "text" indicates plain-text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String format;

  /**
   * The `model` type requested for this translation. Valid values are listed in public
   * documentation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String model;

  /**
   * The input text to translate. Repeat this parameter to perform translation operations on
   * multiple text inputs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> q;

  /**
   * The language of the source text, set to one of the language codes listed in Language Support.
   * If the source language is not specified, the API will attempt to identify the source language
   * automatically and return it within the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String source;

  /**
   * The language to use for translation of the input text, set to one of the language codes listed
   * in Language Support.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String target;

  /**
   * The format of the source text, in either HTML (default) or plain-text. A value of "html"
   * indicates HTML and a value of "text" indicates plain-text.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormat() {
    return format;
  }

  /**
   * The format of the source text, in either HTML (default) or plain-text. A value of "html"
   * indicates HTML and a value of "text" indicates plain-text.
   * @param format format or {@code null} for none
   */
  public TranslateTextRequest setFormat(java.lang.String format) {
    this.format = format;
    return this;
  }

  /**
   * The `model` type requested for this translation. Valid values are listed in public
   * documentation.
   * @return value or {@code null} for none
   */
  public java.lang.String getModel() {
    return model;
  }

  /**
   * The `model` type requested for this translation. Valid values are listed in public
   * documentation.
   * @param model model or {@code null} for none
   */
  public TranslateTextRequest setModel(java.lang.String model) {
    this.model = model;
    return this;
  }

  /**
   * The input text to translate. Repeat this parameter to perform translation operations on
   * multiple text inputs.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getQ() {
    return q;
  }

  /**
   * The input text to translate. Repeat this parameter to perform translation operations on
   * multiple text inputs.
   * @param q q or {@code null} for none
   */
  public TranslateTextRequest setQ(java.util.List<java.lang.String> q) {
    this.q = q;
    return this;
  }

  /**
   * The language of the source text, set to one of the language codes listed in Language Support.
   * If the source language is not specified, the API will attempt to identify the source language
   * automatically and return it within the response.
   * @return value or {@code null} for none
   */
  public java.lang.String getSource() {
    return source;
  }

  /**
   * The language of the source text, set to one of the language codes listed in Language Support.
   * If the source language is not specified, the API will attempt to identify the source language
   * automatically and return it within the response.
   * @param source source or {@code null} for none
   */
  public TranslateTextRequest setSource(java.lang.String source) {
    this.source = source;
    return this;
  }

  /**
   * The language to use for translation of the input text, set to one of the language codes listed
   * in Language Support.
   * @return value or {@code null} for none
   */
  public java.lang.String getTarget() {
    return target;
  }

  /**
   * The language to use for translation of the input text, set to one of the language codes listed
   * in Language Support.
   * @param target target or {@code null} for none
   */
  public TranslateTextRequest setTarget(java.lang.String target) {
    this.target = target;
    return this;
  }

  @Override
  public TranslateTextRequest set(String fieldName, Object value) {
    return (TranslateTextRequest) super.set(fieldName, value);
  }

  @Override
  public TranslateTextRequest clone() {
    return (TranslateTextRequest) super.clone();
  }

}
