/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.storage;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.storage.StorageRequest;
import com.google.api.services.storage.StorageRequestInitializer;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class Storage
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://storage.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "storage/v1beta1/";
    public static final String DEFAULT_BATCH_PATH = "batch/storage/v1beta1";
    public static final String DEFAULT_BASE_URL = "https://storage.googleapis.com/storage/v1beta1/";

    public Storage(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Storage(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public BucketAccessControls bucketAccessControls() {
        return new BucketAccessControls();
    }

    public Buckets buckets() {
        return new Buckets();
    }

    public ObjectAccessControls objectAccessControls() {
        return new ObjectAccessControls();
    }

    public Objects objects() {
        return new Objects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.3 of the Cloud Storage JSON API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Storage.DEFAULT_ROOT_URL, Storage.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Storage.DEFAULT_BATCH_PATH);
        }

        public Storage build() {
            return new Storage(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setStorageRequestInitializer(StorageRequestInitializer storageRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)storageRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Objects {
        public Delete delete(String bucket, String object__) throws IOException {
            Delete result = new Delete(bucket, object__);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String bucket, String object__) throws IOException {
            Get result = new Get(bucket, object__);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String bucket, StorageObject content) throws IOException {
            Insert result = new Insert(bucket, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String bucket, StorageObject content, AbstractInputStreamContent mediaContent) throws IOException {
            Insert result = new Insert(bucket, content, mediaContent);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String bucket) throws IOException {
            List result = new List(bucket);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String bucket, String object__, StorageObject content) throws IOException {
            Patch result = new Patch(bucket, object__, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String bucket, String object__, StorageObject content) throws IOException {
            Update result = new Update(bucket, object__, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String projection;

            protected Update(String bucket, String object__, StorageObject content) {
                super(Storage.this, "PUT", REST_PATH, (Object)content, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Update setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Update setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String projection;

            protected Patch(String bucket, String object__, StorageObject content) {
                super(Storage.this, "PATCH", REST_PATH, (Object)content, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Patch setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Patch setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends StorageRequest<com.google.api.services.storage.model.Objects> {
            private static final String REST_PATH = "b/{bucket}/o";
            @Key
            private String bucket;
            @Key
            private String delimiter;
            @Key(value="max-results")
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String prefix;
            @Key
            private String projection;

            protected List(String bucket) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.Objects.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getDelimiter() {
                return this.delimiter;
            }

            public List setDelimiter(String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public List setPrefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o";
            @Key
            private String bucket;
            @Key
            private String name;
            @Key
            private String projection;

            protected Insert(String bucket, StorageObject content) {
                super(Storage.this, "POST", REST_PATH, (Object)content, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.initializeMediaDownload();
            }

            protected Insert(String bucket, StorageObject content, AbstractInputStreamContent mediaContent) {
                super(Storage.this, "POST", "/upload/" + Storage.this.getServicePath() + REST_PATH, (Object)content, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public Insert setName(String name) {
                this.name = name;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Insert setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String projection;

            protected Get(String bucket, String object__) {
                super(Storage.this, "GET", REST_PATH, null, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Get setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;

            protected Delete(String bucket, String object__) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Delete setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class ObjectAccessControls {
        public Delete delete(String bucket, String object__, String entity) throws IOException {
            Delete result = new Delete(bucket, object__, entity);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String bucket, String object__, String entity) throws IOException {
            Get result = new Get(bucket, object__, entity);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String bucket, String object__, ObjectAccessControl content) throws IOException {
            Insert result = new Insert(bucket, object__, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String bucket, String object__) throws IOException {
            List result = new List(bucket, object__);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String bucket, String object__, String entity, ObjectAccessControl content) throws IOException {
            Patch result = new Patch(bucket, object__, entity, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String bucket, String object__, String entity, ObjectAccessControl content) throws IOException {
            Update result = new Update(bucket, object__, entity, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String entity;

            protected Update(String bucket, String object__, String entity, ObjectAccessControl content) {
                super(Storage.this, "PUT", REST_PATH, (Object)content, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Update setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Update setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String entity;

            protected Patch(String bucket, String object__, String entity, ObjectAccessControl content) {
                super(Storage.this, "PATCH", REST_PATH, (Object)content, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Patch setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Patch setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends StorageRequest<com.google.api.services.storage.model.ObjectAccessControls> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;

            protected List(String bucket, String object__) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.ObjectAccessControls.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public List setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;

            protected Insert(String bucket, String object__, ObjectAccessControl content) {
                super(Storage.this, "POST", REST_PATH, (Object)content, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getEntity(), "ObjectAccessControl.getEntity()");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getRole(), "ObjectAccessControl.getRole()");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Insert setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String entity;

            protected Get(String bucket, String object__, String entity) {
                super(Storage.this, "GET", REST_PATH, null, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Get setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Get setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String entity;

            protected Delete(String bucket, String object__, String entity) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)object__, (Object)"Required parameter object__ must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Delete setObject(String object__) {
                this.object__ = object__;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Delete setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Buckets {
        public Delete delete(String bucket) throws IOException {
            Delete result = new Delete(bucket);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String bucket) throws IOException {
            Get result = new Get(bucket);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(Bucket content) throws IOException {
            Insert result = new Insert(content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger projectId) throws IOException {
            List result = new List(projectId);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String bucket, Bucket content) throws IOException {
            Patch result = new Patch(bucket, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String bucket, Bucket content) throws IOException {
            Update result = new Update(bucket, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private String projection;

            protected Update(String bucket, Bucket content) {
                super(Storage.this, "PUT", REST_PATH, (Object)content, Bucket.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Update setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private String projection;

            protected Patch(String bucket, Bucket content) {
                super(Storage.this, "PATCH", REST_PATH, (Object)content, Bucket.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Patch setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends StorageRequest<com.google.api.services.storage.model.Buckets> {
            private static final String REST_PATH = "b";
            @Key
            private BigInteger projectId;
            @Key(value="max-results")
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String projection;

            protected List(BigInteger projectId) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.Buckets.class);
                this.projectId = (BigInteger)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public BigInteger getProjectId() {
                return this.projectId;
            }

            public List setProjectId(BigInteger projectId) {
                this.projectId = projectId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b";
            @Key
            private String projection;

            protected Insert(Bucket content) {
                super(Storage.this, "POST", REST_PATH, (Object)content, Bucket.class);
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getId(), "Bucket.getId()");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getProjectId(), "Bucket.getProjectId()");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProjection() {
                return this.projection;
            }

            public Insert setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private String projection;

            protected Get(String bucket) {
                super(Storage.this, "GET", REST_PATH, null, Bucket.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;

            protected Delete(String bucket) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class BucketAccessControls {
        public Delete delete(String bucket, String entity) throws IOException {
            Delete result = new Delete(bucket, entity);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String bucket, String entity) throws IOException {
            Get result = new Get(bucket, entity);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String bucket, BucketAccessControl content) throws IOException {
            Insert result = new Insert(bucket, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String bucket) throws IOException {
            List result = new List(bucket);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String bucket, String entity, BucketAccessControl content) throws IOException {
            Patch result = new Patch(bucket, entity, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String bucket, String entity, BucketAccessControl content) throws IOException {
            Update result = new Update(bucket, entity, content);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Update(String bucket, String entity, BucketAccessControl content) {
                super(Storage.this, "PUT", REST_PATH, (Object)content, BucketAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Update setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Patch(String bucket, String entity, BucketAccessControl content) {
                super(Storage.this, "PATCH", REST_PATH, (Object)content, BucketAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Patch setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends StorageRequest<com.google.api.services.storage.model.BucketAccessControls> {
            private static final String REST_PATH = "b/{bucket}/acl";
            @Key
            private String bucket;

            protected List(String bucket) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.BucketAccessControls.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl";
            @Key
            private String bucket;

            protected Insert(String bucket, BucketAccessControl content) {
                super(Storage.this, "POST", REST_PATH, (Object)content, BucketAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getEntity(), "BucketAccessControl.getEntity()");
                this.checkRequiredParameter((Object)content, "content");
                this.checkRequiredParameter(content.getRole(), "BucketAccessControl.getRole()");
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Get(String bucket, String entity) {
                super(Storage.this, "GET", REST_PATH, null, BucketAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Get setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Delete(String bucket, String entity) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Required parameter entity must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Delete setEntity(String entity) {
                this.entity = entity;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }
}

