/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.storage;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.storage.StorageRequest;
import com.google.api.services.storage.StorageRequestInitializer;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Storage
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "storage/v1beta1/";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/storage/v1beta1/";

    public Storage(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Storage(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public BucketAccessControls bucketAccessControls() {
        return new BucketAccessControls();
    }

    public Buckets buckets() {
        return new Buckets();
    }

    public ObjectAccessControls objectAccessControls() {
        return new ObjectAccessControls();
    }

    public Objects objects() {
        return new Objects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.23.0 of the Cloud Storage JSON API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Storage.DEFAULT_ROOT_URL, Storage.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Storage.DEFAULT_BATCH_PATH);
        }

        public Storage build() {
            return new Storage(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setStorageRequestInitializer(StorageRequestInitializer storageRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)storageRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Objects {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, StorageObject storageObject) throws IOException {
            Insert insert = new Insert(string, storageObject);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public Insert insert(String string, StorageObject storageObject, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Insert insert = new Insert(string, storageObject, abstractInputStreamContent);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, StorageObject storageObject) throws IOException {
            Patch patch = new Patch(string, string2, storageObject);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, StorageObject storageObject) throws IOException {
            Update update = new Update(string, string2, storageObject);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String projection;

            protected Update(String string, String string2, StorageObject storageObject) {
                super(Storage.this, "PUT", REST_PATH, (Object)storageObject, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter object__ must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Update setObject(String string) {
                this.object__ = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Update setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String projection;

            protected Patch(String string, String string2, StorageObject storageObject) {
                super(Storage.this, "PATCH", REST_PATH, (Object)storageObject, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter object__ must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Patch setObject(String string) {
                this.object__ = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Patch setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends StorageRequest<com.google.api.services.storage.model.Objects> {
            private static final String REST_PATH = "b/{bucket}/o";
            @Key
            private String bucket;
            @Key
            private String delimiter;
            @Key(value="max-results")
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String prefix;
            @Key
            private String projection;

            protected List(String string) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.Objects.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getDelimiter() {
                return this.delimiter;
            }

            public List setDelimiter(String string) {
                this.delimiter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public List setPrefix(String string) {
                this.prefix = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o";
            @Key
            private String bucket;
            @Key
            private String name;
            @Key
            private String projection;

            protected Insert(String string, StorageObject storageObject) {
                super(Storage.this, "POST", REST_PATH, (Object)storageObject, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.initializeMediaDownload();
            }

            protected Insert(String string, StorageObject storageObject, AbstractInputStreamContent abstractInputStreamContent) {
                super(Storage.this, "POST", "/upload/" + Storage.this.getServicePath() + REST_PATH, (Object)storageObject, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public Insert setName(String string) {
                this.name = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Insert setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StorageRequest<StorageObject> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String projection;

            protected Get(String string, String string2) {
                super(Storage.this, "GET", REST_PATH, null, StorageObject.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter object__ must be specified.");
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Get setObject(String string) {
                this.object__ = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/o/{object}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;

            protected Delete(String string, String string2) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter object__ must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Delete setObject(String string) {
                this.object__ = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class ObjectAccessControls {
        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, ObjectAccessControl objectAccessControl) throws IOException {
            Insert insert = new Insert(string, string2, objectAccessControl);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, String string3, ObjectAccessControl objectAccessControl) throws IOException {
            Patch patch = new Patch(string, string2, string3, objectAccessControl);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, String string3, ObjectAccessControl objectAccessControl) throws IOException {
            Update update = new Update(string, string2, string3, objectAccessControl);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String entity;

            protected Update(String string, String string2, String string3, ObjectAccessControl objectAccessControl) {
                super(Storage.this, "PUT", REST_PATH, (Object)objectAccessControl, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter object__ must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter entity must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Update setObject(String string) {
                this.object__ = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Update setEntity(String string) {
                this.entity = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String entity;

            protected Patch(String string, String string2, String string3, ObjectAccessControl objectAccessControl) {
                super(Storage.this, "PATCH", REST_PATH, (Object)objectAccessControl, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter object__ must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter entity must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Patch setObject(String string) {
                this.object__ = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Patch setEntity(String string) {
                this.entity = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends StorageRequest<com.google.api.services.storage.model.ObjectAccessControls> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;

            protected List(String string, String string2) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.ObjectAccessControls.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter object__ must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public List setObject(String string) {
                this.object__ = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;

            protected Insert(String string, String string2, ObjectAccessControl objectAccessControl) {
                super(Storage.this, "POST", REST_PATH, (Object)objectAccessControl, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter object__ must be specified.");
                this.checkRequiredParameter((Object)objectAccessControl, "content");
                this.checkRequiredParameter(objectAccessControl.getEntity(), "ObjectAccessControl.getEntity()");
                this.checkRequiredParameter((Object)objectAccessControl, "content");
                this.checkRequiredParameter(objectAccessControl.getRole(), "ObjectAccessControl.getRole()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Insert setObject(String string) {
                this.object__ = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StorageRequest<ObjectAccessControl> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String entity;

            protected Get(String string, String string2, String string3) {
                super(Storage.this, "GET", REST_PATH, null, ObjectAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter object__ must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter entity must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Get setObject(String string) {
                this.object__ = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Get setEntity(String string) {
                this.entity = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";
            @Key
            private String bucket;
            @Key(value="object")
            private String object__;
            @Key
            private String entity;

            protected Delete(String string, String string2, String string3) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.object__ = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter object__ must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter entity must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getObject() {
                return this.object__;
            }

            public Delete setObject(String string) {
                this.object__ = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Delete setEntity(String string) {
                this.entity = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Buckets {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(Bucket bucket) throws IOException {
            Insert insert = new Insert(bucket);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(BigInteger bigInteger) throws IOException {
            List list = new List(bigInteger);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, Bucket bucket) throws IOException {
            Patch patch = new Patch(string, bucket);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, Bucket bucket) throws IOException {
            Update update = new Update(string, bucket);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private String projection;

            protected Update(String string, Bucket bucket) {
                super(Storage.this, "PUT", REST_PATH, (Object)bucket, Bucket.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Update setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private String projection;

            protected Patch(String string, Bucket bucket) {
                super(Storage.this, "PATCH", REST_PATH, (Object)bucket, Bucket.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Patch setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends StorageRequest<com.google.api.services.storage.model.Buckets> {
            private static final String REST_PATH = "b";
            @Key
            private BigInteger projectId;
            @Key(value="max-results")
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String projection;

            protected List(BigInteger bigInteger) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.Buckets.class);
                this.projectId = (BigInteger)Preconditions.checkNotNull((Object)bigInteger, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public BigInteger getProjectId() {
                return this.projectId;
            }

            public List setProjectId(BigInteger bigInteger) {
                this.projectId = bigInteger;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b";
            @Key
            private String projection;

            protected Insert(Bucket bucket) {
                super(Storage.this, "POST", REST_PATH, (Object)bucket, Bucket.class);
                this.checkRequiredParameter((Object)bucket, "content");
                this.checkRequiredParameter(bucket.getId(), "Bucket.getId()");
                this.checkRequiredParameter((Object)bucket, "content");
                this.checkRequiredParameter(bucket.getProjectId(), "Bucket.getProjectId()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProjection() {
                return this.projection;
            }

            public Insert setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StorageRequest<Bucket> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;
            @Key
            private String projection;

            protected Get(String string) {
                super(Storage.this, "GET", REST_PATH, null, Bucket.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}";
            @Key
            private String bucket;

            protected Delete(String string) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String string) {
                this.bucket = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class BucketAccessControls {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, BucketAccessControl bucketAccessControl) throws IOException {
            Insert insert = new Insert(string, bucketAccessControl);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, BucketAccessControl bucketAccessControl) throws IOException {
            Patch patch = new Patch(string, string2, bucketAccessControl);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, BucketAccessControl bucketAccessControl) throws IOException {
            Update update = new Update(string, string2, bucketAccessControl);
            Storage.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Update(String string, String string2, BucketAccessControl bucketAccessControl) {
                super(Storage.this, "PUT", REST_PATH, (Object)bucketAccessControl, BucketAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter entity must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Update setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Update setEntity(String string) {
                this.entity = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Patch(String string, String string2, BucketAccessControl bucketAccessControl) {
                super(Storage.this, "PATCH", REST_PATH, (Object)bucketAccessControl, BucketAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter entity must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Patch setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Patch setEntity(String string) {
                this.entity = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends StorageRequest<com.google.api.services.storage.model.BucketAccessControls> {
            private static final String REST_PATH = "b/{bucket}/acl";
            @Key
            private String bucket;

            protected List(String string) {
                super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.BucketAccessControls.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public List setBucket(String string) {
                this.bucket = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl";
            @Key
            private String bucket;

            protected Insert(String string, BucketAccessControl bucketAccessControl) {
                super(Storage.this, "POST", REST_PATH, (Object)bucketAccessControl, BucketAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.checkRequiredParameter((Object)bucketAccessControl, "content");
                this.checkRequiredParameter(bucketAccessControl.getEntity(), "BucketAccessControl.getEntity()");
                this.checkRequiredParameter((Object)bucketAccessControl, "content");
                this.checkRequiredParameter(bucketAccessControl.getRole(), "BucketAccessControl.getRole()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Insert setBucket(String string) {
                this.bucket = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends StorageRequest<BucketAccessControl> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Get(String string, String string2) {
                super(Storage.this, "GET", REST_PATH, null, BucketAccessControl.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter entity must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Get setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Get setEntity(String string) {
                this.entity = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends StorageRequest<Void> {
            private static final String REST_PATH = "b/{bucket}/acl/{entity}";
            @Key
            private String bucket;
            @Key
            private String entity;

            protected Delete(String string, String string2) {
                super(Storage.this, "DELETE", REST_PATH, null, Void.class);
                this.bucket = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter bucket must be specified.");
                this.entity = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter entity must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getBucket() {
                return this.bucket;
            }

            public Delete setBucket(String string) {
                this.bucket = string;
                return this;
            }

            public String getEntity() {
                return this.entity;
            }

            public Delete setEntity(String string) {
                this.entity = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }
}

