/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storage.model;

/**
 * The storage layout configuration of a bucket.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BucketStorageLayout extends com.google.api.client.json.GenericJson {

  /**
   * The name of the bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bucket;

  /**
   * The bucket's custom placement configuration for Custom Dual Regions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CustomPlacementConfig customPlacementConfig;

  /**
   * The bucket's hierarchical namespace configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HierarchicalNamespace hierarchicalNamespace;

  /**
   * The kind of item this is. For storage layout, this is always storage#storageLayout.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The location of the bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * The type of the bucket location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String locationType;

  /**
   * The name of the bucket.
   * @return value or {@code null} for none
   */
  public java.lang.String getBucket() {
    return bucket;
  }

  /**
   * The name of the bucket.
   * @param bucket bucket or {@code null} for none
   */
  public BucketStorageLayout setBucket(java.lang.String bucket) {
    this.bucket = bucket;
    return this;
  }

  /**
   * The bucket's custom placement configuration for Custom Dual Regions.
   * @return value or {@code null} for none
   */
  public CustomPlacementConfig getCustomPlacementConfig() {
    return customPlacementConfig;
  }

  /**
   * The bucket's custom placement configuration for Custom Dual Regions.
   * @param customPlacementConfig customPlacementConfig or {@code null} for none
   */
  public BucketStorageLayout setCustomPlacementConfig(CustomPlacementConfig customPlacementConfig) {
    this.customPlacementConfig = customPlacementConfig;
    return this;
  }

  /**
   * The bucket's hierarchical namespace configuration.
   * @return value or {@code null} for none
   */
  public HierarchicalNamespace getHierarchicalNamespace() {
    return hierarchicalNamespace;
  }

  /**
   * The bucket's hierarchical namespace configuration.
   * @param hierarchicalNamespace hierarchicalNamespace or {@code null} for none
   */
  public BucketStorageLayout setHierarchicalNamespace(HierarchicalNamespace hierarchicalNamespace) {
    this.hierarchicalNamespace = hierarchicalNamespace;
    return this;
  }

  /**
   * The kind of item this is. For storage layout, this is always storage#storageLayout.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of item this is. For storage layout, this is always storage#storageLayout.
   * @param kind kind or {@code null} for none
   */
  public BucketStorageLayout setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The location of the bucket.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * The location of the bucket.
   * @param location location or {@code null} for none
   */
  public BucketStorageLayout setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * The type of the bucket location.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocationType() {
    return locationType;
  }

  /**
   * The type of the bucket location.
   * @param locationType locationType or {@code null} for none
   */
  public BucketStorageLayout setLocationType(java.lang.String locationType) {
    this.locationType = locationType;
    return this;
  }

  @Override
  public BucketStorageLayout set(String fieldName, Object value) {
    return (BucketStorageLayout) super.set(fieldName, value);
  }

  @Override
  public BucketStorageLayout clone() {
    return (BucketStorageLayout) super.clone();
  }

  /**
   * The bucket's custom placement configuration for Custom Dual Regions.
   */
  public static final class CustomPlacementConfig extends com.google.api.client.json.GenericJson {

    /**
     * The list of regional locations in which data is placed.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> dataLocations;

    /**
     * The list of regional locations in which data is placed.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getDataLocations() {
      return dataLocations;
    }

    /**
     * The list of regional locations in which data is placed.
     * @param dataLocations dataLocations or {@code null} for none
     */
    public CustomPlacementConfig setDataLocations(java.util.List<java.lang.String> dataLocations) {
      this.dataLocations = dataLocations;
      return this;
    }

    @Override
    public CustomPlacementConfig set(String fieldName, Object value) {
      return (CustomPlacementConfig) super.set(fieldName, value);
    }

    @Override
    public CustomPlacementConfig clone() {
      return (CustomPlacementConfig) super.clone();
    }

  }

  /**
   * The bucket's hierarchical namespace configuration.
   */
  public static final class HierarchicalNamespace extends com.google.api.client.json.GenericJson {

    /**
     * When set to true, hierarchical namespace is enabled for this bucket.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean enabled;

    /**
     * When set to true, hierarchical namespace is enabled for this bucket.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getEnabled() {
      return enabled;
    }

    /**
     * When set to true, hierarchical namespace is enabled for this bucket.
     * @param enabled enabled or {@code null} for none
     */
    public HierarchicalNamespace setEnabled(java.lang.Boolean enabled) {
      this.enabled = enabled;
      return this;
    }

    @Override
    public HierarchicalNamespace set(String fieldName, Object value) {
      return (HierarchicalNamespace) super.set(fieldName, value);
    }

    @Override
    public HierarchicalNamespace clone() {
      return (HierarchicalNamespace) super.clone();
    }

  }

}
